# Copyright (c) 2014 by Cisco Systems, Inc.
# All rights reserved
#!/bin/sh

MAX_WAIT=60

LOGG_INFO="logger -t CAF -p user.info"

if [ ! -f /var/run/caf.pid ] ; then
    $LOGG_INFO "Cannot find CAF's pid file /var/run/caf.pid"
    exit 0
fi


# Send SIGINT to CAF process
pid=`cat /var/run/caf.pid`
$LOGG_INFO "Stopping CAF (pid:$pid)."
/bin/kill -9 $pid > /dev/null 2>&1

# CAF stopped on it's own, great!
$LOGG_INFO "CAF stopped successfully"
exit 0
