#! /bin/bash
#
# Available PD hooks and inputs for VM type application lifecycle
# Environment variables defined in app yaml are also accessible from this PD script
#
# Return codes:
# Only least significant 8 bits of the return code is retained (POSIX convention)
# eg. return code -1 is interpreted as 255
# Non-zero return codes < 127 are reported as errors in CAF log, but CAF operation won't terminate 
# Return codes >=128 are considered fatal and will cause CAF to terminate the lifecycle operation
#

handle_pre_deploy() {
    exit 0
}

handle_post_deploy() {
    exit 0
}

handle_pre_activate() {
    exit 0
}

handle_post_activate() {
    exit 0
}

handle_pre_start() {
    exit 0
}

handle_post_start() {
    exit 0
}

handle_pre_stop() {
    exit 0
}

handle_post_stop() {
    exit 0
}

handle_pre_deactivate() {
    exit 0
}

handle_post_deactivate() {
    exit 0
}

handle_pre_uninstall() {
    exit 0
}

handle_post_uninstall() {
    exit 0
}

case "$1" in
    pre-deploy)
        # $2: <app_id>
        # $3: <app_repo_dir>
        # Call function here to handle PD pre-deploy action
        handle_pre_deploy
        ;;
    post-deploy)
        # $2: <app_id>
        # $3: <app_repo_dir>
        # $4: <app_extracted_dir>
        # Call function here to handle PD post-deploy action
        handle_post_deploy
        ;;
    pre-activate)
        # $2: <app_id>
        # $3: <activation_payload>
        # Call function here to handle PD pre-activate action
        handle_pre_activate
        ;;
    post-activate)
        # $2: <app_id>
        # $3: <dst_rootfs>
        # $4: <activation_payload>
        # Call function here to handle PD post-activate action
        handle_post_activate
        ;;
    pre-start)
        # $2: <app_id>
        # Call function here to handle PD pre-start action
        handle_pre_start
        ;;
    post-start)
        # $2: <app_id>
        # Call function here to handle PD post-start action
        handle_post_start
        ;;
    pre-stop)
        # $2: <app_id>
        # Call function here to handle PD pre-stop action
        handle_pre_stop
        ;;
    post-stop)
        # $2: <app_id>
        # Call function here to handle PD post-stop action
        handle_post_stop
        ;;
    pre-deactivate)
        # $2: <app_id>
        # $3: <rootfs_dir>
        # Call function here to handle PD pre-deactivate action
        handle_pre_deactivate
        ;;
    post-deactivate)
        # $2: <app_id>
        # Call function here to handle PD post-deactivate action
        handle_post_deactivate
        ;;
    pre-uninstall)
        # $2: <app_id>
        # Call function here to handle PD pre-uninstall action
        handle_pre_uninstall
        ;;
    post-uninstall)
        # $2: <app_id>
        # Call function here to handle PD post-uninstall action
        handle_post_uninstall
        ;;
    *)
        # Do nothing
        exit 0
	    ;;
esac
exit 0
