'''
Created on Nov 12, 2012

@author: shawnwan

Copyright (c) 2012 by Cisco Systems, Inc.
All rights reserved.
'''

import falcon
from  systemhealthinfo import SystemHealthInfo
from apiservice import  ResourceRoute
from common import AuthenticatedResource, make_response

from jsonencoder import JSONEncoder
jsonencoder = JSONEncoder()


@ResourceRoute("/platform/health", endpoint="platform_health")
class SystemHealthResourceHandler(AuthenticatedResource):

    def on_get(self, request, response):
        sinfo = SystemHealthInfo()
        out = jsonencoder.encode(sinfo.get_system_health())
        response = make_response(response, out, falcon.HTTP_200)
        response.set_header('Content-Type', "application/json")
        response.set_header('Cache-Control', "no-cache")
