__author__ = 'madawood'

import jsl


class AppInfo(jsl.Document):
    author_link = jsl.StringField(name="author-link", required=False)
    author_name = jsl.StringField(name="author-name", required=False)
    description = jsl.StringField(name="description", required=False)
    name = jsl.StringField(name="name", required=True)
    version = jsl.StringField(name="version", required=True)
    

class PackageDescriptorV1(jsl.Document):
    """
    IOX package schema version 1.0 .
    """

    class Options(object):
        description = 'Schema for IOx application descriptor - version 1.0'

    manifest_version = jsl.OneOfField([jsl.StringField(), jsl.NumberField()],name="manifest-version", required=True)
    info = jsl.DocumentField(AppInfo, name="info", as_ref=True, required=True)
    app = jsl.OneOfField([jsl.DictField({"apptype":jsl.StringField(enum=['vm'],required=True)},required=True)], required=True)