#-----------------------------------------------------
#
# Copyright (c) by cisco Systems Inc.
# All rights reserved.
#-----------------------------------------------------

#
# This file is manually created as reference to macros, return codes and flags that are referred in smart agent and
# call home library. Please check the reference for updating the flags/codes in future
#

# Refer this file in generic call home library for orifinal reference
# generic_call_home/call-home/include/ch_debug_common.h
class CallHomeDebugFlags(object):
    # disable call-home debug
    CH_DBG_FLAG_NONE = 0x00
    # call-home detail debug flag
    CH_DBG_FLAG_DETAIL = 0x01
    # call-home trace debug flag
    CH_DBG_FLAG_TRACE  = 0x02
    # call-home error debug flag
    CH_DBG_FLAG_ERROR = 0x04

# Refer this link for smart agent return code definitions
# http://elo-repo:8080/sla-apis-latest/SmartAgentCommonAPIStruct_8h.html
class SmartAgentReturnCodes(object):
    SmartAgentSuccess = 0
    SmartAgentErrorMalloc = 1
    SmartAgentErrorNullPointer = 2
    SmartAgentError3 = 3
    SmartAgentError4 = 4
    SmartAgentError5 = 5
    SmartAgentErrorBadInputParams = 6
    SmartAgentError7 = 7
    SmartAgentErrorBadHandle = 8
    SmartAgentErrorNotFound = 9
    SmartAgentErrorNotSupported = 10
    SmartAgentErrorAlreadyInit = 11
    SmartAgentErrorNotInit = 12
    SmartAgentErrorSMFailToCreate = 13
    SmartAgentErrorSMFailToRun = 14
    SmartAgentErrorSMFailToInit = 15
    SmartAgentErrorSMFailToDestroy = 16
    SmartAgentErrorMsgParse = 17
    SmartAgentErrorMsgBuild = 18
    SmartAgentErrorNotEnabled = 19
    SmartAgentErrorInvalidRequest = 20
    SmartAgentErrorInit = 21
    SmartAgentErrorFailToSetState = 22
    SmartAgentErrorUnsupportedResponse = 23
    SmartAgentErrorInvalidResponse = 24
    SmartAgentErrorStorageFailToStore = 25
    SmartAgentErrorStorageFailToRetrieve = 26
    SmartAgentErrorNullCcoIdToken = 27
    SmartAgentErrorMatchIdentifier = 28
    SmartAgentErrorMatchVendor = 29
    SmartAgentErrorMatchNonce = 30
    SmartAgentErrorCommDisabled = 31
    SmartAgentErrorCommSend = 32
    SmartAgentErrorCommResponse = 33
    SmartAgentErrorCommUnkown = 34
    SmartAgentErrorSMPostNotAllow = 35
    SmartAgentErrorReqMsgMissingMandatoryField = 36
    SmartAgentErrorResponseFailed = 37
    SmartAgentErrorPINotInit = 38
    SmartAgentErrorAlreadyEnabled = 39
    SmartAgentErrorAlreadyRegistered = 40
    SmartAgentErrorCertInvalid = 41
    SmartAgentErrorCertExpired = 42
    SmartAgentErrorNotRegistered = 43
    SmartAgentErrorCSRGenerationFailed = 44
    SmartAgentErrorVerifySignatureFailed = 45
    SmartAgentErrorGenerateSignatureFailed = 46
    SmartAgentErrorSignCertVerificationFailed = 47
    SmartAgentErrorNodeCertVerificationFailed = 48
    SmartAgentErrorParseCertificateFailed = 49
    SmartAgentErrorCryptoRootCAImportFailed = 50
    SmartAgentErrorTagInvalid = 51
    SmartAgentErrorStandby = 52
    SmartAgentRegistrationInProgress = 53
    SmartAgentErrorCommRetry = 54
    SmartAgentAuthRenewInProgress = 55
    SmartAgentIdCertRenewInProgress = 56
    SmartAgentErrorNoUdiChange = 57
    SmartAgentErrorCallhomeServiceOff = 58
    SmartAgentMsgExecInProgress = 59
    SmartAgentMsgExecInProgLocked = 60
    SmartAgentCertMatchesSubsetUdis = 61
    SmartAgentStorageGroupChangeIncomplete = 62
    SmartAgentStorageMgmtNotInit = 63
    SmartAgentErrorTSPathNotChanged = 64
    SmartAgentErrorCryptoInitNotCompleted = 65
    SmartAgentErrorNotInUnidentified = 66
    SmartAgentErrorPlatformPathInvalid = 67
    SmartAgentErrorPlatformUdiInvalid = 68
    SmartAgentErrorStorageObjFailToCreate = 69
    SmartAgentErrorStorageObjFailToErase = 70
    SmartAgentErrorStorageObjDoesNotExist = 71
    SmartAgentErrorMessageEventExceedsPeer = 72
    SmartAgentErrorCodeValidationFailed = 73
    SmartAgentErrorReserved = 74
    SmartAgentErrorNoReservationInProgress = 75
    SmartAgentErrorNoAuthorizationInstalled = 76
    SmartAgentErrorReservationMismatch = 77
    SmartAgentErrorNotReservationMode = 78
    SmartAgentErrorReservationError = 79
    SmartAgentErrorSysmgrInit = 80
    SmartAgentErrorAlreadyExists = 81
    SmartAgentErrorListInsertFailed = 82
    SmartAgentErrorSessionMgmtNotInit = 83
    SmartAgentErrorListInitFailed = 84
    SmartAgentErrorListBusy = 85
    SmartAgentErrorNoClients = 86
    SmartAgentErrorIPC = 87
    SmartAgentErrorIPCOpen = 88
    SmartAgentErrorIPCInit = 89
    SmartAgentErrorIPCConnect = 90
    SmartAgentErrorIPCEvents = 91
    SmartAgentErrorIPCMgmt = 92
    SmartAgentErrorIPCSend = 93
    SmartAgentErrorIPCReceive = 94
    SmartAgentErrorIPCTimeOut = 95
    SmartAgentErrorEnqueueFailed = 96
    SmartAgentErrorDequeueFailed = 97
    SmartAgentErrorShuttingDown = 98
    SmartAgentCouldNotValidateTrustChain = 99
    SmartAgentErrorReservationAlreadyInstalled = 100
    SmartAgentErrorReservationInstallParseFail = 101
    SmartAgentErrorBase64Encoding = 102
    SmartAgentErrorBase64Decoding = 103
    SmartAgentErrorInvalidSoftwareIdTag = 104
    SmartAgentErrorCertificateMismatch = 105
    SmartAgentErrorNoReservation = 106
    SmartAgentErrorAgentUnreachable = 107
    SmartAgentErrorIgnoreEvent = 108
    SmartAgentErrorB58Overflow = 109
    SmartAgentErrorB58Decode = 110
    SmartAgentErrorB58BadLen = 111
    SmartAgentErrorB58InvDigit = 112
    SmartAgentErrorB58DecodeOverflow = 113
    SmartAgentErrorReservationVersionOutOfBound = 114
    SmartAgentErrorBase58Encode = 115
    SmartAgentErrorDuplicatedEntry = 116
    SmartAgentErrorMissingEntry = 117
    SmartAgentErrorBadPeerInfoFormat = 118
    SmartAgentErrorBadApplicationHAAttributeDataset = 119
    SmartAgentErrorReservationInProgress = 120
    SmartAgentErrorXdmCreateHandle = 121
    SmartAgentErrorVersionMismatchInEntitlementRsp = 122
    SmartAgentErrorHARoleNotSupported = 123
    SmartAgentErrorAppHaInvalidCharacter = 124
    SmartAgentErrorAppHaAddPeerFromSameDevice = 125
    SmartAgentErrorAppHaAppDuplicatedInstance = 126
    SmartAgentErrorVersionMismatchInRegResponse = 127
    SmartAgentErrorConversionNoCB = 128
    SmartAgentErrorConversionNotAllowed = 129
    SmartAgentErrorConversionInProgress = 130
    SmartAgentErrorConversionAlreadyStarted = 131
    SmartAgentErrorConversionNotEnabled = 132
    SmartAgentErrorVersionConversionNotSupported = 133
    SmartAgentErrorNoConversionInProgress = 134
    SmartAgentErrorCryptoVersionMismatch = 135
    SmartAgentErrorConversionStoppedPartially = 136
    SmartAgentErrorUtility = 137
    SmartAgentErrorUtilityNotEnabled = 138
    SmartAgentErrorTransportNotAvailable = 139
    SmartAgentErrorFQDN = 140
    SmartAgentErrorThirdparty = 141
    SmartAgentErrorMax = 142

class SmartAgentDebugFlags(object):
    SMART_AGENT_DEBUG_FLAG_ALL = 0x0F
    SMART_AGENT_DEBUG_ERROR = 0x01
    SMART_AGENT_DEBUG_TRACE = 0x02
    SMART_AGENT_DEBUG_DEBUG = 0x04
    SMART_AGENT_DEBUG_CONSOLE =  0x08

# Refer SmartAgentNotificationAPIStruct.h file in smart agent for original enum definition
class SmartAgentNotification(object):
    SmartAgentNotifyInvalid = 0
    SmartAgentNotifyReady = 1
    SmartAgentNotifyEnabled = 2
    SmartAgentNotifyRegisterFailed = 3
    SmartAgentNotifyEnforcementMode = 4
    SmartAgentNotifyRegisterSuccess = 5
    SmartAgentNotifyIdCertExpired = 6
    SmartAgentNotifyIdCertRenewSuccess = 7
    SmartAgentNotifyIdCertRenewFail = 8
    SmartAgentNotifyAuthRenewSuccess = 9
    SmartAgentNotifyAuthRenewFailure = 10
    SmartAgentNotifyCommFailure = 11
    SmartAgentCommRestored = 12
    SmartAgentNotifyIdCertNotStarted = 13
    SmartAgentNotifyHARole = 14
    SmartAgentNotifyHAChassisRole = 15
    SmartAgentNotifyTest = 16
    SmartAgentNotifyIdCertOutOfRange = 17
    SmartAgentNotifySystemClockChanged = 18
    SmartAgentNotifyDisabled = 19
    SmartAgentNotifyEvalExpiryWarning = 20
    SmartAgentNotifyEvalExpired = 21
    SmartAgentNotifyIdCertExpiryWarning = 22
    SmartAgentNotifyExportControlled = 23
    SmartAgentNotifyReservationInstalled = 24
    SmartAgentNotifyReservationReturned = 25
    SmartAgentNotifyReservationInProgress = 26
    SmartAgentNotifyReservationCanceled = 27
    SmartAgentNotifyReservationAuthFailed = 28
    SmartAgentNotifyDeRegisterSuccess = 29
    SmartAgentNotifyDeprecatedApi = 30
    SmartAgentNotifyDeRegisterFailed = 31
    SmartAgentNotifyConfigNotSaved = 32
    SmartAgentNotifyReservationHAConfigMismatch = 33
    SmartAgentNotifyConfigNotSavedTSClear = 34
    SmartAgentNotifyXdmDispatchLoopFailed = 35
    SmartAgentNotifyHandleAttrVersionMismatch = 36
    SmartAgentNotifyAppHADuplicatedPeer = 37
    SmartAgentNotifyAppHAMissingPeer = 38
    SmartAgentNotifyAppHAInfoForPeerChanged = 39
    SmartAgentNotifyAppHATryingAddItselfAsPeer = 40
    SmartAgentNotifyAppHADuplicateInstanceFound = 41
    SmartAgentNotifyConversionStarted = 42
    SmartAgentNotifyConversionStatus = 43
    SmartAgentNotifyConversionComplete = 44
    SmartAgentNotifyConversionGet = 45
    SmartAgentNotifyThirdpartyModeEnabled = 46
    SmartAgentNotifyThirdpartyModeDisabled = 47
    SmartAgentNotifyUtilityCertExpired = 48
    SmartAgentNotifyUtilityCertRenewFailed = 49
    SmartAgentNotifyUtilityCertRenewSuccess = 50
    SmartAgentNotifyUtilityDataReportingStarted = 51
    SmartAgentNotifyUtilityDataReportingStopped = 52
    SmartAgentNotifyUtilitySendRUMFailed = 53
    SmartAgentNotifyUtilityCertFQDNMismatch = 54
    SmartAgentNotifyMax = 55

# Refer SmartAgentCommonAPIStruct.h file in smart agent for original definition
class SmartAgentEntitlementEnforceMode(object):
    SmartAgentEnforceModeInvalid = 0
    SmartAgentEnforceModeInit = 1
    SmartAgentEnforceModeWaiting = 2
    SmartAgentEnforceModeInCompliance = 3
    SmartAgentEnforceModeOutOfCompliance = 4
    SmartAgentEnforceModeOverage = 5
    SmartAgentEnforceModeEval = 6
    SmartAgentEnforceModeEvalExpired = 7
    SmartAgentEnforceModeGracePeriod = 8
    SmartAgentEnforceModeAuthorizationExpired = 8
    SmartAgentEnforceModeGracePeriodExpired = 9
    SmartAgentEnforceModeDisabled = 10
    SmartAgentReserveEnforceModeInCompliance = 11
    SmartAgentEnforceModeInvalidTag = 12
    SmartAgentEnforceModeMax = 13
