__author__ = 'hvishwanath'


class LibvirtXMLGenerator(object):
    XML_TEMPLATE = """

<domain type={DOMAIN_TYPE}>
  <name>{APPID}</name>
  {UUID}
  <memory>{MEMORY}</memory>
    <cputune>
      <shares>{CPU}</shares>
    </cputune>
  <resource>
  <partition>{CGROUP_PARENT}</partition>
  </resource>
  {OS}
  {FEATURES}
  <vcpu>{VCPU}</vcpu>
  {CPU_TOPOLOGY}
  <clock offset="utc"/>
  <on_poweroff>destroy</on_poweroff>
  <on_reboot>restart</on_reboot>
  <on_crash>destroy</on_crash>
  <devices>
    <emulator>{EMULATOR}</emulator>
    {CONTROLLER}
    {INTERFACE}
    {CDROM}
    {DISKS}
    {INPUTS}
    {ROOTFS}
    {APP}
    {DATA_MOUNT}
    {MOUNT_LIST}
    {CARTRIDGE}
    {DEVICE_LIST}
    {CONSOLE}
    {GRAPHICS}
    {CHARDEV}
    <console type="pty" />
    {GUEST_ADDON}
  </devices>
  {QEMU_COMMANDLINE}
  {SECURITY_LABEL}
  {FEATURE_CAPABILITIES}
</domain>

    """


    @classmethod
    def generate_libvirt_xml(cls, domain_type, appid, memory, cpu, cgroup_parent, os,
                             emulator, vcpu, controller=None, interface=None,
                             rootfs=None, data_mount=None, mount_list= None, app=None, cartridge=None,
                             device_list=None, console=None, guest_addon=None, qemu_commandline=None,
                             sec_attr = None, feature_capabilities = None, disks=None, cdrom=None,graphics=None,
                             inputs=None, features=None, chardev=None, cpu_topology=None, uuid=None):
        """
        Generate a compatible libvirt xml file from CAF specific app manifest yaml file.
        :param appmanifest:
        :return:
        """
        #TODO: Enhance this to generate xml on the fly, instead of string substitution

        if controller is None:
            controller = ""

        if interface is None:
            interface=""

        if data_mount is None:
            data_mount=""

        if rootfs is None:
            rootfs=""

        if mount_list is None:
            mount_list=""

        if app is None:
            app=""

        if cartridge is None:
            cartridge = ""

        if device_list is None:
            device_list = ""

        if console is None:
            console = ""
            
        if chardev is None:
            chardev = ""

        if guest_addon is None:
            guest_addon = ""

        if qemu_commandline is None:
            qemu_commandline = ""

        if feature_capabilities is None:
            feature_capabilities = ""

        if sec_attr is None:
            sec_attr = ""

        if inputs is None:
            inputs = ""

        if cdrom is None:
            cdrom = ""

        if disks is None:
            disks = ""

        if features is None:
            features = ""

        if graphics is None:
            graphics = ""

        if cpu_topology is None:
            cpu_topology = ""

        if uuid is None:
            uuid = ""
        else:
            uuid = "<uuid>" + uuid + "</uuid>"

        libvirt_xml = cls.XML_TEMPLATE.format(DOMAIN_TYPE=domain_type,
                                              APPID=appid,
                                              MEMORY=memory,
                                              CPU=cpu,
                                              UUID=uuid,
                                              OS=os,
                                              EMULATOR=emulator,
                                              VCPU=vcpu,
                                              CONTROLLER=controller,
                                              INTERFACE=interface,
                                              ROOTFS=rootfs,
                                              APP=app,
                                              DATA_MOUNT=data_mount,
                                              MOUNT_LIST=mount_list,
                                              CARTRIDGE=cartridge,
                                              DEVICE_LIST=device_list,
                                              CONSOLE=console,
                                              GUEST_ADDON=guest_addon,
                                              CGROUP_PARENT=cgroup_parent,
                                              QEMU_COMMANDLINE=qemu_commandline,
                                              SECURITY_LABEL=sec_attr,
                                              FEATURE_CAPABILITIES=feature_capabilities,
                                              FEATURES=features,
                                              CDROM=cdrom,
                                              DISKS=disks,
                                              INPUTS=inputs,
                                              GRAPHICS=graphics,
                                              CHARDEV=chardev,
                                              CPU_TOPOLOGY=cpu_topology
                                              )

        return libvirt_xml
