import os
import random
from appfw.utils.infraexceptions import *

LOWER_ALPHA = "abcdefghijklmnopqrstuvwxyz"
UPPER_ALPHA = LOWER_ALPHA.upper()
ALL_ALPHA = LOWER_ALPHA + UPPER_ALPHA

def ensure_directory(path):
    if os.path.exists(path):
        if os.path.isdir(path):
            return True
        else:
            raise IsNotADirectory("Path %s is not a directory", path)
    raise PathDoesNotExist("Path does not exist: %s", path)

def ensure_directories(*paths):
    for path in paths:
        if isinstance(path, list) or isinstance(path, tuple):
            for subpath in path:
                ensure_directory(subpath)
        else:
            ensure_directory(path)

def random_name(length=10):
    letter_list = []
    for i in range(length):
        letter_list.append(random.choice(ALL_ALPHA))
    return ''.join(letter_list)
