#-----------------------------------------------------
#
# Copyright (c) 2012 by cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------

'''
@author: alhu
'''

class Error(object):
    '''
    This class represents error information.
    '''
    def __init__(self, error_code, category, desc):
        self._error_code = error_code
        self._category   = category
        self._desc       = desc

    @property
    def error_code(self):
        return self._error_code

    @error_code.setter
    def error_code(self, value):
        self._error_code = value

    @property
    def category(self):
        return self._category

    @category.setter
    def category(self, value):
        self._category = value

    @property
    def description(self):
        return self._desc

    @description.setter
    def description(self, value):
        self._desc = value

    def get_object(self):
        obj = {}
        obj['error'] = {}
        #TODO: Will introduce error code in later releases.
        #      When introduced, uncomment the following line.
        #obj['error']['error_code']  = self._error_code
        obj['error']['category']    = self._category
        obj['error']['description'] = self._desc
        return obj


class ErrorCategory(object):
    '''
    This class defines all the error categories.
    '''
    UNKNOWN        = 'Unknown'
    VALIDATION     = 'Validation'      # Validation errors
    AUTHENTICATION = 'Authentication'  # Authentication errors


