import pickle

from threading import RLock
__all__ = ["TaskRegistry"]

class TaskRegistry(object):
    def __init__(self):
        self._registry = {}
        self._lock = RLock()

    def task_to_string(self, task):
        return '%s' % (task.__name__)

    def register(self, task):
        task_str = task.task_id
        self._lock.acquire()
        try:
            if task_str not in self._registry:
                self._registry[task_str] = task
        finally:
            self._lock.release()

    def unregister(self, task):
        task_str = task.task_id
        self._lock.acquire()
        try:
            if task_str in self._registry:
                del(self._registry[task_str])
        finally:
            self._lock.release()

    def get_task(self, task_id):
        with self._lock:
            task = self._registry.get(task_id)
            if not task:
                return None
            return task

    def get_all_tasks(self):
        tasks = []
        with self._lock:
            for task_id in self._registry:
                task = self._registry[task_id]
                tasks.append(task.serialize())
            return tasks

    def get_all_task_ids(self):
        task_list = []
        with self._lock:
            for task_id in self._registry:
                task_list.append(task_id)
            return task_list

    # def revoke_all_tasks(self):
    #     with self._lock:
    #         for task_id in self._registry:
    #             task = self.get_task(task_id)
    #             task.revoke()
    #             self.unregister(task)
