#!/bin/sh
# This is platform specific script which handles how to restart docker daemon on the given platform
# Basic template of this script includes function handlers like err(), info(), stop(), start(), restart() and switch case
# Usage of this script:
# $ dockerd_restart.sh <start/stop/restart>
progname="dockerd"
exec="/usr/bin/dockerd"
logdir="/var/log"
logfile="$logdir/$progname"


err()
{
    echo `date` "[dockerd_restart_script]" "$@" >> $logfile
}

info()
{
    echo `date` "[dockerd_restart_script]" "$@" >> $logfile
}

pidofproc () {

        # pidof output null when no program is running, so no "2>/dev/null".
        pid=`pidof $1`
        status=$?
        case $status in
        0)
                echo $pid
                return 0
                ;;
        127)
                err "ERROR: command pidof not found" >&2
                exit 127
                ;;
        *)
                return $status
                ;;
        esac
}

killproc() {
        pid=`pidofproc $1` && kill $pid
        return $?
}

wait_till_dockerd_exits(){
    count=30
    info $count
    until [ $count -le 0 ]; do
        dockerpid=`pidofproc $progname`
        if [ $dockerpid ]; then
            sleep 1
            count=$[$count-1]
            info "waiting for dockerd to exit"
        else
            info "Dockerd process exited"
            break
        fi
    done

    if [ $count -le 0 ]; then
        err  "Dockerd failed to exit"
        return -1
    fi
    return 0
}

wait_till_dockerd_starts(){
    count=30
    info $count
    until [ $count -le 0 ]; do
        dockerpid=`pidofproc $progname`
        if [ $dockerpid ]; then
            if [ $dockerpid -gt 0 ]; then
                info "Dockerd process started"
                break
            fi
        fi
        sleep 1
        count=$[$count-1]
        info "waiting for dockerd to start"
    done

    if [ $count -le 0 ]; then
        err  "Dockerd failed to start"
        return -1
    fi
    return 0
}

start(){
    # Dummy start fn for now
    # TODO: Add restart logic that is consistent across all ubuntu distro docker installation
    return 0
    #info "Starting process $progname"
    #$exec &>> $logfile &
    #wait_till_dockerd_starts
    #return $?
}

stop(){
    # Dummy stop fn for now
    # TODO: Add restart logic that is consistent across all ubuntu distro docker installation
    return 0
    #info "Stopping process $progname"
    #killproc $progname
    #wait_till_dockerd_exits
    #return $?
}

restart(){
    stop
    if [ $? -ne 0 ]; then
        err "Failed to stop process $progname"
        exit -1
    fi
    start
    if $? -ne 0 ]; then
        err "Failed to bringup process $progname"
        exit -1
    fi
    return 0
}

case "$1" in
    start)
        $1
        ;;
    stop)
        $1
        ;;
    restart)
        $1
        ;;
    *)
        err $"Usage: $0 {start|stop|restart}"
        exit 2
esac
info "exiting dockerd_restart script"
exit $?