#! /bin/ash
#
# Available PD hooks and inputs for CAF
#
export PATH=/bin:/sbin:/usr/bin:/var/wireless:/usr/sbin:/opt/cisco/bin
handle_caf_up() {
    # Sending IPC_IOX_CAF_STATUS message to capwapd to
    # indicate that CAF is up
    send_ipc capwap caf_status 1
    send_ipc grpc caf_status up
    exit 0
}

handle_caf_down() {
    send_ipc capwap caf_status 0
    send_ipc grpc caf_status down
    exit 0
}


case "$1" in
    caf-up)
        # Call function here to handle PD caf-up action
        handle_caf_up
        ;;

    caf-down)
        # Call function here to handle PD caf-down action
        handle_caf_down
        ;;

    *)
        # Do nothing
        exit 0
	    ;;
esac
exit 0
