'''
Created on Sep 17, 2014

@author: yaulee

Copyright (c) 2014-2015 by Cisco Systems, Inc.
All rights reserved.
'''


from apiservice import ResourceRoute
from jsonencoder import JSONEncoder
from common import AuthenticatedResource, make_response, make_error_response
from services import MiddlewareServices
from ..utils.infraexceptions import *


import logging
import os
import falcon
import json
import re

log = logging.getLogger("runtime.api.resources")

jsonencoder = JSONEncoder()

@ResourceRoute("/dmoservices", endpoint="dmoservices")
class DmoResource(AuthenticatedResource):
    
    def on_get(self, request, response):
        try:
            result = MiddlewareServices.getInstance().get_all_status()
        except Exception as ex:
            log.error("Services error with message: %s", ex.message)
            response = make_error_response(response,
                                           "Error while getting services state: %s" % str(ex),
                                           "Error while getting services state",
                                           falcon.HTTP_500)
            return

        out = jsonencoder.encode(result)
        response.body = out
        response.status = falcon.HTTP_200
        response.set_headers({'Content-Type': "application/json",
                              'Cache-Control': "no-cache"})
        return


@ResourceRoute("/dmoservices/{service_id}/state", endpoint="dmoservicesstate")
class DmoStateResource(AuthenticatedResource):

    def on_post(self, request, response, service_id):
        if MiddlewareServices.getInstance().getServiceInfo(service_id) == None:
            log.error("Service ID not found: %s", service_id)
            response = make_error_response(response,
                                           "Service ID not found: %s" % service_id,
                                           "Service ID not found: %s" % service_id,
                                           falcon.HTTP_500)
            return

        action = request.get_param("action")
        log.debug("Requested state by the user: %s", action)
        try:
            if action == "start":
                if MiddlewareServices.getInstance().start(service_id):
                    result = { "state": "Running" }
                else:
                    result = { "state": "FAILED" }
            elif action == "stop":
                if MiddlewareServices.getInstance().stop(service_id):
                    result = { "state": "Stopped" }
                else:
                    result = { "state": "FAILED" }
            elif action == "status":
                result = MiddlewareServices.getInstance().status(service_id)
            else:
                response = make_error_response(response,
                                                "Requested state: %s, by the user is not supported" % action,
                                                "Unsupported action\n",
                                                falcon.HTTP_500)
                return
        except Exception as ex:
            log.error("Services error with message: %s", ex.message)
            if isinstance(ex, C3Exception):
                response = make_error_response(response, ex.message,
                                               "Error while changing service state: %s" % service_id,
                                               falcon.HTTP_500,
                                               ex.errorcode)
            else:
                response = make_error_response(response,
                                                    "Error while changing services state: %s" % str(ex),
                                                    "Error while changing services state",
                                                    falcon.HTTP_500)
            return

        out = jsonencoder.encode(result)
        response.body = out
        response.status = falcon.HTTP_200
        response.set_headers({'Content-Type': "application/json",
                              'Cache-Control': "no-cache"})


