#!/usr/bin/perl 

#  ----------------------------------------------------------------
#  Copyright (c) 2015-2016 by cisco Systems, Inc.
#  All rights reserved.
# -----------------------------------------------------------------

use strict;

my $wget = "/usr/bin/wget";
# --------------------------------------------------------------------------------
# Calvados lighttpd ports
# --------------------------------------------------------------------------------
my $confd_meta_port = 8022;
my $confd_yang_port = 8023;
my $calvados_meta_port = 8024;
my $calvados_yang_port = 8025;
# --------------------------------------------------------------------------------
# XR file locations
# --------------------------------------------------------------------------------
my $yang_path = "/pkg/yang/";
my $meta_path = "/pkg/yang/meta/calvados/";
my $meta_sentinel = "/pkg/yang/meta/calvados/.calvados_sentinel";
my $host = $ARGV[1];
my $option = $ARGV[0]; 

sub calvados_address()
{
    my $cal;

    $host = "";
    open (CAL, "/dev/xr_bootstrap") or die "Can't open bootstrap record.";
    while (<CAL>) {
	chop;
	if (/CALVADOS_IP_ADDR/) {
	    ($cal, $host) = split("=");
	    return;
	}
    }
}

sub copy_meta()
{
    system("$wget $_[0] -qO $_[1] >& /dev/null");
}

sub get_dir()
{
    my $cmd = "$wget -qO- $_[0]:$_[1] |";
    my $line = "";
    my $url = "";
    my $path = "";

    open (META, $cmd) or die "Can't open calvados web access.";
    if (! -d $_[2]) {
	system("mkdir -p $_[2]");
    }
    while (<META>) {
	chomp;
	if (/<a href=/) {
	    $line = $_;
	    $line =~ s,^.*<a href=[^>]*>,,g;
	    $line =~ s,</a>.*,,g;
	    if (!/Parent Directory/) {
		$url = sprintf("%s:%d/%s", $_[0], $_[1], $line);
		$path = sprintf("%s%s", $_[2], $line);
		&copy_meta($url, $path);
	    }
	}
    }
}

if (! -f $meta_sentinel
    || $option eq "-r") {
    &calvados_address();
    if ($host ne "") {
	#print "CALVADOS Address = $host\n";
	&get_dir($host, $confd_meta_port, $meta_path);
	&get_dir($host, $confd_yang_port, $yang_path);
	&get_dir($host, $calvados_meta_port, $meta_path);
	&get_dir($host, $calvados_yang_port, $yang_path);

	open SENT, "> $meta_sentinel" || die;
    } else {
	print "Cannot obtain Calvados address\n";
    }
}

exit 0;

