# -----------------------------------------------------------------------------
# bgp_nbr_bag.py -- bgp_nbr_bag mapping for openconfig-bgp
#
# May 2016, Alpesh S. Patel
#
# Copyright (c) 2016 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------


#Native: update(tx) and notif(tx)
ocbgp__bgp_nbr_bag__neighbor_state_messages_sent_overlay_node = {
    "name" : "sent",
    "field-id" : 1,
    "bag-mapping-nodes" : [
            {
             "bag-field" : "MessageStatistics",
             "bag-type" : "subtype",
             "bag-mapping-nodes" : 
             [ {
                "bag-field" : "Update",
                "bag-type" : "subtype",
                "bag-mapping-nodes" : 
                [ {
                   "bag-field" : "Tx",
                   "bag-type" : "subtype",
                   "bag-mapping-nodes" :
                   [ {
                      "bag-field" : "Count",
                      "bag-type" : "uint32_t",
                      "overlay-nodes" : 
                      [{"name" : "UPDATE", "type" : "uint64", "field-id" : 1}]
                      }]
                  },
                ]
                },
		{
                "bag-field" : "Notification",
                "bag-type" : "subtype",
                "bag-mapping-nodes" : 
                [ {
                   "bag-field" : "Tx",
                   "bag-type" : "subtype",
                   "bag-mapping-nodes" :
                   [ {
                      "bag-field" : "Count",
                      "bag-type" : "uint32_t",
                      "overlay-nodes" : 
                      [{"name" : "NOTIFICATION", "type" : "uint64", "field-id" : 2}]
                      }]
                  },
                ]
                }
             ]
             }
          ]
}

#Native: update(rx) and notif(rx)
ocbgp__bgp_nbr_bag__neighbor_state_messages_received_overlay_node = {
    "name" : "received",
    "field-id" : 2,
    "bag-mapping-nodes" : [
            {
             "bag-field" : "MessageStatistics",
             "bag-type" : "subtype",
             "bag-mapping-nodes" : 
             [ {
                "bag-field" : "Update",
                "bag-type" : "subtype",
                "bag-mapping-nodes" : 
                [
		  {
                   "bag-field" : "Rx",
                   "bag-type" : "subtype",
                   "bag-mapping-nodes" :
                   [ {
                      "bag-field" : "Count",
                      "bag-type" : "uint32_t",
                      "overlay-nodes" : 
                      [{"name" : "UPDATE", "type" : "uint64", "field-id" : 3}]
                      }]
                  }
                ]
                },
		{ 
                "bag-field" : "Notification",
                "bag-type" : "subtype",
                "bag-mapping-nodes" : 
                [
		  {
                   "bag-field" : "Rx",
                   "bag-type" : "subtype",
                   "bag-mapping-nodes" :
                   [ {
                      "bag-field" : "Count",
                      "bag-type" : "uint32_t",
                      "overlay-nodes" : 
                      [{"name" : "NOTIFICATION", "type" : "uint64", "field-id" : 4}]
                      }]
                  }
                ]
                } 
             ]
             }
          ]
}

ocbgp__bgp_nbr_bag__neighbor_state_messages_overlay_node = {
    "name" : "messages",
    "field-id" : 1,
    "overlay-nodes" : [
	    ocbgp__bgp_nbr_bag__neighbor_state_messages_sent_overlay_node,
	    ocbgp__bgp_nbr_bag__neighbor_state_messages_received_overlay_node ]
}

ocbgp__bgp_nbr_bag__neighbor_state_queues_overlay_node = {
    "name" : "queues",
    "field-id" : 1,
    "bag-mapping-nodes" :[
            {
             "bag-field" : "MessagesQueuedIn",
             "bag-type" : "uint32_t",
             "overlay-nodes":
             [{"name" : "input", "type" : 'uint32', "field-id" : 1}]
             
             },
	    {
             "bag-field" : "MessagesQueuedOut",
             "bag-type" : "uint32_t",
             "overlay-nodes":
             [{"name" : "output", "type" : 'uint32', "field-id" : 2}]
             
             }
            
            ]
}

ocbgp__bgp_nbr_bag__neighbor_state_overlay_node= {
    "name" : "state",
    "field-id" : 1,
        "bag-mapping-nodes" : [ 
            {
             "bag-field" : "ConnectionState", 
             "bag-type" : "enum", # bgp_conn_state - enums shifted by 1
             "overlay-nodes":
	     [ {
	      "name" : "session-state",
	      "field-id" : 3,
	      "type" : "enum",
	      "enum-map" :
	      {
		0 : 'DONTCARE',     # DONTCARE
		1 : 'IDLE',         # IDLE
		2 : 'CONNECT',      # CONNECT
		3 : 'ACTIVE',       # ACTIVE
		4 : 'OPENSENT' ,    # OPENSENT
		5 : 'OPENCONFIRM',  # OPENCONFIRM
		6 : 'ESTABLISHED',  # ESTABLISHED
	      }
               },
             ]
             },
#
# ASP TBD - this is a leaf-list / linked list of capabilities
# need infra support per Manu
            {
             "bag-field" : "IsRouteRefreshCapabilityReceived",
             "bag-type" : "bool",
             "overlay-nodes":
             [{
		     "name" : "supported-capabilities", 
		     "field-id" : 4,
		     "type" : "enum", 
		     "enum-map" :
		     {
			     1 : 'ROUTE_REFRESH'
		     }
	     }]
             },
	        {
             "bag-field" : "MultiProtocolCapabilityReceived",
             "bag-type" : "bool",
             "overlay-nodes":
             [{
		     "name" : "supported-capabilities", 
		     "field-id" : 4,
		     "type" : "enum", 
		     "enum-map" :
		     {
			     1 : 'MPBGP'
		     }
	     }]
             },
            
	        {
             "bag-field" : "IsGRAware",
             "bag-type" : "bool",
             "overlay-nodes":
             [{
		     "name" : "supported-capabilities", 
		     "field-id" : 4,
		     "type" : "enum", 
		     "enum-map" :
		     {
			     1 : 'GRACEFUL_RESTART'
		     }
	     }]
            },

	       {
             "bag-field" : "Is4ByteASCapabilityReceived",
             "bag-type" : "bool",
            "register-ops" :
            [{"register": 0, "operation":"load"}],

#             "overlay-nodes":
#             [{
#		     "name" : "supported-capabilities", 
#		     "field-id" : 7,
#		     "type" : "enum", 
#		     "enum-map" :
#		     {
#			     1 : 'ASN32'
#		     }
#	        }]
            },
        
            {
             "bag-field" : "Is4ByteASCapabilitySent",
             "bag-type" : "bool",
            "register-ops" :
            [{"register": 1, "operation":"load"}],

             
             },
            
            ],
    "overlay-nodes" : [
	    ocbgp__bgp_nbr_bag__neighbor_state_queues_overlay_node,
	    ocbgp__bgp_nbr_bag__neighbor_state_messages_overlay_node ],
    
         #at the very end process register decode operations
    "register-ops":
    [
     {"register":0, 
      "operation": "and",
      "arg" : 1,
      
     },
     
     {"register":0, 
      "operation": "decode",
      "overlay-nodes" :
      [{
        "name" : "supported-capabilities",
        "field-id" : 4,
        "type" : "enum",
        "enum-map" :
        {
            1 : 'ASN32'
        }
      }],
     },
     ]
}

ocbgp__bgp_nbr_bag__neighbor_timer_state_overlay_node = {
    "name" : "state",
    "field-id" : 1,
    "bag-mapping-nodes" : [
#            {
#             "bag-field" : "ConnectRetryInterval",
#             "bag-type" : "uint32_t",
#             "overlay-nodes":
#             [{"name" : "connect-retry", "type" : 'decimal64', "field-id" : 1}]
#             },
#            {
#             "bag-field" : "ConfiguredHoldTime", 
#             "bag-type" : "uint16_t",
#             "overlay-nodes":
#             [{"name" : "hold-time", "type" : 'decimal64', "field-id" : 2}]
#            },
#	    {
#             "bag-field" : "KeepAliveTime",
#             "bag-type" : "uint32_t",
#             "overlay-nodes":
#             [{"name" : "keepalive-interval", "type" : 'decimal64', "field-id" : 3}]
#            },
#	    {
#             "bag-field" : "MinAdvertiseInterval",
#             "bag-type" : "uint32_t",
#             "overlay-nodes":
#             [{"name" : "minimum-advertisement-interval", "type" : 'decimal64', "field-id" : 4}]
#            },
	    {
             "bag-field" : "HoldTime", 
             "bag-type" : "uint16_t",
             "overlay-nodes":
             [{"name" : "negotiated-hold-time", "type" : 'decimal64', "field-id" : 5}]
            },
	    {
             "bag-field" : "ConnectionEstablishedTime",
             "bag-type" : "uint32_t",
            "register-ops" :
    	    [{"register": 0, "operation":"load" 	}],
	    }
            ],

	    "register-ops" :
    	    [{"register": 0, "operation":"regmult", "const_value" : 100 },
	     {"register":0, "operation":"decode",
             "overlay-nodes":
	     [{"name" : "uptime", "type" : 'uint32', "field-id" : 6 }]
	     #[{"name" : "uptime", "type" : 'timeticks', "field-id" : 6 }]
            }],
}

ocbgp__bgp_nbr_bag__neighbor_timer_overlay_node = {
    "name" : "timers",
    "field-id" : 1,
    "overlay-nodes" : [ ocbgp__bgp_nbr_bag__neighbor_timer_state_overlay_node
                      ]
}

#            {
#             "bag-field" : "TBD: mtu-discovery",
#             "bag-type" : "bool",
#             "overlay-nodes" :
#             [{"name" : "mtu-discovery", "type" : 'boolean', "field-id" : 2}]
#             },
#            {
#             "bag-field" : "TBD: passive-mode",
#             "bag-type" : "bool",
#             "overlay-nodes" :
#             [{"name" : "passive-mode", "type" : 'boolean', "field-id" : 3}]
#             },

ocbgp__bgp_nbr_bag__neighbor_transport_state_overlay_node = {
    "name" : "state",
    "field-id" : 1,
    "bag-mapping-nodes" : [
            {
             "bag-field" : "ConnectionLocalPort",
             "bag-type" : "uint32_t",
            "overlay-nodes":
             [{"name" : "local-port", "type" : 'inet:port-number', "field-id" : 1}]
            },
	    {
             "bag-field" : "ConnectionRemotePort",
             "bag-type" : "uint32_t",
            "overlay-nodes":
             [{"name" : "remote-port", "type" : 'inet:port-number', "field-id" : 2}]
            },

# This is part of cfg transport/state (not oper)
#            {
#             "bag-field" : "TCPMSS",
#             "bag-type" : "uint32_t",
#             "overlay-nodes":
#             [{"name" : "tcp-mss", "type" : 'uint16', "field-id" : 1}]
#             
#             },

	     {
                "bag-field" : "ConnectionRemoteAddress",
                "bag-type" : "union", 
                "bag-mapping-nodes" : 
                [ {
                   "bag-field" : "0", #IPV4
                   "bag-type" : "union_discriminant",
                   "bag-mapping-nodes" : 
		   [ 
		   {
	             "bag-field" : "IPV4Address",
	             "bag-type" : "in_addr_t",
                     "overlay-nodes" : 
		     [{"name" : "remote-address", "type" :
			     "inet:ip-address", "field-id" : 3}]
                   },
		   ]
		   } ,
#ASP TBD - things don't work if I enable the following cases		   
#		   {
#                   "bag-field" : "1", # IPMCAST
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV4McastAddress",
#	             "bag-type" : "in_addr_t",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "2", # IP v4 label
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV4LabelAddress",
#	             "bag-type" : "in_addr_t",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "3", #  IPv4 Tunnel
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV4TunnelAddress",
#	             "bag-type" : "bgp_ipv4_tunnel_addr_type", #ASP TBD
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } , 
#		   {
#                   "bag-field" : "4", # IPv4 VPN Addr
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV4VPNAddress",
#	             "bag-type" : "in_addr_t",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "5", # IP v6 unicast
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV6Address",
#	             "bag-type" : "bgp_ipv6_address_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } , 
#		   {
#                   "bag-field" : "6", # IP v6 multicast"
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV6McastAddress",
#	             "bag-type" : "bgp_ipv6_address_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "7", # IP v6 label
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPv6LabelAddress",
#	             "bag-type" : "bgp_ipv6_address_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "8", # IP v6 virtual private
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV6VPNAddress",
#	             "bag-type" : "bgp_ipv6_address_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } , 
#		   {
#                   "bag-field" : "9", #  IPv4 MDT Addr
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV4MDTAddress",
#	             "bag-type" : "bgp_ipv4_mdt_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "10", # L2VPN VPLS Addr
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "L2VPNVPLSAddress",
#	             "bag-type" : "bgp_l2vpn_addr_t",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "11", # IP RT-Constraint
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "RTConstraintAddress",
#	             "bag-type" : "bgp_rt_constrt_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "12", # MVPN4 addr
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV4MVPNAddress",
#	             "bag-type" : "bgp_ipv4_mvpn_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "13", # IP v6 mvpn
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV6MVPNAddress",
#	             "bag-type" : "bgp_ipv6_mvpn_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "14", # L2VPN EVPN
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "L2VPN_EVPNAddress",
#	             "bag-type" : "bgp_l2vpn_evpn_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "15", # linkstate linkstate Addr
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "LS_LSAddress",
#	             "bag-type" : "bgp_ls_ls_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "16", # IP v4 virtual private network for multicast
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV4VPNAMcastddress",
#	             "bag-type" : "in_addr_t",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "17", # IP v6 virtual private network for multicast
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV6VPNMcastAddress",
#	             "bag-type" : "bgp_ipv6_address_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "18", # IPV4 Flowspec Addr
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV4FlowspecAddress",
#	             "bag-type" : "bgp_ipv4_flowspec_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "19", #  IP v6 flowspec"
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV6FlowspecAddress",
#	             "bag-type" : "bgp_ipv6_flowspec_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "20", #  IP v4 vpn flowspec"
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV4VPNFlowspecAddress",
#	             "bag-type" : "bgp_ipv4_flowspec_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "21", #  IP v6 vpn flowspec
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "IPV6VPNFlowspecAddress",
#	             "bag-type" : "bgp_ipv6_flowspec_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#		   {
#                   "bag-field" : "22", # L2VPN Multi-segment pseudowire
#                   "bag-type" : "union_discriminant",
#                   "bag-mapping-nodes" : 
#		   [ 
#		   {
#	             "bag-field" : "L2VPN_MSPWAddress",
#	             "bag-type" : "bgp_l2vpn_mspw_addr_type",
#                      "overlay-nodes" : 
#                      [{"name" : "local-address", "type" : "string", "field-id" : 2}]
#                   },
#		   ]
#		   } ,
#                  #end of enum
	      ]
	   }
	]
}

ocbgp__bgp_nbr_bag__neighbor_transport_overlay_node = {
    "name" : "transport",
    "field-id" : 1,
    "overlay-nodes" : [ ocbgp__bgp_nbr_bag__neighbor_transport_state_overlay_node
                         ]
}

ocbgp__bgp_nbr_bag__neighbor_graceful_restart_state_overlay_node = {
    "name" : "state",
    "field-id" : 1,
    "bag-mapping-nodes" :[
            {
             "bag-field" : "GrRestartTime",
             "bag-type" : "uint32_t",
             "overlay-nodes":
             [{"name" : "peer-restart-time", "type" : 'uint16', "field-id" : 1}]
             
             },
            ]
}

ocbgp__bgp_nbr_bag__neighbor_graceful_restart_overlay_node = {
    "name" : "graceful-restart",
    "field-id" : 1,
    "overlay-nodes" : [
	    ocbgp__bgp_nbr_bag__neighbor_graceful_restart_state_overlay_node 
	       ]
}

#
# afi-safi path
#



ocbgp__bgp_nbr_bag__neighbor_afi_safis_afi_safi_graceful_restart_state_overlay_node = {
    "name" : "state",
    "field-id" : 2,
    "bag-mapping-nodes" :[
            {
             "bag-field" : "IsAdvertisedGracefulRestart",
             "bag-type" : "bool",
             "overlay-nodes":
             [{ "name" : "advertised", "type" : 'boolean', "field-id" : 1 }]
             },
	    {
             "bag-field" : "IsReceivedGracefulRestartCapable",
             "bag-type" : "bool",
             "overlay-nodes":
             [{ "name" : "received", "type" : 'boolean', "field-id" : 2 }]
             }
	    ]
}

ocbgp__bgp_nbr_bag__neighbor_afi_safis_afi_safi_graceful_restart_overlay_node = {
    "name" : "graceful-restart",
    "field-id" : 1,
    "overlay-nodes" : [
  ocbgp__bgp_nbr_bag__neighbor_afi_safis_afi_safi_graceful_restart_state_overlay_node
	       ]
}

ocbgp__bgp_nbr_bag__neighbor_afi_safis_afi_safi_state_prefixes_overlay_node = {
    "name" : "prefixes",
    "field-id" : 1,
    "bag-mapping-nodes" : [
            {
             "bag-field" : "PrefixesAdvertised",
             "bag-type" : "uint32_t",
             "overlay-nodes":
             [{ "name" : "sent", "type" : 'uint32', "field-id" : 1 }]
             },
	    {
             "bag-field" : "PrefixesAccepted",
             "bag-type" : "uint32_t",
             "overlay-nodes":
             [{ "name" : "received", "type" : 'uint32', "field-id" : 2 }]
             },
# installed leaf is not supported yet
#	    {
#             "bag-field" : "",
#             "bag-type" : "",
#             "overlay-nodes":
#             [{ "name" : "installed", "type" : '', "field-id" : 3 }]
#             },
            ]
}

# ASP TBD: ASK MANU - Is this right?
ocbgp__bgp_nbr_bag__neighbor_afi_safis_afi_safi_state_overlay_node = {
    "name" : "state",
    "field-id" : 1,
    "bag-mapping-nodes" :[
            {
             "bag-field" : "IsNeighborAFCapable",
             "bag-type" : "bool",
             "overlay-nodes":
             [{ "name" : "active", "type" : 'boolean', "field-id" : 1 }]
             },
	    ],
	      "overlay-nodes" :
    [ocbgp__bgp_nbr_bag__neighbor_afi_safis_afi_safi_state_prefixes_overlay_node ]

}

# ASP TBD: This is the tricky part:
#ASP TBD: Work with Manu to confirm this ...

ocbgp__bgp_nbr_bag__neighbor_afi_safis_overlay_node = {
    "name" : "afi-safis",
    "field-id" : 1,
    "bag-mapping-nodes" : [
        {
         "bag-field" : "AFData",
         "bag-type" : "subtype",
         "overlay-nodes" :
         [
            {
              "name" : "afi-safi",
              "field-id" : 1,
              "bag-mapping-nodes" : 
                [ {
                  "bag-field" : "AFName", 
                  "bag-type" : "subtype",
                  "overlay-nodes" :
                  [ {
                     "name" : "afi-safi-name",
                     "field-id" : 1,
                     "type" : "enum",
                     "enum-map" :
                     {
                        0 :  'openconfig-bgp-types:IPV4-UNICAST', # IPV4
                        2 :  'openconfig-bgp-types:IPV4-LABELED-UNICAST', # IPV4LABEL
                        4 :  'openconfig-bgp-types:L3VPN-IPV4-UNICAST', # VPNV4
                        5 :  'openconfig-bgp-types:IPV6-UNICAST', # IPV6
                        7 :  'openconfig-bgp-types:IPV6-LABELED-UNICAST', # IPV6LABEL
                        8 :  'openconfig-bgp-types:L3VPN-IPV6-UNICAST', # VPNV6
                        10 : 'openconfig-bgp-types:L2VPN-VPLS', # L2VPNVPLS
                        14 : 'openconfig-bgp-types:L2VPN-EVPN', # L2VPNEVPN
                        16 : 'openconfig-bgp-types:L3VPN-IPV4-MULTICAST', # VPNV4MCAST
                        17 : 'openconfig-bgp-types:L3VPN-IPV6-MULTICAST', # VPNV6MCAST
                        #The rest from [0-23] are not defined in oc-bgp types
                    }
                    }
                  ]
                 }, 
                 ],
		"overlay-nodes" :
          [
	      ocbgp__bgp_nbr_bag__neighbor_afi_safis_afi_safi_state_overlay_node,
       ocbgp__bgp_nbr_bag__neighbor_afi_safis_afi_safi_graceful_restart_overlay_node,
	      ]
            }
          ],
        },
    ]
}

#ocbgp__bgp_nbr_bag__neighbor_afi_safis_overlay_node = {
#    "name" : "afi-safis",
#    "field-id" : 1,
#    "overlay-nodes" : [
#            ocbgp__bgp_nbr_bag__neighbor_afi_safis_afi_safi_overlay_node
#	       ]
#}

ocbgp__bgp_nbr_bag__neighbor_overlay_node = {
    "name" : "neighbor",
    "field-id" : 1,
    "naming-element-nodes" : 
     [
       {
        "index" : 1,
         "name": "neighbor-address",
	 "type": "string", #ASP TBD: Ask Manu - doesnot take inet:ip-address
         "field-id" : 1 ,
         "key": True
        
        }
     ],
     "overlay-nodes" : 
         [ ocbgp__bgp_nbr_bag__neighbor_state_overlay_node,
	   ocbgp__bgp_nbr_bag__neighbor_timer_overlay_node,
           ocbgp__bgp_nbr_bag__neighbor_transport_overlay_node,
           ocbgp__bgp_nbr_bag__neighbor_graceful_restart_overlay_node,
           ocbgp__bgp_nbr_bag__neighbor_afi_safis_overlay_node,
	 ]

}

mappings = {
    "overlay-model" : "openconfig-bgp",
    "bag-name" : "bgp_nbr_bag",
    "bag-file" : "bgp.bag",
    "xr-path" : "/oper/ip-bgp/gl/instance/<>/act/shared/vrf/default/nbr/<>",
    "native-yang-path" : "Cisco-IOS-XR-ipv4-bgp-oper:bgp/instances/instance/instance-active/default-vrf/neighbors",
    
    
    "naming-elements" : 
    [ {
      #instance
      "type" : "string",
      "index" : 0   
      },
      
      {
       #neighbor
       "type" : "string",
       "index" : 1
       }
    ],
    
    "overlay-nodes" : 
    [   {
        "name" : "openconfig-bgp:bgp",
        "field-id": 1,
        "overlay-nodes" : 
        [   {    
             "name" : "neighbors",
             "field-id" : 1,
             "overlay-nodes" : 
             [ ocbgp__bgp_nbr_bag__neighbor_overlay_node ]

            }
                  
        ]

        }
    
    ] 
}

## END bgp_nbr_bag 
#################################################################
