# -----------------------------------------------------------------------------
# ethernet_controller_driver_bag_v2_type.py -- ethernet_controller_driver_bag_v2_type
# bag mapping for openconfig-interface
#
# May 2016, Manu Radhakrishna
#
# Copyright (c) 2016 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

ocif__ethernet_controller_driver_bag_v2_type__ethernet_state_overlay_node = {
    "name" : "state",
    "field-id" : 1,
    "bag-mapping-nodes" : [
        {
            "bag-field" : "MacInfo",
            "bag-type" : "subtype",
            "bag-mapping-nodes" :
            [ {
              "bag-field" : "BurnedInMACAddress",
              "bag-type" : "mac_addr_type",
              "overlay-nodes" :
              [{"name" : "hw-mac-address", "type" : "yang:mac-address", "field-id": 1}]

            } ],

        },
    ]

}
ocif__ethernet_controller_driver_bag_v2_type__ethernet_overlay_node = {
    "name" : "openconfig-if-ethernet:ethernet",
    "field-id" : 2001,
    "overlay-nodes" :
    [ ocif__ethernet_controller_driver_bag_v2_type__ethernet_state_overlay_node ]
}

mappings = {
    "overlay-model" : "openconfig-interfaces",
    "bag-name" : "ethernet_controller_driver_bag_v2_type",
    "bag-file" : "ethernet_show_controller.bag",
    "xr-path" : "/oper/ethernet_drvr/oper/if/*",
    "mpg-path" : "RootOper.EthernetInterface.Interface(*)",
    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0
      }
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-interfaces:interfaces",
        "field-id": 1,
        "overlay-nodes" :
        [   {
             "name" : "interface",
             "field-id" : 1,
             "naming-element-nodes" :
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string" ,
                 "field-id" : 1,
                 "key": True

                }
             ],

             "overlay-nodes" :
             [ ocif__ethernet_controller_driver_bag_v2_type__ethernet_overlay_node ]

            }

        ]

        }

    ]

}
