# -----------------------------------------------------------------------------
# im_cmd_info.py -- im_cmd_info bag mapping for openconfig-interface
#
# May 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

ocif__im_cmd_info__state_bag_mapping_nodes = [
   {
    'bag-field' : "InterfaceType",
    'bag-type' : 'im_int_type',
    'overlay-nodes' :
    [{'name' : 'type', 'type' : 'ietf-interfaces:interface-type', 'field-id' : 2}]
   
  },
  {
    'bag-field' : 'State',
    'bag-type'  : 'enum',
    'overlay-nodes' : 
    [
     {
      "name" : "admin-status",
      "field-id" : 3,
      "type" : "enum",
      "enum-map" :
      {
        0 : 'DOWN',  # IM_STATE_NOTREADY
        1 : 'DOWN',  # IM_STATE_ADMINDOWN
        2 : 'UP',  # IM_STATE_DOWN
        3 : 'UP' ,  # IM_STATE_UP
        4 : 'DOWN',  # IM_STATE_SHUTDOWN
        5 : 'DOWN',  # IM_STATE_ERRDISABLE
        6 : 'DOWN',  # IM_STATE_DOWN_IMMEDIATE
        7 : 'DOWN',  # IM_STATE_DOWN_IMMEDIATE_ADMIN
        8 : 'DOWN',  # IM_STATE_DOWN_GRACEFUL
        9 : 'DOWN',  # IM_STATE_BEGIN_SHUTDOWN
        10: 'DOWN',  # IM_STATE_END_SHUTDOWN
        11: 'DOWN',  # IM_STATE_BEGIN_ERROR_DISABLE
        12: 'DOWN',  # IM_STATE_END_ERROR_DISABLE
        13: 'DOWN',  # IM_STATE_BEGIN_DOWN_GRACEFUL
        14: 'DOWN',  # IM_STATE_RESET
        15: 'DOWN',  # IM_STATE_OPERATIONAL
        16: 'DOWN',  # IM_STATE_NOT_OPERATIONAL
        17: 'DOWN',  # IM_STATE_UNKNOWN
        18: 'DOWN',  # IM_STATE_UNKNOWN
       
       }
      
      },
     
     {
      "name" : "oper-status",
      "field-id" : 4,
      "type" : "enum",
      "enum-map" :
      {
        0 : 'DOWN',  # IM_STATE_NOTREADY
        1 : 'DOWN',  # IM_STATE_ADMINDOWN
        2 : 'DOWN',  # IM_STATE_DOWN
        3 : 'UP' ,  # IM_STATE_UP
        4 : 'DOWN',  # IM_STATE_SHUTDOWN
        5 : 'DOWN',  # IM_STATE_ERRDISABLE
        6 : 'DOWN',  # IM_STATE_DOWN_IMMEDIATE
        7 : 'DOWN',  # IM_STATE_DOWN_IMMEDIATE_ADMIN
        8 : 'DOWN',  # IM_STATE_DOWN_GRACEFUL
        9 : 'DOWN',  # IM_STATE_BEGIN_SHUTDOWN
        10: 'DOWN',  # IM_STATE_END_SHUTDOWN
        11: 'DOWN',  # IM_STATE_BEGIN_ERROR_DISABLE
        12: 'DOWN',  # IM_STATE_END_ERROR_DISABLE
        13: 'DOWN',  # IM_STATE_BEGIN_DOWN_GRACEFUL
        14: 'DOWN',  # IM_STATE_RESET
        15: 'DOWN',  # IM_STATE_OPERATIONAL
        16: 'DOWN',  # IM_STATE_NOT_OPERATIONAL
        17: 'DOWN',  # IM_STATE_UNKNOWN
        18: 'DOWN',  # IM_STATE_UNKNOWN
       
      }
      
     }
     
     ]
   },
   {
    "bag-field" : "MTU",
    "bag-type" : "uint32_t",
    "overlay-nodes" : 
    [{"name" : "mtu", "type" : "uint16", "field-id" : 5 }]
   },
   {
    "bag-field" : "LastStateTransitionTime",
    "bag-type" : "uint32_t",
    "overlay-nodes" :
    [{"name" : "last-change", "type" : "uint32", "field-id" : 6}]
    },
    {
     "bag-field" :"Description",
     "bag-type" : "string",
     "overlay-nodes" :
     [{"name" : "description", "type" : "string", "field-id" : 7 }]
     
     }
     
]

ocif__im_cmd_info__state_counters_overlay_node = {
    "name" : "counters",
    "field-id" : 2,
    "bag-mapping-nodes" :
    [
     {
      "bag-field" : "InterfaceStatistics",
      "bag-type" : "union",
      "bag-mapping-nodes" :
      [
       {
        "bag-field" : "1",
        "bag-type" : "union_discriminant",
        "bag-mapping-nodes":
        [
         {
          "bag-field" : "FullInterfaceStats",
          "bag-type" : "subtype",
          "bag-mapping-nodes":
          [
           {
            "bag-field" : "PacketsReceived",
            "bag-type" : "uint64_t",
            "register-ops" :
            [{"register": 0, "operation":"+"}]
            
            },
           
           {
            "bag-field" : "BytesReceived",
            "bag-type" : "uint64_t",
            "overlay-nodes" : 
            [{"name" : "in-octets", "type" : "uint64", "field-id" : 1, }]
            },
       
            {
             "bag-field" : "BytesSent",
             "bag-type" : "uint64_t",
             "overlay-nodes" :
             [{"name" : "out-octets", "type" : "uint64", "field-id" : 2}]
             },
       
             {
              "bag-field" : "MulticastPacketsReceived",
              "bag-type": "uint64_t",
              "overlay-nodes" :
              [{"name" : "in-multicast-pkts", "type" : "uint64", "field-id" : 3}]
              },
              
       
              {
               "bag-field" : "BroadcastPacketsReceived",
               "bag-type" : "uint64_t",
               "overlay-nodes" :
               [{"name" : "in-broadcast-pkts", "type" : "uint64", "field-id" : 4}]
               },
       
                {
                "bag-field" : "PacketsSent",
                "bag-type" : "uint64_t",
                "register-ops" :
                [{"register": 2, "operation":"+"}]
                
                },
               {
                "bag-field" : "MulticastPacketsSent",
                "bag-type" : "uint64_t",
                "overlay-nodes" :
                [{"name" : "out-multicast-pkts", "type" : "uint64", "field-id" : 5}]
                },
       
                {
                 "bag-field" : "BroadcastPacketsSent",
                 "bag-type": "uint64_t",
                 "overlay-nodes" :
                 [{"name": "out-broadcast-pkts", "type": "uint64", "field-id" : 6}]
                 },
                 
                 {
                  "bag-field" : "InputDrops",
                  "bag-type" : "uint32_t",
                  "register-ops" :
                  [{"register": 1, "operation":"+"}],
                  
                  },
                   {
                  "bag-field" : "InputQueueDrops",
                  "bag-type" : "uint32_t",
                  "register-ops" :
                  [{"register": 1, "operation":"+"}],
                  
                  },
                  {
                  "bag-field" : "OutputDrops",
                  "bag-type" : "uint32_t",
                  "register-ops" :
                  [{"register": 3, "operation":"+"}],
                  
                  },
                  {
                  "bag-field" : "OutputQueueDrops",
                  "bag-type" : "uint32_t",
                  "register-ops" :
                  [{"register": 3, "operation":"+"}],
                  
                  },
       
                 {
                  "bag-field" : "UnknownProtocolPacketsReceived",
                  "bag-type" : "uint32_t",
                  "overlay-nodes" :
                  [{"name": "in-unknown-protos", "type": "uint64", "field-id" : 7}]
                  },
         
                  {
                   "bag-field" : "InputErrors",
                   "bag-type" : "uint32_t",
                   "overlay-nodes" :
                   [{"name": "in-errors", "type" : "uint32", "field-id" : 8}]
                   },
       
                   {
                    "bag-field" : "OutputErrors",
                    "bag-type" : "uint32_t",
                    "overlay-nodes" :
                    [{"name" : "out-errors", "type" : "uint32", "field-id" : 9}]
                    },
           
                    {
                     "bag-field" : "LastDiscontinuityTime",
                     "bag-type" : "uint32_t",
                     "overlay-nodes" :
                     [{"name" : "last-clear", "type" : "yang:date-and-time", "field-id" : 10}]
                     }
           ]
        
    }
       
    ]
        
        }
      ],


    }
    ],
    #at the very end process register decode operations
    "register-ops":
    [
     {"register":0, 
      "operation": "decode",
      "overlay-nodes" :
      [{"name" : "in-unicast-pkts", "type": "uint64", "field-id" : 11}]
     },
     
     {"register":1, 
      "operation": "decode",
      "overlay-nodes" :
      [{"name" : "in-discards", "type": "uint64", "field-id" : 12}]
     },
     
     {"register":2, 
      "operation": "decode",
      "overlay-nodes" :
      [{"name" : "out-unicast-pkts", "type": "uint64", "field-id" : 13}]
     },
    
    {"register":3, 
      "operation": "decode",
      "overlay-nodes" :
      [{"name" : "out-discards", "type": "uint64", "field-id" : 14}]
     },
     
     
     ]   
}


ocif__im_cmd_info__subinterface_state_overlay_node = {
    "name" : "state",
    "field-id" : 2,
    "naming-element-nodes" : 
     [
       {
        "index" : 0,
         "name": "index",
         "type": "string" ,
         "subinterface-index" : True,
         "field-id" : 1,
         "key" : False
        
        }
     ],
    "bag-mapping-nodes" : ocif__im_cmd_info__state_bag_mapping_nodes,
    "overlay-nodes" :  [ ocif__im_cmd_info__state_counters_overlay_node ]

}
ocif__im_cmd_info__subinterfaces_overlay_node = {
    "name" : "subinterfaces",
    "field-id" : 2,
    "overlay-nodes" :
    [
     {
      "name" : "subinterface",
      "field-id" : 1,
      "naming-element-nodes" :
      [
       {
        "index" : 0,
        "name" : "index",
        "type" : "string",
        "subinterface-index" : True,
        "field-id" : 1,
        "key" : True
       }
      ],
      "overlay-nodes" :
      [ocif__im_cmd_info__subinterface_state_overlay_node]
     }  
      
    ]                 
}

mappings = {
    "overlay-model" : "openconfig-interfaces",
    "bag-name" : "imd_cmd_info",
    "xr-path" : "/oper/intf_mgbl/gl/full/*",
    "mpg-path" : "RootOper.Interfaces.Interface(*)",
    "naming-elements" : 
    [ {
      "type" : "string",
      "index" : 0
      }
    ],
    
    "overlay-nodes" : 
    [   {
        "name" : "openconfig-interfaces:interfaces",
        "field-id" : 1,
        "overlay-nodes" : 
        [   {    
             "name" : "interface",
             "field-id" : 1,
             "naming-element-nodes" : 
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string" ,
                 "interface-name" : True,
                  "field-id" : 1,
                  "key" : True
                }
             ],
             
             "overlay-nodes" : 
             [ ocif__im_cmd_info__subinterfaces_overlay_node]

            }
                  
        ]     

        }
    
    ] 

}
      
##END bag im_cmd_info #################################################
######################################################################
