# -----------------------------------------------------------------------------
# bm_member_data.py -- bm_member_data bag mapping for openconfig-lacp
#
# August 2017, Manu Radhakrishna
#
# Copyright (c) 2017-2018 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------


ocif__bm_member_data__counters_overlay_node = {
    "name" : "counters",
    "field-id" : 12,
    "bag-mapping-nodes" : [
        {
            "bag-field" : "Counters",
            "bag-type" : "subtype",
            "bag-mapping-nodes" :[
            {
             "bag-field" : "LACPDUsReceived",
             "bag-type" : "uint32_t",
             "overlay-nodes" :
              [{"name" : "lacp-in-pkts", "type" : 'uint64', 'field-id': 1}]
            },

            {
             "bag-field" : "LACPDUsTransmitted",
             "bag-type" : "uint32_t",
             "overlay-nodes" :
              [{"name" : "lacp-out-pkts", "type" : 'uint64', "field-id" : 2}]
            },

            {
             "bag-field" : "IllegalPacketsReceived",
             "bag-type" : "uint32_t",
             "overlay-nodes" :
              [{"name" : "lacp-unknown-errors", "type" : 'uint64', "field-id" : 3},
               {"name" : "lacp-errors", "type" : 'uint64', "field-id" : 4}
              ]
            },

            {
             "bag-field" : "ExcessLACPDUsReceived",
             "bag-type" : "uint32_t",
             "overlay-nodes" :
              [{"name" : "lacp-rx-errors", "type" : 'uint64', "field-id" : 5}]
            },

            ]


        },
    ]

}

ocif__bm_member_data__member_state_overlay_node = {
    "name" : "state",
    "field-id": 2,
    "naming-element-nodes" :
     [
       {
        "index" : 1,
         "name": "interface",
         "type": "string" ,
         "field-id" : 1,
         "key" : False

        }
     ],
    "bag-mapping-nodes" : [
        {
            "bag-field" : "LinkData",
            "bag-type" : "subtype",
            "bag-mapping-nodes" :[
            {
             "bag-field" : "ActorOperationalKey",
             "bag-type" : "uint16_t",
             "overlay-nodes" :
              [{"name" : "oper-key", "type" : 'uint16', "field-id" : 2}]
            },

            {
             "bag-field" : "PartnerSystemMACAddress",
             "bag-type" : "mac_addr_t",
             "overlay-nodes" :
              [{"name" : "partner-id", "type" : 'yang:mac-address', "field-id" : 3}]
            },

            {
             "bag-field" : "PartnerOperationalKey",
             "bag-type" : "uint16_t",
             "overlay-nodes" :
              [{"name" : "partner-key", "type" : 'uint16', "field-id" : 4}]
            },

            {
             "bag-field" : "ActorPortState",
             "bag-type" : "uint8_t",
             "overlay-nodes" :
              [
               {"name" : "activity",
                "type" : 'enumeration',
                "field-id" : 5,
                "mask" : 0x01,
                "enum-map" :{
                              0 : "PASSIVE",
                              1 : "ACTIVE"
                             }
                },

               {"name" : "timeout",
                "type" : 'enumeration',
                "field-id" : 6,
                "mask" : 0x02,
                "enum-map" :{
                              0 : "SHORT",
                              1: "LONG"
                              }
                },

               {"name" : "synchronization",
                "type" : 'enumeration',
                "mask" : 0x08,
                "field-id" : 7,
                "enum-map" :{
                              0 : "OUT_SYNC",
                              1 : "IN_SYNC"
                              }
                },

               {"name" : "aggregatable",
                "type" : 'boolean',
                "field-id" : 8,
                "mask" : 0x04
                },
               {"name" : "collecting",
                "type" : "boolean",
                "mask" : 0x10,
                "field-id" : 9
                },

               {"name" : "distributing",
                "type" : "boolean",
                "mask" : 0x20,
                "field-id" : 10
                },

               ]
            }


            ]

        },
        {
          "bag-field" : "MACAddress",
          "bag-type" : "subtype",
          "bag-mapping-nodes" :[
            {
             "bag-field" : "Address",
             "bag-type" : "mac_addr_t",
             "overlay-nodes":
             [{"name" : "system-id", "type" : 'yang:mac-address', "field-id" : 11}]

             }

            ]

         }
    ],
    "overlay-nodes" :
    [ocif__bm_member_data__counters_overlay_node]

}



ocif__bm_member_data__member_overlay_node = {
    "name" : "member",
    "field-id" : 1,
    "naming-element-nodes" :
     [
       {
        "index" : 1,
         "name": "interface",
         "type": "string",
         "field-id" : 1 ,
         "key": True

        }
     ],
    "overlay-nodes":
    [ ocif__bm_member_data__member_state_overlay_node ]
}

ocif__bm_member_data__lacp_members_node = {
    "name" : "members",
    "field-id" : 2,
    "overlay-nodes":
    [ ocif__bm_member_data__member_overlay_node]
}

mappings = {
    "overlay-model" : "openconfig-lacp",
    "bag-name" : "bm_member_data",
    "bag-file" : "bundlemgr_distrib.bag",
    "xr-path" : "/oper/bm-bdl/if/*/members/*",
    "mpg-path": "RootOper.Bundles.Bundle(*).Member(*)",
    "native-yang-path" : "Cisco-IOS-XR-bundlemgr-oper:bundles/bundles/bundle/members/member",


    "naming-elements" :
    [ {
      #Bundle interface name
      "type" : "string",
      "index" : 0
      },

      {
       #Member interface name
       "type" : "string",
       "index" : 1
       }
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-lacp:interfaces",
        "namespace" : "http://openconfig.net/yang/lacp",
        "field-id": 1,
        "overlay-nodes" :
        [   {
             "name" : "interface",
             "field-id" : 1,
             "naming-element-nodes" :
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string",
                 "field-id" : 1,
                 "key" : True

                }
             ],

             "overlay-nodes" :
             [ ocif__bm_member_data__lacp_members_node ]

            }

        ]

        }

    ]
}

## END bm_member_data
#####################################################################################
