# -----------------------------------------------------------------------------
#  mpls_rsvp_interface_counters.py -- mpls_rsvp_interface_counters map to oc-mpls
#
# May 2016, Christian Cassar
#
# Copyright (c) 2016 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

ocmpls_ip_rsvp_gl_active_oc_interface_counter_bag_mappings = [
    {
        'bag-field' : "InPathMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'in-path-messages', 'type' : 'uint64', 'field-id' : 1}]
    },
    {
        'bag-field' : "InPathErrorMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'in-path-error-messages', 'type' : 'uint64', 'field-id' : 2}]
    },
    {
        'bag-field' : "InPathTearMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'in-path-tear-messages', 'type' : 'uint64', 'field-id' : 3}]
    },
    {
        'bag-field' : "InReservationMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'in-reservation-messages', 'type' : 'uint64', 'field-id' : 4}]
    },
    {
        'bag-field' : "InReservationErrorMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'in-reservation-error-messages', 'type' : 'uint64', 'field-id' : 5}]
    },
        {
        'bag-field' : "InReservationTearMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'in-reservation-tear-messages', 'type' : 'uint64', 'field-id' : 6}]
    },
    {
        'bag-field' : "InHelloMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'in-hello-messages', 'type' : 'uint64', 'field-id' : 7}]
    },
    {
        'bag-field' : "InSrefreshMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'in-srefresh-messages', 'type' : 'uint64', 'field-id' : 8}]
    },
    {
        'bag-field' : "InAckMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'in-ack-messages', 'type' : 'uint64', 'field-id' : 9}]
    },
    {
        'bag-field' : "OutPathMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'out-path-messages', 'type' : 'uint64', 'field-id' : 10}]
    },
    {
        'bag-field' : "OutPathErrorMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'out-path-error-messages', 'type' : 'uint64', 'field-id' : 11}]
    },
    {
        'bag-field' : "OutPathTearMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'out-path-tear-messages', 'type' : 'uint64', 'field-id' : 12}]
    },
    {
        'bag-field' : "OutReservationMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'out-reservation-messages', 'type' : 'uint64', 'field-id' : 13}]
    },
    {
        'bag-field' : "OutReservationErrorMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'out-reservation-error-messages', 'type' : 'uint64', 'field-id' : 14}]
    },
        {
        'bag-field' : "OutReservationTearMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'out-reservation-tear-messages', 'type' : 'uint64', 'field-id' : 15}]
    },
    {
        'bag-field' : "OutHelloMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'out-hello-messages', 'type' : 'uint64', 'field-id' : 16}]
    },
    {
        'bag-field' : "OutSrefreshMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'out-srefresh-messages', 'type' : 'uint64', 'field-id' : 17}]
    },
    {
        'bag-field' : "OutAckMessages",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'out-ack-messages', 'type' : 'uint64', 'field-id' : 18}]
    }
]

mappings = {
    "overlay-model" : "openconfig-mpls",
    "bag-name" : "mpls_rsvp_interface_counters",
    "bag-file" : "oc_mpls_rsvp.bag",
    "xr-path" : "/oper/ip_rsvp/gl/active/oc/if_counters/*",
    "mpg-path": "RootOper.RSVP.OpenConfig.InterfaceCounters(*)",
    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0
      }
    ],

    "overlay-nodes" :
    [ {
        "name" : "openconfig-mpls:mpls",
        "field-id" : 1,
        "overlay-nodes" :
        [ {
            "name" : "signaling-protocols",
            "field-id" : 1,
            "overlay-nodes" :
            [ {
                "name" : "rsvp-te",
                "field-id" : 1,
                "overlay-nodes" :
                [ {
                    "name" : "interface-attributes",
                    "field-id" : 1,
                    "overlay-nodes" :
                    [ {
                        "name" : "interface",
                        "field-id" : 1,
                        "naming-element-nodes" : [ {
                            "index" : 0,
                            "name": "interface-name",
                            "type": "string",
                            "field-id" : 1,
                            "key": True
                        } ],
                        "overlay-nodes" :
                        [ {
                            "name" : "state",
                            "field-id" : 1,
                            "overlay-nodes" :
                            [ {
                                "name" : "counters",
                                "field-id" : 1,
                                "bag-mapping-nodes" :
                                ocmpls_ip_rsvp_gl_active_oc_interface_counter_bag_mappings
                            } ]
                        } ]
                    } ]
                } ]
            } ]
        } ]
    } ]
}
