# -----------------------------------------------------------------------------
#  oc_mpls_te_lsp_counters.py -- bag map to oc-mpls
#
# May 2016, Christian Cassar
#
# Copyright (c) 2016 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

ocmpls_te_lsp_type_mapping = [
    {
        'bag-field' : "Type",
        'bag-type' : 'enum',
        'overlay-nodes' :
        [{'name' : 'type',
          'type' : 'enum',
          'field-id' : 10,
          'enum-map' : {
              0: 'P2P', # no unset in OC model
              1: 'P2P',
              2: 'P2MP',
          }}]
    }
]

ocmpls_te_lsp_counters_bag_mapping = [
    {
        'bag-field' : "Bytes",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'bytes', 'type' : 'uint64', 'field-id' : 1}]
    },
    {
        'bag-field' : "Packets",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'packets', 'type' : 'uint64', 'field-id' : 2}]
    },
    {
        'bag-field' : "PathChanges",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'path-changes', 'type' : 'uint64', 'field-id' : 3}]
    },
        {
        'bag-field' : "StateChanges",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'state-changes', 'type' : 'uint64', 'field-id' : 4}]
    },
    {
        'bag-field' : "OnlineTime",
        'bag-type' : 'string',
        'overlay-nodes' :
        [{'name' : 'online-time', 'type' : 'string', 'field-id' : 5}]
    },
        {
        'bag-field' : "CurrentPathTime",
        'bag-type' : 'string',
        'overlay-nodes' :
        [{'name' : 'current-path-time', 'type' : 'string', 'field-id' : 6}]
    },
    {
        'bag-field' : "NextReoptimizationTime",
        'bag-type' : 'uint64_t',
        'overlay-nodes' :
        [{'name' : 'next-reoptimization-time', 'type' : 'string', 'field-id' : 7}]
    },
]

mappings = {
    "overlay-model" : "openconfig-mpls",
    "bag-name" : "oc_mpls_te_lsp_counters",
    "bag-file" : "oc_mpls_te.bag",
    "xr-path" : "/oper/mpls_te/gl/oc/lsp_counters/*,*",
    "mpg-path": "RootOper.MPLS_TE.OpenConfig.LSPCountersTable.LSPCounters(*,*)",
    "naming-elements" :
    [ {
        # TunnelName
        "type" : "string",
        "index" : 0
      },
      {
        #TunnelType
        "type" : "enum",
        "index" : 1
      },
    ],
    "overlay-nodes" :
    [ {
        "name" : "openconfig-mpls:mpls",
        "field-id" : 1,
        "overlay-nodes" :
        [ {
            "name" : "lsps",
            "field-id" : 1,
            "overlay-nodes" :
            [ {
                "name" : "constrained-path",
                "field-id" : 1,
                "overlay-nodes" :
                [ {
                    "name" : "tunnel",
                    "field-id" : 1,
                    "naming-element-nodes" : [ {
                        "index" : 0,
                        "name": "name",
                        "type": "string",
                        "field-id" : 1,
                        "key": True
                    } ],

                    "bag-mapping-nodes" :
                    ocmpls_te_lsp_type_mapping,

                    "overlay-nodes" :
                    [ {
                        "name" : "state",
                        "field-id" : 1,
                        "overlay-nodes" :
                        [ {
                            "name" : "counters",
                            "field-id" : 1,
                            "bag-mapping-nodes" :
                            ocmpls_te_lsp_counters_bag_mapping
                        } ]
                    } ]
                } ]
            } ]
        } ]
    } ]
}
