# -----------------------------------------------------------------------------
#  oc_mpls_te_lsp_state.py -- bag map to oc-mpls
#
# May 2016, Christian Cassar
#
# Copyright (c) 2016 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

ocmpls_te_lsp_type_mapping = [
    {
        'bag-field' : "Type",
        'bag-type' : 'enum',
        'overlay-nodes' :
        [{'name' : 'type',
          'type' : 'enum',
          'field-id' : 10,
          'enum-map' : {
              0: 'P2P', # no unset in OC model
              1: 'P2P',
              2: 'P2MP',
          }}]
    }
]

ocmpls_te_lsp_state_bag_mapping = [
    {
        'bag-field' : "Name",
        'bag-type' : 'string',
        'overlay-nodes' :
        [{'name' : 'name', 'type' : 'string', 'field-id' : 1}]
    },
    {
        'bag-field' : "Type",
        'bag-type' : 'enum',
        'overlay-nodes' :
        [{'name' : 'type',
          'type' : 'enum',
          'field-id' : 2,
          'enum-map' : {
              0: 'P2P', # no unset in OC model
              1: 'P2P',
              2: 'P2MP',
          }}]
    },
    {
        'bag-field' : "Description",
        'bag-type' : 'string',
        'overlay-nodes' :
        [{'name' : 'description', 'type' : 'string', 'field-id' : 3}]
    },
    {
        'bag-field' : "SignalingProtocol",
        'bag-type' : 'enum',
        'overlay-nodes' :
        [{'name' : 'signaling-protocol',
          'type' : 'enum',
          'field-id' : 4,
          'enum-map' : {
              0: 'PATH_SETUP_RSVP', # no unknown in OC model
              1: 'PATH_SETUP_RSVP',
          }}]
    },
    {
        'bag-field' : "AdminStatus",
        'bag-type' : 'enum',
        'overlay-nodes' :
        [{'name' : 'admin-status',
          'type' : 'enum',
          'field-id' : 5,
          'enum-map' : {
              0: 'ADMIN_UP',
              1: 'ADMIN_DOWN',
          }}]
    },
    {
        'bag-field' : "OperStatus",
        'bag-type' : 'enum',
        'overlay-nodes' :
        [{'name' : 'oper-status',
          'type' : 'enum',
          'field-id' : 6,
          'enum-map' : {
              0: 'UP',
              1: 'DOWN',
          }}]
    },
    {
        'bag-field' : "Metric",
        'bag-type' : 'enum',
        'overlay-nodes' :
        [{'name' : 'metric-type',
          'type' : 'enum',
          'field-id' : 7,
          'enum-map' : {
              0: 'LSP_METRIC_INHERITED',
              1: 'LSP_METRIC_ABSOLUTE',
          }}]
    },
    {
        'bag-field' : "ProtectionStyleRequested",
        'bag-type' : 'enum',
        'overlay-nodes' :
        [{'name' : 'protection-style-requested',
          'type' : 'enum',
          'field-id' : 8,
          'enum-map' : {
              0: 'UNPROTECTED',
              1: 'LINK_PROTECTION_REQUIRED',
              2: 'LINK_NODE_PROTECTION_REQUESTED',
          }}]
    },
    {
        'bag-field' : "ReoptimizeTimer",
        'bag-type' : 'uint16',
        'overlay-nodes' :
        [{'name' : 'reoptimize-timer', 'type' : 'uint16', 'field-id' : 9}]
    },
    {
        'bag-field' : "Role",
        'bag-type' : 'enum',
        'overlay-nodes' :
        [{'name' : 'role',
          'type' : 'enum',
          'field-id' : 10,
          'enum-map' : {
              0: 'INGRESS', # default, no UNKNOWN in model
              1: 'INGRESS',
              2: 'TRANSIT',
              3: 'EGRESS',
          }}]
    },
    {
        'bag-field' : "SetupPriority",
        'bag-type' : 'uint8',
        'overlay-nodes' :
        [{'name' : 'setup-priority', 'type' : 'uint8', 'field-id' : 11}]
    },
        {
        'bag-field' : "HoldPriority",
        'bag-type' : 'uint8',
        'overlay-nodes' :
        [{'name' : 'hold-priority', 'type' : 'uint8', 'field-id' : 12}]
    },

    {
        'bag-field' : "SoftPreemption",
        'bag-type' : 'bool',
        'overlay-nodes' :
        [{'name' : 'soft-preemption', 'type' : 'boolean', 'field-id' : 13}]
    },
]

mappings = {
    "overlay-model" : "openconfig-mpls",
    "bag-name" : "oc_mpls_te_lsp_state",
    "bag-file" : "oc_mpls_te.bag",
    "xr-path" : "/oper/mpls_te/gl/oc/lsp_states/*,*",
    "mpg-path": "RootOper.MPLS_TE.OpenConfig.LSPStateTable.LSPState(*,*)",
    "naming-elements" :
    [ {
        # TunnelName
        "type" : "string",
        "index" : 0
      },
      {
        #TunnelType
        "type" : "enum",
        "index" : 1
      },
    ],
    "overlay-nodes" :
    [ {
        "name" : "openconfig-mpls:mpls",
        "field-id" : 1,
        "overlay-nodes" :
        [ {
            "name" : "lsps",
            "field-id" : 1,
            "overlay-nodes" :
            [ {
                "name" : "constrained-path",
                "field-id" : 1,
                "overlay-nodes" :
                [ {
                    "name" : "tunnel",
                    "field-id" : 1,
                    "naming-element-nodes" : [ {
                        "index" : 0,
                        "name": "name",
                        "type": "string",
                        "field-id" : 1,
                        "key": True
                    } ],

                    "bag-mapping-nodes" :
                    ocmpls_te_lsp_type_mapping,

                    "overlay-nodes" :
                    [ {
                        "name" : "state",
                        "field-id" : 1,
                        "bag-mapping-nodes" :
                        ocmpls_te_lsp_state_bag_mapping
                    } ]
                } ]
            } ]
        } ]
    } ]
}
