# -----------------------------------------------------------------------------
# inv_phy_entity_basic_info.py 
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------


state_overlay_node = {
    "name" : "state",
    "field-id": 1,
    "bag-mapping-nodes" : [
        {
            "bag-field" : "Name",
            "bag-type" : "string",
            "overlay-nodes" :
            [
              {
                "name" : "name",
                "field-id" : 1,
                "type" : "string"
                },
            ]
        },

        {
            "bag-field" : "CompositeClassCode",
            "bag-type" : "int32_t",
            "overlay-nodes" : 
            [
                {
                    "name" : "type",
                    "field-id" : 2,
                    "type" : "string",
                    "oc-inventory-type" : True
                }
            ]
        },

        {
            "bag-field" : "UniqueID",
            "bag-type" : "int32",
            "overlay-nodes":
            [

              {
                "name" : "id",
                "field-id" : 3,
                "type" : "string"
              }
            ]
        },

        {
             "bag-field" : "Description",
             "bag-type" : "string",
             "overlay-nodes":
             [

               {
                 "name" : "description",
                 "field-id" : 4,
                 "type" : "string",
                }
             ]
         },
         {
             "bag-field" : "ManufacturerName",
             "bag-type" : "string",
             "overlay-nodes":
             [

               {
                 "name" : "mfg-name",
                 "field-id" : 5,
                 "type" : "string",
               }
             ]
         },
         {
             "bag-field" : "HardwareRevision",
             "bag-type" : "string",
             "overlay-nodes":
             [

               {
                 "name" : "version",
                 "field-id" : 6,
                 "type" : "string",
               }
             ]
         },
         {
             "bag-field" : "SerialNumber",
             "bag-type" : "string",
             "overlay-nodes":
             [

               {
                 "name" : "serial-no",
                 "field-id" : 7,
                 "type" : "string",
               }
             ]
         },
 
    ]
}





mappings = {
    "overlay-model" : "openconfig-platform",
    "bag-name" : "inv_phy_entity_basic_info",
    "bag-file" : "inv",
    "xr-path" : "/oper/inventory/gl/entity/*/attrib/inv_basic_bag",
    "mpg-path": "RootOper.Inventory.Entity(*).Attrib.InvBasicBag",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0
      }
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-platform:components",
        "field-id" : 1,
        "overlay-nodes" :
        [   {
             "name" : "component",
             "field-id" : 1,
             "naming-element-nodes" :
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string" ,
                 "field-id": 1,
                 "key": True,
                 "inventory-name": True

                }
             ],

             "overlay-nodes" : [ state_overlay_node ]

            }

        ]

        }

    ]

}

# END BAG optics_ui
#################################################################
