# -----------------------------------------------------------------------------
# optics_edm_lane_data
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------


state_overlay_node = {
    "name" : "state",
    "field-id": 1,
    "naming-element-nodes" : [
        {
            "index" : 1,
            "name" : "index",
            "field-id" : 1,
            "type" : "uint16",
            "key" : True
        }
    ],
    "bag-mapping-nodes" : [
        {
           "bag-field" : "OutputFrequency",
           "bag-type" : "int32",
           "register-ops" :
            [{"register": 0, "operation": "load"}],
       
        }
    ],
    "overlay-nodes" : 
    [
      
       {
         "name" : "output-power",
         "field-id" : 2,
         "bag-mapping-nodes" : [
             {
                 "bag-field" : "TransmitPower",
                 "bag-type" : "int32",
                 "overlay-nodes" :
                 [
                     {
                         "name" : "instant",
                         "field-id" : 1,
                         "type" : "decimal64"
                     }
                 ]
             }
          ]
        },
       {
         "name" : "input-power",
         "field-id" : 3,
         "bag-mapping-nodes" : [
             {
                 "bag-field" : "ReceivePower",
                 "bag-type" : "int32",
                 "overlay-nodes" :
                 [
                     {
                         "name" : "instant",
                         "field-id" : 1,
                         "type" : "decimal64"
                     }
                 ]
             }
          ]
        },
        
        {
         "name" : "laser-bias-current",
         "field-id" : 4,
         "bag-mapping-nodes" : [
             {
                 "bag-field" : "LaserBiasCurrentMilliAmps",
                 "bag-type" : "int32",
                 "register-dec64-ops" : [ { "register" : 0, "operation" : "load" } ],
            }
           ],

          "register-dec64-ops" : [
              { "register" : 0 , "operation" : "regdiv", "const_value" : 100 },
              { "register" : 0 , "operation" : "decode",
                  "overlay-nodes" : [ { "name" : "instant", "field-id" : 1, "type" : "decimal64" } ]
              }
           ]

        },
    
    ],

    "register-ops":
     [
      {"register":0,
       "operation": "decode",
       "overlay-nodes" : [
               {
                "name" : "output-frequency",
                "field-id" : 1,
                "type" : "uint64"
                }
        ]
      } 
     ]

}


ocplatform__optics_ui__transceiver_overlay_node = { 
    "name" : "openconfig-platform-transceiver:transceiver",
    "field-id": 1001,  # augmentation
    "overlay-nodes" :
    [ {
        "name" : "physical-channels",
        "field-id" : 2,
        "overlay-nodes" : [
           {
               "name" : "channel",
               "field-id" : 1,
               "naming-element-nodes" : [
                  {
                    "index" : 1,
                    "name" : "index",
                    "field-id" : 1,
                    "type" : "uint16",
                    "key" : True
                    
                    
                    }
                  ],
                 "overlay-nodes" : [
                     state_overlay_node
                  ]    
                      
             }
                
          ]      
        
        }
    ]
        
        
    
}

mappings = {
    "overlay-model" : "openconfig-platform",
    "bag-name" : "optics_edm_lane_data",
    "bag-file" : "optics_ui",
    "xr-path" : "/oper/optics/if/*/lane_info/*",
    "mpg-path": "RootOper.Optics.Interface(*).LaneInfo(*)",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0
      },
     {
       "type" : "uint32",
       "index" : 1 
     }
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-platform:components",
        "field-id" : 1,
        "overlay-nodes" :
        [   {
             "name" : "component",
             "field-id" : 1,
             "naming-element-nodes" :
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string" ,
                 "field-id": 1,
                 "key": True,
                 "transceiver-name": True,

                }
             ],

             "overlay-nodes" : [ ocplatform__optics_ui__transceiver_overlay_node ]

            }

        ]

        }

    ]

}

# END BAG optics_edm_lane_data
#################################################################
