# -----------------------------------------------------------------------------
# ipv6_unicast_neighbor_adj_rib_out_pre_routes.py
#
# August 2017, Manu Radhakrishna
#
# Copyright (c) 2017-2018 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------


route_attributes_aggregator_node = {
    'name' : 'aggregator',
    'field-id' : 1,
    'bag-mapping-nodes' : [
        {
            'bag-field' : 'RouteAttrList',
            'bag-type' : 'subtype',
            'bag-mapping-nodes' : [
                    {
                        'bag-field' : 'AggregatorAttributes',
                        'bag-type' : 'subtype',
                        'bag-mapping-nodes' : [
                            {
                                'bag-field' : 'AS',
                                'bag-type' : 'uint32',
                                'overlay-nodes' : [
                                    {
                                        'name' : 'as',
                                        'field-id' : 1,
                                        'type' : 'uint32'
                                    }
                                ]
                            },
                            {
                                'bag-field' : 'AS4',
                                'bag-type' : 'uint32',
                                'overlay-nodes' : [
                                    {
                                        'name' : 'as4',
                                        'field-id' : 2,
                                        'type' : 'uint32'
                                    }
                                ]
                            },
                            {
                                'bag-field' : 'Address',
                                'bag-type' : 'string',
                                'overlay-nodes' : [
                                    {
                                        'name' : 'address',
                                        'field-id' : 3,
                                        'type' : 'string'
                                    }
                                ]
                            },                            
                            
                         ]
                    }
             ]
        }
     ]

}

route_attributes_overlay_node = {
    'name' : 'attributes',
    'field-id' : 2,
    'bag-mapping-nodes' : [
        {
            'bag-field' : 'RouteAttrList',
            'bag-type' : 'subtype',
            'bag-mapping-nodes' : [
                {
                    'bag-field' : 'OriginType',
                    'bag-type' : 'enum',
                    'overlay-nodes' :[
                        {
                            'name' : 'origin',
                            'field-id' : 1,
                            'type' : 'enum',
                            'enum-map' : {
                                   0 : "IGP", #igp
                                   1 : "EGP", #egp
                                   2 : "INCOMPLETE", #incomplete
                            }

                        }
                    
                    ]
                },
                                   
                {
                    'bag-field' : 'AsPath',
                    'bag-type' : 'string',
                    'overlay-nodes' :[
                        {
                            'name' : 'as-path',
                            'field-id' : 2,
                            'type' : 'string'
                        }
                    
                    ]
                },
                                   
                {
                    'bag-field' : 'As4Path',
                    'bag-type' : 'string',
                    'overlay-nodes' :[
                        {
                            'name' : 'as4-path',
                            'field-id' : 3,
                            'type' : 'string'
                        }
                    
                    ]
                },
                                   
                {
                    'bag-field' : 'NextHop',
                    'bag-type' : 'subtype',
                    'bag-mapping-nodes' : [
                        {
                            'bag-field' : 'Ipv4Address',
                            'bag-type' : 'string',
                            'overlay-nodes' : [
                                {
                                    'name' : 'next-hop',
                                    'field-id' : 4,
                                    'type' : 'string'
                                }
                            ]
                        },
                        {
                            'bag-field' : 'Ipv6Address',
                            'bag-type' : 'string',
                            'overlay-nodes' : [
                                {
                                    'name' : 'next-hop',
                                    'field-id' : 4,
                                    'type' : 'string'
                                }
                            ]
                        },
                        
                    ]
                
                },
                                   
                {
                    'bag-field' : 'Med',
                    'bag-type' : 'uint32',
                    'overlay-nodes' :[
                        {
                            'name' : 'med',
                            'field-id' : 5,
                            'type' : 'uint32'
                        }
                    
                    ]
                },
                                   
                {
                    'bag-field' : 'LocalPref',
                    'bag-type' : 'uint32',
                    'overlay-nodes' :[
                        {
                            'name' : 'local-pref',
                            'field-id' : 6,
                            'type' : 'uint32'
                        }
                    
                    ]
                },
                                   
                {
                    'bag-field' : 'AtomicAggr',
                    'bag-type' : 'boolean',
                    'overlay-nodes' :[
                        {
                            'name' : 'atomic-aggr',
                            'field-id' : 7,
                            'type' : 'boolean'
                        }
                    
                    ]
                },
                                   
                {
                    'bag-field' : 'Community',
                    'bag-type' : 'array',
                    'overlay-nodes' : [
                      {
                        'name' : 'community',
                        'field-id' : 8,
                        'type' : 'subtype',
                        'flatten' :  True,
                        'bag-mapping-nodes' : [
                         {
                            'bag-field': 'Objects',
                            'bag-type': 'string',
                            'overlay-nodes' : [
                                {
                                    'name' : 'community',
                                    'field-id' : 8,
                                    'type' : 'string',
                                    
                                }
                            ]
                         }
                         ] 
                      }
                     ]

                 }

             ]
         }                    
    
    ],
    
    'overlay-nodes' : [ route_attributes_aggregator_node ]
}

route_ext_attributes_unknown_attribute_overlay_node = {
    'name' : 'unknown-attribute',
    'field-id' : 1,
    'bag-mapping-nodes' : [
        {
            'bag-field' : 'ExtAttributesList',
            'bag-type' : 'subtype',
            'bag-mapping-nodes' : [
                {
                    'bag-field' : 'UnknownAttributes',
                    'bag-type' : 'subtype',
                    'bag-mapping-nodes' : [
                        {
                            'bag-field' : 'AttributeType',
                            'bag-type' : 'uint16',
                            'overlay-nodes' :[
                                {
                                    'name': 'attr-type',
                                    'field-id' : 1,
                                    'type' : 'uint16'
                                }
                             ]
                        },
                                           
                        {
                            'bag-field' : 'AttributeLength',
                            'bag-type' : 'uint16',
                            'overlay-nodes' :[
                                {
                                    'name': 'attr-len',
                                    'field-id' : 2,
                                    'type' : 'uint16'
                                }
                             ]
                        },
                        {
                            'bag-field' : 'AttributeValue',
                            'bag-type' : 'hexstring',
                            'overlay-nodes' :[
                                {
                                    'name': 'attr-value',
                                    'field-id' : 3,
                                    'type' : 'string'
                                }
                             ]
                        }
                    
                    ]
                
                }

            ]

        }

    ]

}


route_ext_attributes_overlay_node = {
    'name' : 'ext-attributes',
    'field-id' : 3,
    'bag-mapping-nodes' : [
        {
            'bag-field' : 'ExtAttributesList',
            'bag-type'  : 'subtype',
            'bag-mapping-nodes' :[
                {
                    'bag-field' : 'OriginatorId',
                    'bag-type' : 'string',
                    'overlay-nodes' : [
                        {
                            'name' : 'originator-id',
                            'field-id' : 2,
                            'type' : 'string'
                        }
                    ]
                },                
                
                
                {
                    'bag-field' : 'Cluster',
                    'bag-type' : 'string',
                    'overlay-nodes' : [
                        {
                            'name' : 'cluster-list',
                            'field-id' : 2,
                            'type' : 'string'
                        }
                    ]
                },
                
                {
                    'bag-field' : 'ExtCommunity',
                    'bag-type' : 'array',
                    'overlay-nodes' : [
                     {
                        'name' : 'ext-community',
                        'field-id' : 3,
                        'type' : 'subtype',
                        'flatten' :  True,
                        'bag-mapping-nodes' : [
                         {
                            'bag-field': 'Objects',
                            'bag-type': 'string',
                            'overlay-nodes' : [
                                {
                                    'name' : 'ext-community',
                                    'field-id' : 3,
                                    'type' : 'string',
                                    
                                }
                            ]
                        }
                        ]
                     }
                     ]

                },
                {
                    'bag-field' : 'AIGP',
                    'bag-type' : 'uint64',
                    'overlay-nodes' : [
                        {
                            'name' : 'aigp',
                            'field-id' : 4,
                            'type' : 'uint64'
                        }
                    ]
                },
                
                {
                    'bag-field' : 'PathId',
                    'bag-type' : 'uint32',
                    'overlay-nodes' : [
                        {
                            'name' : 'path-id',
                            'field-id' : 5,
                            'type' : 'uint32'
                        }
                    ]
                }
            ]
        }
     ],
    
    'overlay-nodes' : [ route_ext_attributes_unknown_attribute_overlay_node ]
}

route_bag_mapping_nodes = [
        {
            'bag-field' : 'LastModifiedDate',
            'bag-type' : 'subtype',
            'bag-mapping-nodes' : [
                {
                    'bag-field' : 'TimeValue',
                    'bag-type' : 'string',
                    'overlay-nodes' : [
                        {
                            'name' : 'last-modified-date',
                            'field-id' : 2,
                            'type' : 'string'
                        }
                    ]
                }
            ]
        },
        
        {
            'bag-field' : 'LastUpdateReceived',
            'bag-type' : 'subtype',
            'bag-mapping-nodes' : [
                {
                    'bag-field' : 'TimeValue',
                    'bag-type' : 'string',
                    'overlay-nodes' : [
                        {
                            'name' : 'last-update-received',
                            'field-id' : 3,
                            'type' : 'string'
                        }
                    ]
                }
            ]
        },
                           
        {
         'bag-field' : 'ValidRoute',
         'bag-type' : 'boolean',
         'overlay-nodes' : [
             {
                 'name' : 'valid-route',
                 'field-id' : 4,
                 'type' : 'boolean'
             }
          ]
        },
        
        {
         'bag-field' : 'InvalidReason',
         'bag-type' : 'enum',
         'overlay-nodes' : [
             {
                 'name' : 'invalid-reason',
                 'field-id' : 5,
                 'type' : 'enum',
                 'enum-map' :    {
                        1 : "openconfig-rib-bgp-types:INVALID_REASON" , #VALID_ROUTE
                        2 : "openconfig-rib-bgp-types:INVALID_CLUSTER_LOOP" , #INVALID_CLSUTER_LOOP
                        3 : "openconfig-rib-bgp-types:INVALID_AS_PATH_LOOP" , #INVALID_AS_PATH_LOOP
                        3 : "openconfig-rib-bgp-types:INVALID_ORIGINATOR_ID" , #INVALID_ORIGNATOR_ID
                        4 : "openconfig-rib-bgp-types:INVALID_AS_CONFED_LOOP" , #ASConfedLoop
                 }
             }
          ]
        },

        {
         'bag-field' : 'BestPath',
         'bag-type' : 'boolean',
         'overlay-nodes' : [
             {
                 'name' : 'best-path',
                 'field-id' : 6,
                 'type' : 'boolean'
             }
          ]
        },
]


loc_rib_route_overlay_node = {
    'name' : 'route',
    'field-id' : 1,
    "naming-element-nodes" :
     [
      {
       "index" : 0,
       "name": "prefix",
       "type": "string" ,
       "field-id": 1,
       "key": False,
       }
     ],
    'bag-mapping-nodes' : route_bag_mapping_nodes,
    
    'overlay-nodes' : [
        route_attributes_overlay_node,
        route_ext_attributes_overlay_node
    ]
}

neighbor_route_overlay_node = {
    'name' : 'route',
    'field-id' : 1,
    "naming-element-nodes" :
     [
      {
       "index" : 1,
       "name": "prefix",
       "type": "string" ,
       "field-id": 1,
       "key": False,
       }
     ],

    'bag-mapping-nodes' : route_bag_mapping_nodes,
    
    'overlay-nodes' : [
        route_attributes_overlay_node,
        route_ext_attributes_overlay_node
    ]
}

loc_rib_overlay_node = {
    
    "name" : "loc-rib",
    'field-id' : 1,
    'overlay-nodes' : [
         {
             'name' : 'routes',
             'field-id' : 1,
             'overlay-nodes' : [ loc_rib_route_overlay_node ]
         }
    ]
}

def get_loc_rib_mapping(index, af_type, af_type_field_id, register_ops):
    mappings = {
    "overlay-model" : "openconfig-rib-bgp",
    "namespace" : "http://openconfig.net/yang/rib/bgp",
    "bag-name" : "bgp_oc_route_bag",
    "bag-file" : "bgp_oc",
    "xr-path" :  
        '/oper/oc-bgp/gl/instance/default/act/vrf/default/bgp_rib/afi/{0}/loc_rib/routes/<>,<>,<>,<>'.format(index),
    "naming-elements" :
    [ 
        {"type" : "string", "index" : 0},
        {"type" : "string", "index" : 1},
        {"type" : "string", "index" : 2},      
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-rib-bgp:bgp-rib",
        "field-id" : 1,
        "overlay-nodes" :
        [   {
             "name" : "afi-safis",
             "field-id" : 1,
             "overlay-nodes" : [ 
                {
                    "name" : "afi-safi",
                    "field-id" : 1,
                    "overlay-nodes" : [
                        {
                            "name" : af_type,
                            "field-id" : af_type_field_id,
                            "overlay-nodes" : [ loc_rib_overlay_node ]
                        }
                    ],
                    "register-ops" : register_ops
                }
                 
            ],
            }
        ]
        }
    ]
    }
    return mappings

def get_neighbors_overlay_node(rib_field_name, rib_field_id):
    
    neighbors_overlay_node = {
        "name" : "neighbors",
        'field-id' : 2,
        'overlay-nodes': 
        [
         {
          'name' : 'neighbor',
          'field-id' : 1,
          "naming-element-nodes" :
          [
           {
            "index" : 0,
            "name": "neighbor-address",
            "type": "string" ,
            "field-id": 1,
            "key": True,
           }
          ],
          'overlay-nodes' : 
          [
           {
            'name' : rib_field_name,
            'field-id' : rib_field_id,
            'overlay-nodes' : [
                {
                    'name' : 'routes',
                    'field-id' : 1,
                    'overlay-nodes' : [ neighbor_route_overlay_node ]
                }
            ]
           }
          ]
        }
       ]
    }
    return neighbors_overlay_node

def get_neighbors_mapping(index, af_type, af_type_field_id, 
                          register_ops, rib_field_path_segment,
                          rib_field_name, rib_field_id):
    mappings = {
    "overlay-model" : "openconfig-rib-bgp",
    "namespace" : "http://openconfig.net/yang/rib/bgp",
    "bag-name" : "bgp_oc_route_bag",
    "bag-file" : "bgp_oc",
    "xr-path" :  
        '/oper/oc-bgp/gl/instance/default/act/vrf/default/bgp_rib/afi/{0}/neighbors/<>/{1}/routes/<>,<>,<>,<>'.format(index,rib_field_path_segment),
 
    "naming-elements" :
    [ 
        {"type" : "string","index" : 0},
        {"type" : "string","index" : 1},
        {"type" : "string","index" : 2},      
        {"type" : "string","index" : 3},
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-rib-bgp:bgp-rib",
        "namespace" : "http://openconfig.net/yang/rib/bgp",
        "field-id" : 1,
        "overlay-nodes" :
        [   {
             "name" : "afi-safis",
             "field-id" : 1,
             "overlay-nodes" : [ 
                {
                    "name" : "afi-safi",
                    "field-id" : 1,
                    "overlay-nodes" : [
                        {
                            "name" : af_type,
                            "field-id" : af_type_field_id,
                            "overlay-nodes" : [ get_neighbors_overlay_node(rib_field_name, rib_field_id) ]
                        }
                    ],
                    "register-ops": register_ops
                }
                 
            ]
            }
        ]
        }
    ]
    }
    return mappings


def get_afi_safi_name_reg_ops(afi_safi_name):

    register_ops = [
    {
     "register": 0, 
     "operation":"regmult", 
     "const_value" : 0 
     },
     {
      "register": 0,
      "operation": "decode",
      "overlay-nodes":
      [
       {
        "name" : "afi-safi-name",
        "field-id" : 1,
        "type" : "enum",
        "enum-map" :
         {
          0 : afi_safi_name
         }
        }
       ]
      }
    ]

    return register_ops

mappings = get_neighbors_mapping(5, 
                                 'ipv6-unicast', 
                                 3,
                                 get_afi_safi_name_reg_ops('openconfig-bgp-types:IPV6_UNICAST'),
                                 'adj_rib_out_pre',
                                 'adj-rib-out-pre',
                                 5)

