# -----------------------------------------------------------------------------
# ethernet_show_controller.bag/ethernet_controller_bag_v2_type --  bag mapping for openconfig-terminal-device
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------


state_overlay_node = {
    "name" : "state",
    "field-id" : 1,
    "bag-mapping-nodes" : 
    [
        {
            "bag-field" : "OperStateUp",
            "bag-type" : "boolean",
            "register-ops" :
                [{"register" : 0, "operation" : "load"}],
        }
 
    ],
    "register-ops":
    [
        {
            "register" : 0,
            "operation" : "decode",
            "overlay-nodes":
            [

              {
                "name" : "link-state",
                "field-id" : 1,
                "type" : "enum",
                "enum-map" :
                 {
                   0  : 'DOWN', 
                   1  : 'UP'
                 }
              }
            ]
            
        }
     ]
                   
}


mappings = {
    "overlay-model" : "openconfig-terminal-device",
    "bag-name" : "ethernet_controller_driver_bag_v2_type",
    "bag-file" : "ethernet_show_controller.bag",
    "xr-path" : "/oper/ethernet_drvr/oper/if/*",


    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0, #need to be converted to logical channel
      }
    ],
     
    "overlay-nodes" :
    [   {
        "name" : "openconfig-terminal-device:terminal-device",
        "conditions" :[
            {
                "name" : "is_naming_element_ethernet_controller",
                "index" : 0,
                "match-value" : True
            }
        ],
        "field-id" : 1,
        "overlay-nodes" :
        [ {
            "name" : "logical-channels",
            "field-id" : 1,
            "overlay-nodes" :
            [   {
                "name" : "channel",
                "field-id" : 1,
                "naming-element-nodes" :
                [
                    {
                    "index" : 0,
                    "name": "index",
                    "type": "string" ,
                    "optical-logical-id" : True,
                    "field-id": 1,
                    "key": True

                    }
                ],

                "overlay-nodes" :
                
                [ state_overlay_node ]   
                }
             ]
            }
         ]
         }
     ]
}   



# END BAG ethernet_show_controller
#################################################################
