# -----------------------------------------------------------------------------
# ethernet_show_controller.bag/ethernet_port_stats_type -- ethernet_show_controller/ethernet_port_stats_type bag mapping for openconfig-terminal-device
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

octerminal_device__ethernet_show_controller__ethernet_state_overlay_node = { 
    "name" : "state",
    "field-id": 1,
    "bag-mapping-nodes" : [
     {
       "bag-field" : "ReceivedPauseFrames",
       "bag-type" : "uint64",
       "overlay-nodes" :
       [{"name" : "in-mac-pause-frames",
         "field-id" : 1,
         "type" : "uint64"
         
         }
       ]

     },
     {
       "bag-field" : "DroppedGiantPacketsGreaterthanMRU",
       "bag-type"  : "uint64",
       "overlay-nodes":
       [{"name" : "in-oversize-frames",
         "field-id" : 2,
         "type" : "uint64"
        
        }
       ]
     },
   
     {
       "bag-field" : "DroppedJabbersPacketsGreaterthanMRU",
       "bag-type" : "uint64",
       "overlay-nodes":
       [{"name" : "in-jabber-frames",
         "field-id" : 3,
         "type" : "uint64"
        }
       ]
     },


     {
       "bag-field" : "DroppedEtherStatsFragments",
       "bag-type" : "uint64",
       "overlay-nodes":
       [{"name" : "in-fragment-frames",
         "field-id" : 4,
         "type" : "uint64"
        
        }
       ]
     },

     {
      "bag-field" : "DroppedPacketsWithCRCAlignErrors",
      "bag-type" : "uint64",
      "overlay-nodes":
      [{"name" : "in-crc-errors",
        "field-id" : 5,
        "type" : "uint64"
       }

      ]
     },

     {
      "bag-field" : "TransmittedTotalPauseFrames",
      "bag-type" : "uint64",
      "overlay-nodes":
      [{"name" : "out-mac-pause-frames",
        "field-id" : 6,
        "type" : "uint64"

        }
      ]
     }

   ]
}

mappings = {
    "overlay-model" : "openconfig-terminal-device",
    "bag-name" : "ethernet_port_stats_type",
    "bag-file" : "ethernet_show_controller.bag",
    "xr-path" : "/oper/ethernet_drvr/stats/ifg/*",
    "mpg-path": "RootOper.EthernetDrvr.Stats.Interface(*)",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0, #need to be converted to logical channel
      }
    ],
     
    "overlay-nodes" :
    [   {
        "name" : "openconfig-terminal-device:terminal-device",
        "conditions" :[
            {
                "name" : "is_naming_element_ethernet_controller",
                "index" : 0,
                "match-value" : True
            }
        ],
        "field-id" : 1,
        "overlay-nodes" :
        [ {
            "name" : "logical-channels",
            "field-id" : 1,
            "overlay-nodes" :
            [   {
                "name" : "channel",
                "field-id" : 1,
                "naming-element-nodes" :
                [
                    {
                    "index" : 0,
                    "name": "index",
                    "type": "string" ,
                    "optical-logical-id" : True,
                    "field-id": 1,
                    "key": True

                    }
                ],

                "overlay-nodes" :
                [ {
                    "name" : "ethernet",
                    "field-id" : 3,
                    "overlay-nodes" : [
                        octerminal_device__ethernet_show_controller__ethernet_state_overlay_node
                    ]
                    

                  }
                ]

                }

            ]   

        }

        ] 
        }
    ]

}

# END BAG ethernet_show_controller
#################################################################
