# -----------------------------------------------------------------------------
# mxp_oc_port_assign_oper.bag/operational_mode_attributes -- mxp_oc_port_assign_oper bag mapping for openconfig-terminal-device
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

mappings = {
    "overlay-model" : "openconfig-terminal-device",
    "native-path" : "Cisco-IOS-XR-openconfig-terminal-device-oper:optical-interface/operational-modes/operational-mode[mode-id(int32)]/operational-mode-attributes",
    "bag-name" : "operational_mode_attributes",
    "bag-file" : "mxp_oc_port_assign_oper.bag",
    "xr-path"  : "/oper/oc-optical/gl/operational-mode/*/mode-attr",
    "mpg-path": "RootOper.MXPInterface.OperationalMode(*).ModeAttr",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0, #logical channel
      }
    ],
     
    "overlay-nodes" :
    [   {
        "name" : "openconfig-terminal-device:terminal-device",
        "field-id" : 1,
        "overlay-nodes" :
        [ {
            "name" : "operational-modes",
            "field-id" : 2,
            "overlay-nodes" :
            [   {
                "name" : "mode",
                "field-id" : 1,
                "naming-element-nodes" :
                [
                    {
                    "index" : 0,
                    "name": "mode-id",
                    "type": "string" ,
                    "field-id": 1,
                    "key": True

                    }
                ],

                "overlay-nodes" :
                [ {
                    "name" : "state",
                    "field-id" : 2,
                    "naming-element-nodes" : 
                    [
                      {
                      "index" : 0,
                      "name" : "mode-id",
                      "type" : "string",
                      "field-id" : 1,
                      "key" : False
                      }
                    ],
                    "bag-mapping-nodes" : [
                    {
                      "bag-field" : "Description",
                      "bag-type" : "string",
                      "overlay-nodes":
                      [{"name" : "description",
                         "field-id" : 2,
                         "type" : "string"
        
                       }
                     ]
                    },
                    {
                      "bag-field" : "VendorId",
                      "bag-type" : "string",
                      "overlay-nodes":
                      [{"name" : "vendor-id",
                         "field-id" : 3,
                         "type" : "string"
        
                       }
                     ]
                    },

                   ]
                   

                  }
                ]

                }

            ]   

        }

        ] 
        }
    ]

}

# END BAG mxp_oc_port_assign_oper
#################################################################
