# -----------------------------------------------------------------------------
# pmengine_ui.bag/pm_fec_paras -- pmengine_ui/pm_otn_paras bag mapping for openconfig-terminal-device
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

state_bag_mapping_nodes = [
   {
    "bag-field" : "UCWords",
    "bag-type"  : "subtype",
    "bag-mapping-nodes" : [
        {
            "bag-field" : "Data",
            "bag-type" : "uint32",
            "overlay-nodes" : [
                                {"name" : "fec-uncorrectable-words",
                                 "type" : "uint32",
                                 "field-id" : 7 
                                }
                            ]
        }

    ]

    },
    
    {
    "bag-field" : "ECBits",
    "bag-type"  : "subtype",
    "bag-mapping-nodes" : [
        {
            "bag-field" : "Data",
            "bag-type"  : "uint32",
            "overlay-nodes" : [
                    {
                       "name" : "fec-corrected-bits",
                       "type" : "uint32",
                       "field-id" : 8
                    }    
                ]
        }
    ]
    },

   
]

pre_fec_ber_overlay_node = {
    "name" : "pre-fec-ber",
    "field-id" : 1,
    "bag-mapping-nodes" : [
        {
            "bag-field" : "PreFEC_BER",
            "bag-type"  : "subtype",
            "bag-mapping-nodes" : [
                {
                    "bag-field" : "Average",
                    "bag-type" : "string",
                    "overlay-nodes" : [
                        {
                            "name" : "average",
                            "field-id" : 2,
                            "type" : "decimal64"
                        }
                    ]
                },
                {
                    "bag-field" : "Minimum",
                    "bag-type" : "string",
                    "overlay-nodes" : [
                        {
                            "name" : "minimum",
                            "field-id" : 3,
                            "type" : "decimal64"
                        }
                    ]
                },
                {
                    "bag-field" : "Maximum",
                    "bag-type" : "string",
                    "overlay-nodes" : [
                        {
                            "name" : "maximum",
                            "field-id" : 4,
                            "type" : "decimal64"
                        }
                    ]
                },
 
                
            ]
        }
    ]

}


post_fec_ber_overlay_node = {
    "name" : "post-fec-ber",
    "field-id" : 2,
    "bag-mapping-nodes" : [
        {
            "bag-field" : "PostFEC_BER",
            "bag-type"  : "subtype",
            "bag-mapping-nodes" : [
                {
                    "bag-field" : "Average",
                    "bag-type" : "string",
                    "overlay-nodes" : [
                        {
                            "name" : "average",
                            "field-id" : 2,
                            "type" : "decimal64"
                        }
                    ]
                },
                {
                    "bag-field" : "Minimum",
                    "bag-type" : "string",
                    "overlay-nodes" : [
                        {
                            "name" : "minimum",
                            "field-id" : 3,
                            "type" : "decimal64"
                        }
                    ]
                },
                {
                    "bag-field" : "Maximum",
                    "bag-type" : "string",
                    "overlay-nodes" : [
                        {
                            "name" : "maximum",
                            "field-id" : 4,
                            "type" : "decimal64"
                        }
                    ]
                },
 
                
            ]
        }
    ]

}


mappings = {
    "overlay-model" : "openconfig-terminal-device",
    "bag-name" : "pm_fec_paras",
    "bag-file" : "pmengine_ui.bag",
    "native-path" : "Cisco-IOS-XR-pmengine-oper:performance-management-history/global/periodic/otu-history/otu-port-histories/otu-port-history[name (xr:Interface-name)]/otu-second30-history/otu-second30fec-histories/otu-second30fec-history[number (int32)]/otu-second30fec-time-line-instances/otu-second30fec-time-line-instance[number (int32)]",
    "sensor-path" : "Cisco-IOS-XR-pmengine-oper:performance-management-history/global/periodic/otu-history/otu-port-histories/otu-port-history/otu-second30-history/otu-second30fec-histories/otu-second30fec-history/otu-second30fec-time-line-instances/otu-second30fec-time-line-instance",
    # Cisco-IOS-XR-pmenginer-oper:performance-management-history/global/periodic/otu-history/otu-port-histories/otu-port-history[name]/otu-second30-history/otu-second30fec-histories/otu-second30fec-history[n1]/otu-second30fec-time-line-instances/otu-second30fec-time-line-instance[n2]: 
    # name-> logical-channels/channel/index, n1=0 and n2=1
    "xr-path" : "/oper/perfmgmt/gl/periodic/otu/interface/*/30sec/fec/0/timeline_rev/1",
    "mpg-path": "RootOper.PerfMgmt.Periodic.Otu.Interface(*).30sec.Fec(*).TimelineRev(*)",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0, 
      },
      {
       "type" : "number",
       "index" : 1,
      },
      {
        "type" : "number",
        "index" : 2
      }
    ],
     
    "overlay-nodes" :
    [   {
        "name" : "openconfig-terminal-device:terminal-device",
        "field-id" : 1,
        "overlay-nodes" :
        [ {
            "name" : "logical-channels",
            "field-id" : 1,
            "overlay-nodes" :
            [   {
                "name" : "channel",
                "field-id" : 1,
                "naming-element-nodes" :
                [
                    {
                    "index" : 0,
                    "name": "index",
                    "type": "string" ,
                    "field-id": 1,
                    "key": True,
                    'optical-logical-id' : True

                    }
                ],

                "overlay-nodes" :
                [ {
                    "name" : "otn",
                    "field-id" : 2,
                    "overlay-nodes" : [
                        {
                            "name" : "state",
                            "field-id" : 1,
                            "bag-mapping-nodes" : 
                                state_bag_mapping_nodes
                             ,
                            "overlay-nodes" : [
                                pre_fec_ber_overlay_node,
                                post_fec_ber_overlay_node
                            ]
                            
                        }

                    ]

                  }
                ]

                }

            ]   

        }

        ] 
        }
    ]

}

# END BAG pm_fec_paras
#################################################################
