# -----------------------------------------------------------------------------
# bm_bundle_data.py -- bm_bundle_data bag mapping for openconfig-interface
#
# May 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------



ocif__bm_bundle_data__aggregation_state_overlay_node = {
    "name" : "state",
    "field-id": 1,
    "bag-mapping-nodes" : [
        {
            "bag-field" : "MinimumActiveLinks",
            "bag-type" : "uint8_t",
            "overlay-nodes" :
              [{"name" : "min-links", "type" : "uint16", "field-id" : 4}]

        },
    ]

}

ocif__bm_bundle_data__aggregation_overlay_node = {
    "name" : "openconfig-if-aggregate:aggregation",
    "namespace" : "http://openconfig.net/yang/interface/aggregate",
    "field-id": 1001,  # augmentation
    "overlay-nodes" :
    [ ocif__bm_bundle_data__aggregation_state_overlay_node ]
}

mappings = {
    "overlay-model" : "openconfig-interfaces",
    "bag-name" : "bundlemgr_distrib.bag",
    "bag-file" : "bm_bundle_data",
    "xr-path" : "/oper/bm-bdl/if/<>/bundle_data",
    "mpg-path": "RootOper.Bundles.Bundle(*).Data",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0
      }
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-interfaces:interfaces",
        "namespace" : "http://openconfig.net/yang/interfaces",
        "field-id" : 1,
        "overlay-nodes" :
        [   {
             "name" : "interface",
             "field-id" : 1,
             "naming-element-nodes" :
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string" ,
                 "field-id": 1,
                 "key": True

                }
             ],

             "overlay-nodes" :
             [ ocif__bm_bundle_data__aggregation_overlay_node ]

            }

        ]

        }

    ]

}

# END BAG bm_bundle_data
#################################################################

overlay_mappings = [mappings]

