# -----------------------------------------------------------------------------
# ocif-statsd-counters.py -- ifstatsbag_generic bag mapping for openconfig-interface
#
# June 2018, Ujjaini Sengupta
#
# Copyright (c) 2018-2019 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

ocif__ifstatsbag_generic__state_counters_overlay_node = {
    "name" : "counters",
    "field-id" : 2,
    "bag-mapping-nodes" :
    [
           {
            "bag-field" : "PacketsReceived",
            "bag-type" : "uint64_t",
            "register-ops" :
            [{"register": 0, "operation":"+"}]
            
            },
           
           {
            "bag-field" : "BytesReceived",
            "bag-type" : "uint64_t",
            "overlay-nodes" : 
            [{"name" : "in-octets", "type" : "uint64", "field-id" : 1, }]
            },
       
            {
             "bag-field" : "BytesSent",
             "bag-type" : "uint64_t",
             "overlay-nodes" :
             [{"name" : "out-octets", "type" : "uint64", "field-id" : 2}]
             },
       
             {
              "bag-field" : "MulticastPacketsReceived",
              "bag-type": "uint64_t",
              "register-ops" :
              [{"register": 0, "operation":"-"}],
              "overlay-nodes" :
              [{"name" : "in-multicast-pkts", "type" : "uint64", "field-id" : 3}]
              },
              
       
              {
               "bag-field" : "BroadcastPacketsReceived",
               "bag-type" : "uint64_t",
               "register-ops" :
               [{"register": 0, "operation":"-"}],
               "overlay-nodes" :
               [{"name" : "in-broadcast-pkts", "type" : "uint64", "field-id" : 4}]
               },
       
                {
                "bag-field" : "PacketsSent",
                "bag-type" : "uint64_t",
                "register-ops" :
                [{"register": 2, "operation":"+"}]
                
                },
               {
                "bag-field" : "MulticastPacketsSent",
                "bag-type" : "uint64_t",
                "register-ops" :
                [{"register": 2, "operation":"-"}],
                "overlay-nodes" :
                [{"name" : "out-multicast-pkts", "type" : "uint64", "field-id" : 5}]
                },
       
                {
                 "bag-field" : "BroadcastPacketsSent",
                 "bag-type": "uint64_t",
                 "register-ops" :
                 [{"register": 2, "operation":"-"}],
                 "overlay-nodes" :
                 [{"name": "out-broadcast-pkts", "type": "uint64", "field-id" : 6}]
                 },
                 
                 {
                  "bag-field" : "InputDrops",
                  "bag-type" : "uint32_t",
                  "register-ops" :
                  [{"register": 1, "operation":"+"}],
                  
                  },
                   {
                  "bag-field" : "InputQueueDrops",
                  "bag-type" : "uint32_t",
                  "register-ops" :
                  [{"register": 1, "operation":"+"}],
                  
                  },
                  {
                  "bag-field" : "OutputDrops",
                  "bag-type" : "uint32_t",
                  "register-ops" :
                  [{"register": 3, "operation":"+"}],
                  
                  },
                  {
                  "bag-field" : "OutputQueueDrops",
                  "bag-type" : "uint32_t",
                  "register-ops" :
                  [{"register": 3, "operation":"+"}],
                  
                  },
       
                 {
                  "bag-field" : "UnknownProtocolPacketsReceived",
                  "bag-type" : "uint32_t",
                  "overlay-nodes" :
                  [{"name": "in-unknown-protos", "type": "uint64", "field-id" : 7}]
                  },
         
                  {
                   "bag-field" : "InputErrors",
                   "bag-type" : "uint32_t",
                   "overlay-nodes" :
                   [{"name": "in-errors", "type" : "uint32", "field-id" : 8}]
                   },
       
                   {
                    "bag-field" : "OutputErrors",
                    "bag-type" : "uint32_t",
                    "overlay-nodes" :
                    [{"name" : "out-errors", "type" : "uint32", "field-id" : 9}]
                    },
           
                    {
                     "bag-field" : "LastDiscontinuityTime",
                     "bag-type" : "uint32_t",
                     "overlay-nodes" :
                     [{"name" : "last-clear", "type" : "yang:date-and-time", "field-id" : 10}]
                     }
    ],
    #at the very end process register decode operations
    "register-ops":
    [
     {"register":0, 
      "operation": "decode",
      "overlay-nodes" :
      [{"name" : "in-unicast-pkts", "type": "uint64", "field-id" : 11}]
     },
     
     {"register":1, 
      "operation": "decode",
      "overlay-nodes" :
      [{"name" : "in-discards", "type": "uint64", "field-id" : 12}]
     },
     
     {"register":2, 
      "operation": "decode",
      "overlay-nodes" :
      [{"name" : "out-unicast-pkts", "type": "uint64", "field-id" : 13}]
     },
    
    {"register":3, 
      "operation": "decode",
      "overlay-nodes" :
      [{"name" : "out-discards", "type": "uint64", "field-id" : 14}]
     },
     
     
     ]   
}

ocif__ifstatsbag_generic__interface_overlay_node = {
    "conditions" :[
        {
            "name" : "is_naming_element_subinterface",
            "index" : 0,
            "match-value" : False
        }
    ],
    "name" : "state",
    "field-id" : 2,
    "overlay-nodes" :  [ ocif__ifstatsbag_generic__state_counters_overlay_node ]
}

ocif__ifstatsbag_generic__subinterface_state_overlay_node = {
    "name" : "state",
    "field-id" : 2,
    "naming-element-nodes" : 
     [
       {
        "index" : 0,
         "name": "index",
         "type": "string" ,
         "subinterface-index" : True,
         "field-id" : 1,
         "key" : False
        
        }
     ],
    "overlay-nodes" :  [ ocif__ifstatsbag_generic__state_counters_overlay_node ]

}
ocif__ifstatsbag_generic__subinterfaces_overlay_node = {
    "name" : "subinterfaces",
    "conditions" :[
        {
            "name" : "is_naming_element_subinterface",
            "index" : 0,
            "match-value" : True
        }
    ],
    "field-id" : 2,
    "overlay-nodes" :
    [
     {
      "name" : "subinterface",
      "field-id" : 1,
      "naming-element-nodes" :
      [
       {
        "index" : 0,
        "name" : "index",
        "type" : "string",
        "subinterface-index" : True,
        "field-id" : 1,
        "key" : True
       }
      ],
      "overlay-nodes" :
      [ocif__ifstatsbag_generic__subinterface_state_overlay_node]
     }  
      
    ]                 
}

mappings = {
    "overlay-model" : "openconfig-interfaces",
    "bag-name": "ifstatsbag_generic",
    "xr-path": "/oper/stats/ifg/<>/latest/generic",
    "mpg-path" : "RootOper.Interfaces.Interface(*)",
    "naming-elements" : 
    [ {
      "type" : "string",
      "index" : 0
      }
    ],
    
    "overlay-nodes" : 
    [   {
        "name" : "openconfig-interfaces:interfaces",
        "namespace" : "http://openconfig.net/yang/interfaces",
        "field-id" : 1,
        "overlay-nodes" : 
        [   {    
             "name" : "interface",
             "field-id" : 1,
             "naming-element-nodes" : 
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string" ,
                 "interface-name" : True,
                  "field-id" : 1,
                  "key" : True
                }
             ],
             
             "overlay-nodes" : 
                 [ ocif__ifstatsbag_generic__subinterfaces_overlay_node,
                   ocif__ifstatsbag_generic__interface_overlay_node]

            }
                  
        ]     

        }
    
    ] 

}
      
##END bag ifstatsbag_generic #################################################
######################################################################

overlay_mappings = [mappings]

