# -----------------------------------------------------------------------------
# optics_edm_info 
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------


ocplatform__optics_ui__transceiver__state_overlay_node = {
    "name" : "state",
    "field-id": 1,
    "bag-mapping-nodes" : [
        {
            "bag-field" : "FormFactor",
            "bag-type" : "enum",
            "overlay-nodes" :
            [
              {
                "name" : "form-factor",
                "field-id" : 1,
                "type" : "enum",
                "enum-map" :
                {
                   0  : 'openconfig-transport-types:OTHER', #not-set
                   1  : 'openconfig-transport-types:OTHER', #invalid
                   2  : 'openconfig-transport-types:OTHER', #cpak
                   3  : 'openconfig-transport-types:OTHER' , #cxp
                   4  : 'openconfig-transport-types:SFP_PLUS' , #sfp-plus
                   5  : 'openconfig-transport-types:QSFP' , #qsfp
                   6  : 'openconfig-transport-types:QSFP' , #qsfp-plus
                   7  : 'openconfig-transport-types:QSFP28', #qsfp28
                   8  : 'openconfig-transport-types:SFP', #sfp
                   9  : 'openconfig-transport-types:CFP' , #cfp
                   10 : 'openconfig-transport-types:CFP2' , #cfp2
                   11 : 'openconfig-transport-types:CFP4' , #cfp4
                   12 : 'openconfig-transport-types:XFP' , #xfp
                   13 : 'openconfig-transport-types:X2' , #x2
                   14 : 'openconfig-transport-types:NON_PLUGGABLE', #non-pluggable
                   15 : 'openconfig-transport-types:OTHER' , #other
                }
              },
            ]
        },

        {
            #convert boolean to enum
            "bag-field" : "OpticsPresent",
            "bag-type" : "boolean",
            "register-ops" :
            [{"register" : 0, "operation" : "load"}],
        
 
        },

        {
            "bag-field" : "Alarm_Detected",
            "bag-type"  : "boolean",
            "overlay-nodes" :
                            [ {"name" : "fault-condition",
                                "type" : "boolean" ,
                                "field-id" : 13
                              }
                            ]
        },


       {
            "bag-field" : "TransceiverInfo",
            "bag-type" : "subtype",
            "bag-mapping-nodes" : [
               
                 {
                     "bag-field" : "ConnectorType",
                     "bag-type" : "enum",
                     "overlay-nodes" :
                     [
                        {"name" : "connector-type",
                         "type" : "enum",
                         "field-id" : 3,
                         "enum-map" :
                         {
                            0 : "openconfig-transport-types:FIBER_CONNECTOR_TYPE",      #optics-connect-or-not-set
                            1 : "openconfig-transport-types:SC_CONNECTOR",      #optics-sc-connect-or
                            2 : "openconfig-transport-types:LC_CONNECTOR",       #optics-lc-connect-or
                            3 : "openconfig-transport-types:MPO_CONNECTOR",       #optics-mpo-connect-or
                            4 : "openconfig-transport-types:FIBER_CONNECTOR_TYPE",       #optics-undefined-connect-or

                         }
                        }
                     ]
                 },

                 {
                     "bag-field" : "InternalTemperature",
                     "bag-type" : "int32",
                     "overlay-nodes" :
                     [
                        {"name" : "internal-temp",
                         "type" : "int16",
                         "field-id" : 4

                        }

                     ]

                 },

                 {
                     "bag-field" : "VendorInfo",
                     "bag-type" : "string",
                     "overlay-nodes":
                     [
                        {"name" : "vendor",
                         "type" : "string",
                         "field-id" : 5
                        }
                     ]
                 },

                 {
                     "bag-field" : "OpticsVendorPart",
                     "bag-type" : "string",
                     "overlay-nodes":
                     [
                       {"name" : "vendor-part",
                        "type" : "string",
                        "field-id" : 6
                       }
                     ]
                 },

                 {
                     "bag-field" : "OpticsVendorRev",
                     "bag-type" : "string",
                     "overlay-nodes":
                     [
                       {"name" : "vendor-rev",
                        "type" : "string",
                        "field-id" : 7
                       }
                     ]
                 },

                 {
                     "bag-field" : "EthernetComplianceCode",
                     "bag-type" : "enum",
                     "overlay-nodes":
                     [
                       {"name" : "ethernet-compliance-code",
                        "type" : "enum",
                        "field-id" : 8,
                        "enum-map":
                        {
                                0:  "openconfig-transport-types:ETH_UNDEFINED", #optics-eth-not-set
                                1:  "openconfig-transport-types:ETH_10GBASE_LRM", #optics-eth-10gbase-lrm
                                2:  "openconfig-transport-types:ETH_10GBASE_LR", #optics-eth-10gbase-lr
                                3:  "openconfig-transport-types:ETH_10GBASE_ZR", #optics-eth-10gbase-zr
                                4:  "openconfig-transport-types:ETH_10GBASE_ER", #optics-eth-10gbase-er
                                5:  "openconfig-transport-types:ETH_10GBASE_SR", #optics-eth-10gbase-sr
                                6:  "openconfig-transport-types:ETH_UNDEFINED", #optics-eth-10gbase
                                7:  "openconfig-transport-types:ETH_40GBASE_CR4", #optics-eth-40gbase-cr4
                                8:  "openconfig-transport-types:ETH_40GBASE_SR4", #optics-eth-40gbase-sr4
                                9:  "openconfig-transport-types:ETH_40GBASE_LR4", #optics-eth-40gbase-lr4
                                10: "openconfig-transport-types:ETH_40GBASE_ER4", #optics-eth-40gbase-er4
                                11: "openconfig-transport-types:ETH_40GBASE_PSM4", #optics-eth-40gbase-psm4
                                12: "openconfig-transport-types:ETH_UNDEFINED", #optics-eth-40gbase-csr4
                                13: "openconfig-transport-types:ETH_UNDEFINED", #optics-eth-40gbase-sr-bd
                                14: "openconfig-transport-types:ETH_UNDEFINED", #optics-eth-40g-aoc
                                15: "openconfig-transport-types:ETH_4X10GBASE_LR", #optics-eth-4x10gbase-lr
                                16: "openconfig-transport-types:ETH_4X10GBASE_SR", #optics-eth-4x10gbase-sr
                                17: "openconfig-transport-types:ETH_100G_AOC", #optics-eth-100g-aoc
                                18: "openconfig-transport-types:ETH_100G_ACC", #optics-eth-100g-acc
                                19: "openconfig-transport-types:ETH_100GBASE_SR10", #optics-eth-100gbase-sr10
                                20: "openconfig-transport-types:ETH_100GBASE_SR4", #optics-eth-100gbase-sr4
                                21: "openconfig-transport-types:ETH_100GBASE_LR4", #optics-eth-100gbase-lr4
                                22: "openconfig-transport-types:ETH_100GBASE_ER4", #optics-eth-100gbase-er4
                                23: "openconfig-transport-types:ETH_100GBASE_CWDM4", #optics-eth-100gbase-cwdm4
                                24: "openconfig-transport-types:ETH_100GBASE_CLR4", #optics-eth-100gbase-clr4
                                25: "openconfig-transport-types:ETH_100GBASE_PSM4", #optics-eth-100gbase-psm4
                                26: "openconfig-transport-types:ETH_UNDEFINED", #optics-eth-100gbase-cr4
                                27: "openconfig-transport-types:ETH_UNDEFINED", #optics-eth-100gbase-al
                                28: "openconfig-transport-types:ETH_UNDEFINED", #optics-eth-100gbase-pl
                                29: "openconfig-transport-types:ETH_UNDEFINED", #optics-eth-undefined
                        }
                       }
                     ]
                 },

                 {
                     "bag-field" : "SonetApplicationCode",
                     "bag-type" : "enum",
                     "overlay-nodes" :
                     [
                      {"name" : "sonet-sdh-compliance-code",
                        "type" : "enum",
                        "field-id" : 9,
                        "enum-map" :
                        {
                            0 : "openconfig-transport-types:SONET_UNDEFINED" , #optics-sonet-not-set
                            1 : "openconfig-transport-types:VSR2000_3R2" , #optics-vsr2000-3r2
                            2 : "openconfig-transport-types:VSR2000_3R3" , #optics-vsr2000-3r3
                            3 : "openconfig-transport-types:VSR2000_3R5" , #optics-vsr2000-3r5
                            4 : "openconfig-transport-types:SONET_UNDEFINED" , #optics-sonet-undefined 
                        }
                     
                     }
                     ]
                 },

                 {
                     "bag-field" : "OtnApplicationCode",
                     "bag-type" : "enum",
                     "overlay-nodes" :
                     [
                      {"name" : "otn-compliance-code",
                        "type" : "enum",
                        "field-id" : 10,
                        "enum-map" :
                        {
                            0 : "openconfig-transport-types:OTN_UNDEFINED", #optics-not-set
                            1 : "openconfig-transport-types:P1L1_2D1", #optics-p1l1-2d1
                            2 : "openconfig-transport-types:P1S1_2D2", #optics-p1s1-2d2
                            3 : "openconfig-transport-types:P1L1_2D2", #optics-p1l1-2d2
                            4 : "openconfig-transport-types:OTN_UNDEFINED", #optics-undefined 
                        }

                     
                     }
                     ]
                 },
                 {
                     "bag-field" : "OpticsSerialNo",
                     "bag-type": "string",
                     "overlay-nodes" :
                     [
                       {"name" : "serial-no",
                        "type" : "string",
                        "field-id" : 11
                       }         
                     ]
                 },
                 {
                     "bag-field" : "Date",
                     "bag-type" : "string",
                     "overlay-nodes" :
                     [
                       {"name" : "date-code",
                        "type" : "string",
                        "field-id" : 12
                       }
                     ]
                 }
            ]
        },
 
    ],
                                                          
    "register-ops":
    [
        {
            "register" : 0,
            "operation" : "decode",
            "overlay-nodes":
            [

              {
                "name" : "present",
                "field-id" : 2,
                "type" : "enum",
                "enum-map" :
                 {
                   0  : 'NOT_PRESENT', 
                   1  : 'PRESENT'
                 }
              }
            ]
            
        }
    ]
}

ocplatform__optics_ui__optical_channel__state_overlay_node = {
    "name" : "state",
    "field-id": 1,
    
    "overlay-nodes" : 
    [
        {
            "name" : "chromatic-dispersion",
            "field-id" : 1,
            "bag-mapping-nodes" :
            [
                {
                    "bag-field" : "CD",
                    "bag-type" : "int32",
                    "overlay-nodes" :
                    [
                        {
                            "name" : "instant",
                            "field-id" : 1,
                            "type" : "decimal64"
                        }
                    ]

                 }
            ],
               
        },
        
        {
            "name" : "second-order-polarization-mode-dispersion",
            "field-id" : 2,
            "bag-mapping-nodes" :
            [
                {
                    "bag-field" : "SecondOrderPolarizationModeDispersion",
                    "bag-type" : "string",
                    "overlay-nodes" :
                    [
                        {
                            "name" : "instant",
                            "field-id" : 1,
                            "type" : "decimal64"
                        }
                    ]
                }
            ]
               
        },
        {
            "name" : "polarization-dependent-loss",
            "field-id" : 3,
            "bag-mapping-nodes" :
            [
                {
                    "bag-field" : "PolarizationDependentLoss",
                    "bag-type" : "string",
                    "overlay-nodes" :
                    [
                        {
                            "name" : "instant",
                            "field-id" : 1,
                            "type" : "decimal64"
                        }
                    ]
                }
            ]
               
        },
     
    ],
    
}

ocplatform__optics_ui__transceiver_overlay_node = { 
    "name" : "openconfig-platform-transceiver:transceiver",
    "namespace" : "http://openconfig.net/yang/platform/transceiver",
    "field-id": 1001,  # augmentation
    "conditions" : [
        {
            "name" : "is_naming_element_transceiver",
           "index" : 0,
           "match-value" : True
            
        }
    ],
    "overlay-nodes" :
    [ ocplatform__optics_ui__transceiver__state_overlay_node ]
}

ocplatform__optics_ui__optical_channel_overlay_node = { 
    "name" : "openconfig-terminal-device:optical-channel",
    "namespace" : "http://openconfig.net/yang/terminal-device",
    "field-id": 2001,  # augmentation
    "conditions" : [
        {
            "name" : "is_naming_element_optical_channel",
            "index" : 0,
            "match-value" : True
        }
    ],
                                                       
    "overlay-nodes" :
    [ ocplatform__optics_ui__optical_channel__state_overlay_node ]
}


mappings = {
    "overlay-model" : "openconfig-platform",
    "bag-name" : "optics_edm_info",
    "bag-file" : "optics_ui",
    "xr-path" : "/oper/optics/if/<>/optics_info",
    "mpg-path": "RootOper.Optics.Interface(*).OpticsInfo",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0
      }
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-platform:components",
        "namespace" : "http://openconfig.net/yang/platform",
        "field-id" : 1,
        "overlay-nodes" :
        [   {
             "name" : "component",
             "field-id" : 1,
             "naming-element-nodes" :
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string" ,
                 "field-id": 1,
                 "key": True,
                 'transceiver-or-optical-channel-name' : True

                }
             ],

             "overlay-nodes" : [ ocplatform__optics_ui__transceiver_overlay_node,
                                ocplatform__optics_ui__optical_channel_overlay_node ]

            }

        ]

        }

    ]

}

# END BAG optics_edm_info
#################################################################

overlay_mappings = [mappings]

