# -----------------------------------------------------------------------------
# ipv4_unicast_neighbor_adj_rib_out_pre_num_routes.py 
#
# August 2017, Manu Radhakrishna
#
# Copyright (c) 2017-2018 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

num_routes_bag_mapping_node = {
        'bag-field' : 'NumRoutes',
        'bag-type' : 'uint64_t',
        'overlay-nodes' : [
            {
                'name' : 'num-routes',
                'field-id' : 2,
                'type' : 'uint64'
            }
         ]
}

loc_rib_overlay_node = {
    
    "name" : "loc-rib",
    'field-id' : 1,
    'bag-mapping-nodes' : [
        num_routes_bag_mapping_node
    ]
}

def get_loc_rib_mapping(index, 
                        af_type, 
                        af_type_field_id, 
                        register_ops):
    mappings = {
        "overlay-model" : "openconfig-rib-bgp",
        "namespace" : "http://openconfig.net/yang/rib/bgp",
        "bag-name" : "bgp_oc_rib_common_bag",
        "bag-file" : "bgp_oc",
        "xr-path" :  '/oper/oc-bgp/gl/instance/default/act/vrf/default/bgp_rib/afi/{0}/loc_rib/table_common'.format(index),

        "overlay-nodes" :
        [{
         "name" : "openconfig-rib-bgp:bgp-rib",
         "field-id" : 1,
         "overlay-nodes" :
         [{
          "name" : "afi-safis",
          "field-id" : 1,
          "overlay-nodes" : 
          [{
           "name" : "afi-safi",
           "field-id" : 1,
           "overlay-nodes" : 
           [{
            "name" : af_type,
            "field-id" : af_type_field_id,
            "overlay-nodes" : [ loc_rib_overlay_node ]
            }],
        "register-ops": register_ops
           }]
          }]
        }]
    }
    return mappings


def get_neighbors_overlay_node(rib_field_name, rib_field_id):
    
    neighbors_overlay_node = {
        "name" : "neighbors",
        'field-id' : 2,
        'overlay-nodes': 
        [
         {
          'name' : 'neighbor',
          'field-id' : 1,
          "naming-element-nodes" :
          [
           {
            "index" : 0,
            "name": "neighbor-address",
            "type": "string" ,
            "field-id": 1,
            "key": True,
           }
          ],
          'overlay-nodes' : 
          [
           {
            'name' : rib_field_name,
            'field-id' : rib_field_id,
            'bag-mapping-nodes' : [ num_routes_bag_mapping_node ] 
           }
          ]
        }
       ]
    }
    return neighbors_overlay_node

def get_neighbors_mapping(index, af_type, af_type_field_id, 
                          register_ops, rib_field_path_segment,
                          rib_field_name, rib_field_id):
    mappings = {
        "overlay-model" : "openconfig-rib-bgp",
        "bag-name" : "bgp_oc_rib_common_bag",
        "bag-file" : "bgp_oc",
        "xr-path" :  
           '/oper/oc-bgp/gl/instance/default/act/vrf/default/bgp_rib/afi/{0}/neighbors/<>/{1}/table_common'.format(index,
                                                                                                            rib_field_path_segment),
        "naming-elements" : [ { "type" : "string", "index" : 0 }],
        "overlay-nodes" :
        [   
         {
          "name" : "openconfig-rib-bgp:bgp-rib",
          "namespace" : "http://openconfig.net/yang/rib/bgp",
          "field-id" : 1,
          "overlay-nodes" :
          [   
            {
             "name" : "afi-safis",
             "field-id" : 1,
             "overlay-nodes" : 
             [ 
              {
               "name" : "afi-safi",
               "field-id" : 1,
               "overlay-nodes" : 
               [
                {
                  "name" : af_type,
                  "field-id" : af_type_field_id,
                  "overlay-nodes" : [ get_neighbors_overlay_node(rib_field_name, rib_field_id) ]
                 }
                ]
               }
              ],
             "register-ops": register_ops
            }
          ]
         }
        ]
       }

    return mappings

def get_afi_safi_name_reg_ops(afi_safi_name):

    register_ops = [
    {
     "register": 0, 
     "operation":"regmult", 
     "const_value" : 0 
     },
     {
      "register": 0,
      "operation": "decode",
      "overlay-nodes":
      [
       {
        "name" : "afi-safi-name",
        "field-id" : 1,
        "type" : "enum",
        "enum-map" :
         {
          0 : afi_safi_name
         }
        }
       ]
      }
    ]

    return register_ops
    
overlay_mappings = [ get_neighbors_mapping(5, 
                                           'ipv6-unicast',
                                           3,
                                           get_afi_safi_name_reg_ops('openconfig-bgp-types:IPV6_UNICAST'),
                                           'adj_rib_out_pre',
                                           'adj-rib-out-pre',
                                           5) ]

