# -----------------------------------------------------------------------------
# ethernet_port_stats_type.py -- ethernet_port_stats_type bag mapping for
# openconfig-interface
#
# May 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2018 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

ocif__ethernet_port_stats_type__ethernet_state_counters_overlay_node = {
    "name" : "counters",
    "field-id" : 16,
    "bag-mapping-nodes" : [
        {
            "bag-field" : "Received8021QFrames",
            "bag-type" : "uint64_t",
            "overlay-nodes" :
            [{"name" : "in-8021q-frames", "type" : "uint64", "field-id" : 16}]
        },

        {
            "bag-field" : "ReceivedPauseFrames",
            "bag-type" : "uint64_t",
            "overlay-nodes" :
            [{"name" : "in-mac-pause-frames", "type" : "uint64", "field-id" : 17}]
        },

        {
            "bag-field" : "DroppedGiantPacketsGreaterthanMRU",
            "bag-type" : "uint64_t",
            "overlay-nodes" :
            [{"name" : "in-oversize-frames", "type" : "uint64", "field-id" : 18}]
        },

        {
            "bag-field" : "DroppedJabbersPacketsGreaterthanMRU",
            "bag-type" : "uint64_t",
            "overlay-nodes" :
            [{"name" : "in-jabber-frames", "type" : "uint64", "field-id" : 19}]
        },

        {
            "bag-field" : "DroppedEtherStatsFragments",
            "bag-type" : "uint64_t",
            "overlay-nodes" :
            [{"name" : "in-fragment-frames", "type" : "uint64", "field-id" : 20}]
        },

        {
            "bag-field" : "DroppedPacketsWithCRCAlignErrors",
            "bag-type" : "uint64_t",
            "overlay-nodes" :
            [{"name" : "in-crc-errors", "type" : "uint64", "field-id" : 21}]
        },

        {
            "bag-field" : "Transmitted8021QFrames",
            "bag-type" : "uint64_t",
            "overlay-nodes" :
            [{"name" : "out-8021q-frames", "type" : "uint64", "field-id" : 22}]
        },

        {
            "bag-field" : "TransmittedTotalPauseFrames",
            "bag-type" : "uint64_t",
            "overlay-nodes" :
            [{"name" : "out-mac-pause-frames", "type" : "uint64", "field-id" : 23}]
        }

    ]

}

ocif__ethernet_port_stats_type__ethernet_overlay_node = {
    "name" : "openconfig-if-ethernet:ethernet",
    "namespace" : "http://openconfig.net/yang/interfaces/ethernet",
    "field-id" : 2001,
    "overlay-nodes" :
    [
     {
      "name" : "state",
      "field-id" : 16 ,

      "overlay-nodes" :
      [
       ocif__ethernet_port_stats_type__ethernet_state_counters_overlay_node]
     }

    ]
}

mappings = {
    "overlay-model" : "openconfig-interfaces",
    "namespace" : "http://openconfig.net/yang/interfaces",
    "bag-name" : "ethernet_port_stats_type",
    "bag-file" : "ethernet_show_controller.bag",
    "xr-path" : "/oper/ethernet_drvr/stats/ifg/<>",
    "mpg-path" : "RootOper.EthernetInterface.Statistics(*)",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0
      }
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-interfaces:interfaces",
        "field-id" : 16,
        "overlay-nodes" :
        [   {
             "name" : "interface",
             "field-id" : 16,
             "naming-element-nodes" :
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string",
                 "field-id" : 1 ,
                 "key" : True

                }
             ],

             "overlay-nodes" :
             [
              ocif__ethernet_port_stats_type__ethernet_overlay_node]

            }

        ]

        }

    ]

}


## END ethernet_port_stats_type ###########################

overlay_mappings = [mappings]
