# -----------------------------------------------------------------------------
# pmengine_ui.bag/pm_optics_paras -- pmengine_ui/pm_optics_paras bag mapping for 
# openconfig-platform
#
# October 2016, Manu Radhakrishna
#
# Copyright (c) 2016-2017 by Cisco Systems, Inc.
# All rights reserved.
# -----------------------------------------------------------------------------

pm_optics_parameter_string_bag_mapping_nodes = [
                     {
                         "bag-field" : "Average",
                         "bag-type" : "string",
                         "overlay-nodes" : [ {  "name" : "avg",  "field-id" : 2, "type" : "decimal64" } ]
                     },

                     {
                         "bag-field" : "Minimum",
                         "bag-type" : "string",
                         "overlay-nodes" : [ {  "name" : "minimum",  "field-id" : 3, "type" : "decimal64" } ]
                      },

                      {
                         "bag-field" : "Maximum",
                         "bag-type" : "string",
                         "overlay-nodes" : [ {  "name" : "maximum",  "field-id" : 4, "type" : "decimal64" } ]
                         
                      },
                  ]

pm_optics_parameter_string_mult_bag_mapping_nodes = [
                     {
                         "bag-field" : "Average",
                         "bag-type" : "string",
                         "register-dec64-ops":
                         [
                             {"register" : 0, "operation" : "load"  },
                        ],
                                                 
                     },
                     {
                         "bag-field" : "Minimum",
                         "bag-type" : "string",
                         "register-dec64-ops":
                          [
                             {"register" : 1, "operation" : "load"  },
                        ],                        
                      },
                      {
                         "bag-field" : "Maximum",
                         "bag-type" : "int32_t",
                         "register-dec64-ops":
                          [
                             {"register" : 2, "operation" : "load"  },
                        ],                  
                         
                      },
                  ]

pm_optics_parameter_string_reg_dec64_ops = [
                    {"register" : 0, "operation" : "regmult", "const_value" : 100 },
                    {"register" : 0, "operation" : "decode",
                            "overlay-nodes" : [ {  "name" : "avg",  "field-id" : 2, "type" : "decimal64" } ]
                    },

                    {"register" : 1, "operation" : "regmult", "const_value" : 100 },
                    {"register" : 1, "operation" : "decode",
                            "overlay-nodes" : [ {  "name" : "minimum",  "field-id" : 3, "type" : "decimal64" } ]
                    },

                    {"register" : 2, "operation" : "regmult", "const_value" : 100 },
                    {"register" : 2, "operation" : "decode",
                            "overlay-nodes" : [ {  "name" : "maximum",  "field-id" : 4, "type" : "decimal64" } ]
                    },



           
        ]
 
#bag subtype pm_optics_parameter
pm_optics_parameter_bag_mapping_nodes = [
                     {
                         "bag-field" : "Average",
                         "bag-type" : "int32_t",
                         "overlay-nodes" : [ {  "name" : "avg",  "field-id" : 2, "type" : "decimal64" } ]
                     },

                     {
                         "bag-field" : "Minimum",
                         "bag-type" : "int32_t",
                         "overlay-nodes" : [ {  "name" : "minimum",  "field-id" : 3, "type" : "decimal64" } ]
                      },

                      {
                         "bag-field" : "Maximum",
                         "bag-type" : "int32_t",
                         "overlay-nodes" : [ {  "name" : "maximum",  "field-id" : 4, "type" : "decimal64" } ]
                         
                      },
                  ]

state_overlay_node = {
    "name" : "state",
    "field-id": 1,
    "naming-element-nodes" : [
        {
            "index" : 1,
            "name" : "index",
            "field-id" : 1,
            "type" : "uint16",
            "key" : False
        }
    ],
    
    "overlay-nodes" : 
    [
        {
         "name" : "output-power",
         "field-id" : 2,
         "bag-mapping-nodes" : [
             {
                 "bag-field" : "OPT",
                 "bag-type" : "subtype",
                 "bag-mapping-nodes" : pm_optics_parameter_string_mult_bag_mapping_nodes,
                
             }
          ],
          "register-dec64-ops" : pm_optics_parameter_string_reg_dec64_ops,
        },
        {
         "name" : "input-power",
         "field-id" : 3,
         "bag-mapping-nodes" : [
             {
                 "bag-field" : "OPR",
                 "bag-type" : "subtype",
                 "bag-mapping-nodes" : pm_optics_parameter_string_mult_bag_mapping_nodes,
             }
          ],
          "register-dec64-ops" : pm_optics_parameter_string_reg_dec64_ops,
         },
        
         {
         "name" : "laser-bias-current",
         "field-id" : 4,
         "bag-mapping-nodes" : [
             {
                 "bag-field" : "LBC",
                 "bag-type" : "subtype",
                 "bag-mapping-nodes" : pm_optics_parameter_bag_mapping_nodes,
             }
          ]
        },
    
    ]
}


ocplatform__optics_ui__transceiver_overlay_node = { 
    "name" : "openconfig-platform-transceiver:transceiver",
    "namespace" : "http://openconfig.net/yang/platform/transceiver",
    "field-id": 1001,  # augmentation
    "conditions" : [
        {
            "name" : "is_naming_element_transceiver",
            "index" : 0,
             "match-value" : True
        }
    ],
    "overlay-nodes" :
    [ {
        "name" : "physical-channels",
        "field-id" : 2,
        "overlay-nodes" : [
           {
               "name" : "channel",
               "field-id" : 1,
               "naming-element-nodes" : [
                  {
                    "index" : 1,
                    "name" : "index",
                    "field-id" : 1,
                    "type" : "uint16",
                    "key" : True
                    
                    
                    }
                  ],
                 "overlay-nodes" : [
                     state_overlay_node
                  ]    
                      
             }
                
          ]      
        
        }
    ]
            
}

ocplatform__optics_ui__optical_channel__state_overlay_node = {
    "name" : "state",
    "field-id": 1,
    
    "overlay-nodes" : 
    [
        {
            "name" : "chromatic-dispersion",
            "field-id" : 1,
            "bag-mapping-nodes" : [
             {
                 "bag-field" : "CD",
                 "bag-type" : "subtype",
                 "bag-mapping-nodes" : pm_optics_parameter_bag_mapping_nodes, 
                 
             }
          ]
               
        },
        
        {
            "name" : "second-order-polarization-mode-dispersion",
            "field-id" : 2,
            "bag-mapping-nodes" : [
             {
                 "bag-field" : "PMD",
                 "bag-type" : "subtype",
                 "bag-mapping-nodes" : pm_optics_parameter_string_bag_mapping_nodes,
             }
          ]
               
        },
        {
            "name" : "polarization-dependent-loss",
            "field-id" : 3,
            "bag-mapping-nodes" : [
             {
                 "bag-field" : "PDL",
                 "bag-type" : "subtype",
                 "bag-mapping-nodes" : pm_optics_parameter_string_bag_mapping_nodes,
             }
          ]
               
        },
     
    ],
    
}

ocplatform__optics_ui__optical_channel_overlay_node = { 
    "name" : "openconfig-terminal-device:optical-channel",
    "namespace" : "http://openconfig.net/yang/terminal-device",
    "field-id": 2001,  # augmentation
    "conditions" : [
        {
            "name" : "is_naming_element_optical_channel",
            "index" : 0,
             "match-value" : True
        }
    ],
    "overlay-nodes" :
    [ ocplatform__optics_ui__optical_channel__state_overlay_node ]
}

mappings = {
    "overlay-model" : "openconfig-platform",
    "bag-name" : "pm_optics_paras",
    "bag-file" : "pmengine_ui.bag",
     
    # Cisco-IOS-XR-pmengine-oper:performance-management-history/global/periodic/optics-history/optics-port-histories/optics-port-history[name]/optics-second30-history/optics-second30-optics-histories/optics-second30-optics-history[n1]/optics-second30-optics-time-line-instances/optics-second30-optics-time-line-instance[n2]
    # name->component/name, {n1=1 if component is optical channel, else n1->component/physical-channels/channel/index if component is transceiver}, n2=1
    
    "sensor-path" : "Cisco-IOS-XR-pmengine-oper:performance-management-history/global/periodic/optics-history/optics-port-histories/optics-port-history/optics-second30-history/optics-second30-optics-histories/optics-second30-optics-history/optics-second30-optics-time-line-instances/optics-second30-optics-time-line-instance",
    "xr-path" : "/oper/perfmgmt/gl/periodic/optics/interface/<>/30sec/optics/<>/timeline_rev/0x1",

    "naming-elements" :
    [ {
      "type" : "string",
      "index" : 0, 
      },
      {
       "type" : "uint16",
       "index" : 1,
      }
    ],

    "overlay-nodes" :
    [   {
        "name" : "openconfig-platform:components",
        "namespace" :"http://openconfig.net/yang/platform",
        "field-id" : 1,
        "overlay-nodes" :
        [   {
             "name" : "component",
             "field-id" : 1,
             "naming-element-nodes" :
             [
               {
                "index" : 0,
                 "name": "name",
                 "type": "string" ,
                 "field-id": 1,
                 "key": True,
                 #this can be a transceiver name or an optical-channel
                 "transceiver-or-optical-channel-name" : True

                }
             ],

             "overlay-nodes" : [ ocplatform__optics_ui__transceiver_overlay_node,
                                ocplatform__optics_ui__optical_channel_overlay_node ]

            }

        ]

        }

    ]

}
# END BAG pm_optics_paras
#################################################################

overlay_mappings = [mappings]

