#!/bin/bash

#-----------------------------------------------------------------------------
#
# Copyright (c) 2012-2014 by Cisco Systems, Inc.
# All rights reserved.
#
#-----------------------------------------------------------------------------

source /opt/cisco/calvados/script/show_tech_main_fragment

function ExecuteCli {
    echo "====================================================================="
    echo "$@"
    ${EXEC_CONFD_CMD} <<EOF
$@ | nomore
EOF
    echo " "
}

function ExecuteHiddenCli {
    echo "====================================================================="
    echo "$@"
    ${EXEC_CONFD_CMD} <<EOF
unhide debug
secret
$@ | nomore
EOF
    echo " "
}

EXEC_CONFD_CMD="confd_cli"

display() {

    print_main_heading "show tech-support envmon"

    echo " "
    # envmon CLI
    ExecuteCli "show environment"
    echo " "

    echo "PEM driver show_power:"
    /opt/cisco/calvados/sbin/show_power
    echo " "

    # shelfmgr CLI
    ExecuteCli "show platform"
    ExecuteCli "show platform detail"
    ExecuteCli "show inventory all"
    echo " "

    ExecuteCli "show diag detail"
    echo " "

    # alarm CLI
    ExecuteCli "show alarms"
    echo " "

    # led CLI
    ExecuteCli "show led"
    echo " "

    # fpd CLI
    ExecuteCli "show hw-module fpd"
    echo " "

    # System-statistics CLI
    ExecuteCli "show System-statistics Component-name ENVMON_CDUI"
    echo " "
    ExecuteCli "show System-statistics Component-name ENVMON_CPMIRM"
    echo " "
    ExecuteCli "show System-statistics Component-name ENVMON_CPMINM"
    echo " "
    ExecuteCli "show System-statistics Component-name ENVMON_CCC"
    echo " "
    ExecuteCli "show System-statistics Component-name ENVMON_FAN_ALGO"
    echo " "
    ExecuteCli "show System-statistics Component-name ENVMON_PWRM"
    echo " "


    mkdir /misc/disk1/showtech-envmon-dumps
    # log messages
    cp /var/log/messages  /misc/disk1/showtech-envmon-dumps
    echo "Copied /var/log/messages to /misc/disk1/showtech-envmon-dumps"
    echo " "

    # inv dump
    /opt/cisco/calvados/bin/inv_dump_tool node
    mv /var/log/inv_NODE_Dump*  /misc/disk1/showtech-envmon-dumps
    /opt/cisco/calvados/bin/inv_dump_tool rack
    mv /var/log/inv_RACK_Dump*  /misc/disk1/showtech-envmon-dumps
    echo " "
    echo "inv_dump_tool log moved to /misc/disk1/showtech-envmon-dumps"
}

source /opt/cisco/calvados/script/show_tech_file_fragment

