#! python
from queue import Queue
from multiprocessing.managers import BaseManager, SyncManager
import sys
import time 
from multiprocessing import Process
from constants import *
import utils.inst_utils as utils
import re
import os
from utils import get_logger

class ClientManager (SyncManager): pass
ClientManager.register ('get_result_queue')

def _putter(manager, dict):
    queue = manager.get_result_queue()
    queue.put(dict)

def connect_to_server (manager):
    try:
        manager.connect ()
    except:
        raise

def hasNumbers(inputString):
    return bool(re.search(r'\d', inputString))

if __name__ == '__main__':
    dev_added = sys.argv[1]
    logfile = os.path.join (LOGDIR, 'install_node.log')
    os.environ['MP_LOG_FILE'] = logfile
    logger = get_logger(logfile)

    if not os.path.isfile (NODE_ORCH_ADDR_FILE):
        logger.debug ("Server process not up. Return")
        sys.exit (0)

    if hasNumbers (dev_added):
        logger.debug("Device %s added is ignored"%(dev_added))
        sys.exit (0)
    else:
        logger.debug ("Device added and being considered: %s"%(dev_added))

    import json
    address = ()
    with open (NODE_ORCH_ADDR_FILE, 'r') as fd:
        address = tuple(json.load(fd))
        logger.debug ("Address loaded : %s"%(address, ))
    dev_dict = {}
    manager = ClientManager(
            address=address, authkey=INSTAUTHKEY)
    ''' Check if server process is up '''
    connect_proc = Process (target = connect_to_server, args = (manager,))
    connect_proc.start ()
    connect_proc.join (5)
    if connect_proc.is_alive() or connect_proc.exitcode:
        logger.info ("Timedout while connecting to server. Terminating")
        connect_proc.terminate()
        sys.exit (0)
    logger.debug ('Server is up. Proceed with connect here.')
    manager.connect()
    try:
        dev_dict = utils.get_device_vmtype_attached (dev_added)
        logger.debug (dev_dict)
        _putter (manager, dev_dict)
    except:
        logger.debug ('Connected to server but unable to dump data into server queue')
        sys.exit (0)

