# This file is part of parallel prepare

# Temp variables
SYSTEM = "system"
NODE = "node"
CARDINSTFILE = "/root/card_instances.txt"

XR = "xr"
CALVADOS = "calvados"
HOST = "host"
XR_LCP = "xr_lcp"
HOST_REPO = "/install_repo/gl/host"
CAL_REPO = "/install_repo/gl/calvados"
XR_REPO = "/install_repo/gl/xr"
MISC_REPO = "/misc/disk1/tftpboot"
SYSTEM_CFG = "/root/config_system.cfg"
NODE_CFG = "/root/config_node.cfg"
NODE_CFG_ALT = "/var/log/install/config_node.cfg"
GISO_CFG = "/var/log/install/instdb/router.cfg"
GISO_AUTORUN = "/var/log/install/instdb/autorun"
DEFAULTSDRLOC = "sdr/default-sdr"
LOGDIR = '/var/log/install'
DEFAULTSYSLOGFILE = 'inst_update_system.log'
DEFAULTNODELOGFILE = 'inst_update_node.log'
INSTAUTHKEY = b'installparallel'

SYS_ORCH_ADDR_FILE = "/tmp/sys_addr.json"
NODE_ORCH_ADDR_FILE = "/tmp/node_addr.json"
UPDATE_STATUS_FILE = "/tmp/status_update.json"
VM_INFO_FILE = "/tmp/vm_info.json"
UPDATE_STATUS_FILE_XR = "/tmp/status_update.txt"

NODESECTION = 'NodeSection'
SYSTEMSECTION = 'SystemSection'
ISO = 'iso'
RPM = 'rpm'
ISOINFO = 'iso_info.txt'
ISOPATH = 'isopath'
REPOIP = 'repo_ip'
SYSORCHPORT = 'sys_orch_port'
STAGING = 'staging_loc'
ADMINREPO = 'admin_repo'
XRREPO = 'xr_repo'
HOSTREPO = 'host_repo'
PREPLIST = 'prep_list'
PKGLIST = 'pkg_list'
HOSTPKGSIZE = 'host_pkg_size'
CALPKGSIZE = 'cal_pkg_size'
XRPKGSIZE = 'xr_pkg_size'
CALVMS = 'cal_vms'
XRVMS = 'xr_vms'
LCXRVMS = 'lcxr_vms'
XRVMSRP = 'xr_rp_vms'
CALVMSRP = 'cal_rp_vms'
OPID = 'opid'
PkgList = 'PkgList'

HOST_BOOT_SIZE = "HOST_BOOT_PART_SIZE"
CAL_BOOT_SIZE = "CAL_BOOT_PART_SIZE"
XR_BOOT_SIZE = "XR_BOOT_PART_SIZE"
XR_LABEL = "xr_label"
XR_LCP_LABEL = "xr_lcp_label"
CAL_LABEL = "cal_label"
HOST_LABEL = "host_label"

MASTERSWP = 1
LOCALSWP = 2
LOCALREPO = "/install_repo/local"
GLREPO = "/install_repo/gl/instdb"
PREPARESWP = "prepared"
ACTIVESWP = "active"
COMMITTEDSWP = "committed"

SUPPORTED_VMTYPE = [HOST, CALVADOS, XR, XR_LCP]

STAGE1TIMEOUT = 600
STAGE2TIMEOUT = 900

rpm_path = {
            HOST : "rpm",
            CALVADOS : "rpm/calvados",
            XR : "rpm/xr",
            XR_LCP : "rpm/xr"
        }

vm_type = {
            HOST : 1,
            CALVADOS : 2,
            XR : 3,
            XR_LCP : 4 
        }

lvname = { 
            HOST : "host_lv",
            CALVADOS : "calvados_lv",
            XR : "xr_lv",
            XR_LCP : "xr_lcp_lv"
        }

label_vmtype = {
            HOST : "HostOs_lv",
            CALVADOS : "Calvados",
            XR : "XR",
            XR_LCP : "XR_LCP"
        }
