#! /usr/bin/env python

from utils import inst_utils as utils
from utils import errors
import os
from constants import *
import shutil

NESTED_ISO_PLATFORMS = ["ncs5500", "ncs560", "ncs540"]
SYSTEM_IMAGE = "iso/system_image.iso"

def populate_extract_repo (iso_mnt, staging, sdr):
    iso = ''
    temp_mnt = ''
    platform, host_repo_iso, sysadmin_repo_iso, xr_repo_iso, iso_version = \
                utils.read_iso_info_mdata (iso_mnt)
    is_giso = utils.check_iso_is_giso (iso_mnt)
    host_iso = "iso/host.iso"
    sysadmin_iso = os.path.join ("iso", "%s-sysadmin.iso"%(platform))
    xr_iso = os.path.join ("iso", "%s-xr.iso"%(platform))

    file2populate = [host_iso, sysadmin_iso, xr_iso]

    try:
        inst_params = tmp_staging = secondary_staging = ''
        if not staging:
            try:
                inst_params, tmp_staging, secondary_staging = utils.read_install_params (iso_mnt)
            except:
                inst_params, tmp_staging, secondary_staging = utils.read_bootstrap_install_params ()

            staging = tmp_staging
        initrd = os.path.join (iso_mnt, "boot/initrd.img")
        initrd_staging = os.path.join (staging, "tmpXXX")
        initrd_extract_path = utils.run_cmd ("mktemp -d %s"%(initrd_staging))
        
        # If this iso has a nested structure, get system_image.iso from mini.
        if platform in NESTED_ISO_PLATFORMS:
            staging, secondary_staging = utils.get_pd_provided_staging()
            files = [SYSTEM_IMAGE]
            initrd_mini = initrd
            initrd_temp_staging = os.path.join (secondary_staging, "tmpXXX")
            initrd_temp_extract_path = utils.run_cmd ("mktemp -d %s"%(initrd_temp_staging))
            utils.extract_files_from_initrd (initrd_temp_extract_path, initrd_mini, files)
            system_iso = os.path.join (initrd_temp_extract_path, SYSTEM_IMAGE)
            if os.path.isfile (system_iso):
                temp_mnt = utils.mount_iso (system_iso)
                initrd = os.path.join (temp_mnt, "boot/initrd.img")
        
        utils.extract_files_from_initrd (initrd_extract_path, initrd, file2populate)

        if is_giso and platform in NESTED_ISO_PLATFORMS:
            utils.extract_giso_rpms (staging, temp_mnt, initrd, sdr)
        elif is_giso:
            utils.extract_giso_rpms (staging, iso_mnt, initrd, sdr)

        host_iso_in_staging = os.path.join (initrd_extract_path, host_iso)
        if os.path.isfile (host_iso_in_staging) and not os.path.isfile (host_repo_iso):
            shutil.copy (host_iso_in_staging, host_repo_iso)
        sysadmin_iso_in_staging = os.path.join (initrd_extract_path, sysadmin_iso)
        if os.path.isfile (sysadmin_iso_in_staging) and not os.path.isfile (sysadmin_repo_iso):
            shutil.copy (sysadmin_iso_in_staging, sysadmin_repo_iso)
        xr_iso_in_staging = os.path.join (initrd_extract_path, xr_iso)
        if os.path.isfile (xr_iso_in_staging) and not os.path.isfile (xr_repo_iso):
            shutil.copy (xr_iso_in_staging, xr_repo_iso)

        if os.path.isdir (initrd_extract_path):
            utils.run_cmd ("rm -rf %s"%(initrd_extract_path))

        try:
            import pd_utils as pdutils
            nbi, nbi_initrd = pdutils.extract_pd_files_from_initrd (staging, initrd, iso_version)
        except:
            nbi, nbi_initrd = utils.extract_pd_files_from_initrd (staging, initrd, iso_version)
        return os.path.basename(host_repo_iso), os.path.basename(sysadmin_repo_iso), os.path.basename(xr_repo_iso), nbi, nbi_initrd
    except:
        pass
    finally:
        utils.umount_iso (temp_mnt) 
        utils.umount_iso(iso_mnt)
        if os.path.isdir (initrd_extract_path):
            utils.run_cmd ("rm -rf %s"%(initrd_extract_path))
        if os.path.isdir (initrd_temp_extract_path):
            utils.run_cmd ("rm -rf %s"%(initrd_temp_extract_path))

if __name__ == '__main__':
    import sys
    os.chdir(os.path.dirname(sys.argv[0]))
    iso = sys.argv[1]
    sdr = sys.argv[2]
    staging = None
    if len(sys.argv) > 3:
        staging = sys.argv[3]
    
    try:
        if os.path.isfile (iso):
            iso_mnt = utils.mount_iso (iso)
        host_iso, sysadmin_iso, xr_iso, nbi, nbi_initrd = populate_extract_repo (iso_mnt, staging, sdr)
        if nbi is not None and nbi_initrd is not None:
            print '%s %s %s %s %s'%(host_iso, sysadmin_iso, xr_iso, nbi, nbi_initrd)
        else:
	    print '%s %s %s'%(host_iso, sysadmin_iso, xr_iso)
    except:
        pass
    finally:
        utils.umount_iso (iso_mnt)
