#! python

from abc import abstractmethod
import constants as C
import json
from multiprocessing.managers import SyncManager
from queue import Empty
import pickle
from utils.utils_orchestrator import *

class abstractFeeder (): 
    def __init__ (self):
        self.orchobj = None
        self.localqKeys = []

    def progress_update (self, node_done = None, 
                               node_ready = None, 
                               node_abort = None, 
                               progress_str = None ): pass

    def _exit_work_items (self):
        pass

    @abstractmethod
    def parsecfgfile (self, cfgfile, mode): pass

    @abstractmethod
    def feedtasks (self, tasksq, localq, cfgfile): pass

    @abstractmethod
    def _feed_actual_workers (self, item, cfgfile): pass    

    @abstractmethod
    def _helper_fn_worker (self, work_item): pass

def _putter(manager, dict):
    queue = manager.get_result_queue()
    queue.put(dict)

authkey = C.INSTAUTHKEY

class StreamToLogger(object):
    def __init__(self, logger, log_level):
        self.logger = logger
        self.log_level = log_level
        self.linebuf = ''

    def write(self, buf):
        for line in buf.rstrip().splitlines():
            self.logger.log(self.log_level, line.rstrip())

    def flush(self):
        pass

def _update_job_queue (mode, tasks):
    addr = ()
    if mode == C.SYSTEM:
        addr_file = C.SYS_ORCH_ADDR_FILE
    else:
        addr_file = C.NODE_ORCH_ADDR_FILE

    with open (addr_file, 'r') as fd: 
        addr = tuple(json.load(fd))
    class ClientManager (SyncManager): pass
    ClientManager.register ('get_result_queue')
    manager = ClientManager(address=addr, authkey=authkey)
    manager.connect() 
    while True:
        try:
            next_task = pickle.loads(tasks.get_nowait())
            if next_task['type'] == 'function':
                dict_custom = next_task['name'](*next_task['arguments'])
            tasks.task_done()
            if dict_custom:
                for key, value in dict_custom.iteritems():
                    _putter (manager, {key : value})
        except Empty:
            return
        except:
            raise

