#!/usr/bin/python

import glob
import os
import ConfigParser
from utils import errors
from utils import inst_utils as utils
from utils.utils_orchestrator import *
from modules.feeder.feed_n_consume_abstract import *
import constants as C
import pickle
from . import utillogger as logger

'''
    Files created as part of optim workflow. Remove them upon abort.
'''
CFGFILE = C.NODE_CFG
INSTCHKPTFILE = os.path.join (C.LOCALREPO, 'instagt_chkpt')
CALPREPFILEBIN = os.path.join (C.LOCALREPO, "%s-swprofile-%s.bin"%("clos",C.LOCALSWP))
CALPREPFILETXT = os.path.join (C.LOCALREPO, "%s-swprofile-%s.txt"%("clos",C.LOCALSWP))
XRPREPFILEBIN = os.path.join (C.LOCALREPO, C.DEFAULTSDRLOC, "%s-swprofile-%s.bin"%("xr",C.LOCALSWP))
XRPREPFILETXT = os.path.join (C.LOCALREPO, C.DEFAULTSDRLOC, "%s-swprofile-%s.txt"%("xr",C.LOCALSWP))
XRLCPPREPFILEBIN = os.path.join (C.LOCALREPO, C.DEFAULTSDRLOC, "%s-swprofile-%s.bin"%("xr-lcp",C.LOCALSWP))
XRLCPPREPFILETXT = os.path.join (C.LOCALREPO, C.DEFAULTSDRLOC, "%s-swprofile-%s.txt"%("xr-lcp",C.LOCALSWP))
rem_on_abort = [CFGFILE, INSTCHKPTFILE, CALPREPFILEBIN, 
                CALPREPFILETXT, XRPREPFILEBIN, XRPREPFILETXT, 
                XRLCPPREPFILEBIN, XRLCPPREPFILETXT]

def handle_abort (): 
    for vmtype in C.SUPPORTED_VMTYPE:
        utils.update_prep_lvindex (vmtype, '-1')    
    return

class OrchObject (object):
    def __init__ (self, oper_id):
        self.oper_id = int(oper_id) 
        self.vmtype = {}
        self.pkglist = {}
        self.totalPkgSize = 0
        self.iso2upg = ''
        self.repoIP = ''
        self.sysOrchPort = 0
        self.tmpStaging = ''
        self.prepList = []
        self.calVms = []
        self.xrVms = []
        self.xrlcpVms = []
        
    def create_local_orch (self, cfgfile):
        inst = ""  # Instance specific to which install parameters will be read from cfg.
        nodesection2read = "DEFAULT-RP"
        with open (C.CARDINSTFILE, 'r') as f:
            card, insts = f.readline().strip().split(' ')
        config = ConfigParser.ConfigParser()
        config.read (cfgfile)
        sections = config.sections()
        for inst in insts.split(','):
            if inst in sections:
                nodesection2read = inst
                break
            
        self.iso2upg = config.get (C.NODESECTION, C.ISO)
        self.repoIP = config.get (C.NODESECTION, C.REPOIP)
        self.sysOrchPort = config.get (C.NODESECTION, C.SYSORCHPORT)
        self.tmpStaging = config.get (C.NODESECTION, C.STAGING)
        # Check availability of staging location.
        # Check both primary and secondary staging location if unavailable.
        if not os.path.isdir (self.tmpStaging):
            logger.info ("Could not get staging location. Find one appropriately.")
            primary_staging, secondary_staging = utils.get_pd_provided_staging ()
            if os.path.isdir (primary_staging):
                self.tmpStaging = primary_staging
            elif os.path.isdir (secondary_staging):
                self.tmpStaging = secondary_staging
            else:
                msg = 'Staging locations %s and %s is not available'%(primary_staging, secondary_staging)
                utils.send_err_msg_to_sys_orch(msg)
                raise ValueError ("Staging location unavailable")
            
        logger.info ("Staging location considered %s"%(self.tmpStaging))
        self.calVms = config.get (C.NODESECTION, C.CALVMS).split(',')
        self.xrVms = config.get (C.NODESECTION, C.XRVMS).split(',')
        self.xrlcpVms = config.get (C.NODESECTION, C.LCXRVMS).split(',')
        local_ip = utils.get_local_node_ip ()
        if local_ip in self.xrVms:
            self.prepList.append (C.XR)
        if local_ip in self.calVms:
            self.prepList.append (C.CALVADOS)
            self.prepList.append (C.HOST)
        if local_ip in self.xrlcpVms:
            self.prepList.append (C.XR_LCP)


        for vmtype in self.prepList:
            if vmtype == C.XR:
                boot_size = config.get (nodesection2read, C.XR_BOOT_SIZE)
                label = config.get (C.NODESECTION, C.XR_LABEL)
                repo = config.get (C.NODESECTION, C.XRREPO)
                self.totalPkgSize = config.get (C.NODESECTION, C.XRPKGSIZE)
            elif vmtype == C.XR_LCP:
                boot_size = config.get (nodesection2read, C.XR_BOOT_SIZE)
                label = config.get (C.NODESECTION, C.XR_LCP_LABEL)
                repo = config.get (C.NODESECTION, C.XRREPO)
                self.totalPkgSize = config.get (C.NODESECTION, C.XRPKGSIZE)
            elif vmtype == C.CALVADOS:
                boot_size = config.get (nodesection2read, C.CAL_BOOT_SIZE)
                label = config.get (C.NODESECTION, C.CAL_LABEL)
                repo = config.get (C.NODESECTION, C.ADMINREPO)
                self.totalPkgSize = config.get (C.NODESECTION, C.CALPKGSIZE)
            elif vmtype == C.HOST:
                boot_size = config.get (nodesection2read, C.HOST_BOOT_SIZE)
                label = config.get (C.NODESECTION, C.HOST_LABEL)
                repo = config.get (C.NODESECTION, C.HOSTREPO)
                self.totalPkgSize = config.get (C.NODESECTION, C.HOSTPKGSIZE)
            self.vmtype[vmtype] = (boot_size, label, repo)

        return

    def update_obj_for_section (self, cfgfile, vmtype):
        self.pkglist[vmtype] = ''
        config = ConfigParser.ConfigParser()
        config.read (cfgfile)
        section2read = "%s_section"%(vmtype)
        sections = config.sections()
        if section2read in sections:
            self.pkglist[vmtype] = config.get (section2read, C.PKGLIST).split(',')
        return self.pkglist[vmtype]

class Taskfeeder (abstractFeeder):
    def parsecfgfile (self, cfgfile, mode, oper_id): 
        logger.info("NODE")
        self.orchobj = OrchObject(oper_id)
        self.orchobj.create_local_orch (cfgfile)

    def parsecfgfilesection (self, cfgfile, vmtype):
        return self.orchobj.update_obj_for_section (cfgfile, vmtype)

    def feedtasks (self, tasksq, localq):
        task = {}
        '''
        Run pre-check and create partitions for iso preparation on node.
        '''
        task ["type"] = "function"
        task ["name"] = install_pre_check
        task ["arguments"] = (self.orchobj.tmpStaging, self.orchobj.totalPkgSize)
        tasksq.put (pickle.dumps(task))
        lvindex = get_lvindex2prep (self.orchobj.oper_id)
        self.lvindex = lvindex
        dev = os.path.basename(sorted(glob.glob("/dev/vd?"))[-1])
        for key, item in self.orchobj.vmtype.iteritems():
            task = {}
            dev2consider = ''.join(list(dev)[0:2])+chr(ord((list(dev)[2])) + 1)
            task ["type"] = "function"
            task ["name"] = create_and_attach_device
            task ["arguments"] = (key, item[0], item[1], dev2consider, lvindex)
            tasksq.put (pickle.dumps(task))
            localq.append (key)
            dev = dev2consider
        
        return

    '''
        Instantiate work for workers. 
        Input:
        item: {k : v} 
            k = vmtype
            v = device attached.
        cfgfile: Config file for any added configurations to be read per worker.
        Output:
        task: {type: <>, host: <>, name: <>, arguments: <>}
            type: script or function to be run
            host: if script, host on which it is to be run
            name: name of script or function
            arguments: input arguments to script/function.
    '''
    def _feed_actual_workers (self, item, cfgfile):
        task = {}
        pkglist = []
        try:
            for k, v in item.iteritems():
                vmtype = k
                targetdev = v
                pkglist = self.parsecfgfilesection (cfgfile, vmtype)   
                logger.debug("Additional packages to be installed %s"%(','.join(pkglist)))
        except:
            import sys 
            import traceback
            exc_info = sys.exc_info()
            TB = traceback.format_exc()
            logger.error(TB)
            sys.exit (-1)

        task ["type"] = "script"
        task ["host"] = "localhost"
        task ["name"] = "python /opt/cisco/calvados/bin/install_part_prep.py"
        task ["arguments"] = "%s %s %s %d %s %s %s %s %s"%(C.NODE, self.orchobj.oper_id, vmtype, self.lvindex, targetdev, self.orchobj.tmpStaging, self.orchobj.repoIP, self.orchobj.vmtype[vmtype][2], ','.join(pkglist))
        
        return task, vmtype

    def _helper_fn_worker (self, work_item):
        dict_custom = {}
        input_cmd = ""
        if work_item['type'] == 'function':
            dict_custom = eval(work_item['name'])(*work_item['arguments'].split())
        if work_item['type'] == 'script':
            if work_item["host"] == "localhost":
                input_cmd = "%s %s"%(work_item["name"], work_item["arguments"])
            else:
                input_cmd = "%s %s %s %s %s"%(utils.vrf_str, utils.ssh_str, work_item["host"], work_item["name"], work_item["arguments"])
            try:
                run_script (input_cmd)
            except:
                ''' Try again'''
                logger.debug ("Retrying command %s"%(input_cmd))
                run_script (input_cmd)
            dict_custom["check"] = input_cmd
        return input_cmd


    # Prepare the inst_agent checkpoint files.
    def _post_orch_work (self):
        import utils.chkpt as chkpt
        chkpt.instagt_chkpt_file = INSTCHKPTFILE
        chkpt.OPID = self.orchobj.oper_id
        chkpt.create_instagt_chkpt(False)
        return

    def _exit_work_items (self):
        for vmtype in self.orchobj.vmtype.keys():
            lvname = os.path.join ('/dev', 'panini_vol_grp', "%s%s"%(C.lvname[vmtype],self.lvindex))
            utils.detach_volume (lvname)
