#!/usr/bin/python

import os
import ConfigParser
from utils import errors
from modules.feeder.feed_n_consume_abstract import *
import constants as C
import pickle
import utils.iso_params as iso_info
from . import utillogger as logger
from utils.inst_utils import run_cmd,get_local_node_ip
'''
    Files created as part of optim workflow. Remove them upon abort.
'''
CFGFILE = C.SYSTEM_CFG
CFGFILE_NODE = C.NODE_CFG
ADDR_FILE = C.SYS_ORCH_ADDR_FILE
MGRCHKPTFILE = os.path.join (C.GLREPO, 'instmgr_chkpt')
MGRPREPCHKPTFILE = os.path.join (C.GLREPO, 'instmgr_prep_chkpt')
CALPREPFILEBIN = os.path.join (C.GLREPO, "%s-swprofile-%s.bin"%("clos",C.MASTERSWP))
CALPREPFILETXT = os.path.join (C.GLREPO, "%s-swprofile-%s.txt"%("clos",C.MASTERSWP))
XRPREPFILEBIN = os.path.join (C.GLREPO, C.DEFAULTSDRLOC, "%s-swprofile-%s.bin"%("xr",C.MASTERSWP))
XRPREPFILETXT = os.path.join (C.GLREPO, C.DEFAULTSDRLOC, "%s-swprofile-%s.txt"%("xr",C.MASTERSWP))
XRLCPPREPFILEBIN = os.path.join (C.GLREPO, C.DEFAULTSDRLOC, "%s-swprofile-%s.bin"%("xr-lcp",C.MASTERSWP))
XRLCPPREPFILETXT = os.path.join (C.GLREPO, C.DEFAULTSDRLOC, "%s-swprofile-%s.txt"%("xr-lcp",C.MASTERSWP))
rem_on_abort = [CFGFILE, CFGFILE_NODE, MGRCHKPTFILE, MGRPREPCHKPTFILE, CALPREPFILEBIN,
                CALPREPFILETXT, XRPREPFILEBIN, XRPREPFILETXT, ADDR_FILE,
                XRLCPPREPFILEBIN, XRLCPPREPFILETXT]

def handle_abort (): 
    return

class OrchObject (object):
    def __init__ (self, oper_id):
        self.oper_id = int(oper_id)
        self.repoIP = ''
        self.iso2upg = ''
        self.pkgList = []
        self.calVms = []
        self.xrVms = []
        self.xrlcpVms = []
        self.calrpvms = []
        self.xrrpvms = []
        self.nbiimage = ''
        self.nbiinitrd = ''
        self.nbiinitrd_host = ''
        self.agentcfg = ''
        self.iso_version = ''
        self.file2update = C.UPDATE_STATUS_FILE
        self.calVmsDone = []
        self.calVmsReady = []
        self.calVmsAbort = []
        self.upd_progress = []
        
        return

    def create_system_orch (self, cfgfile):
        config = ConfigParser.ConfigParser()
        config.read (cfgfile)
            
        local_ip = utils.get_local_node_ip ()
        self.iso2upg = config.get (C.SYSTEMSECTION, C.ISO)
        self.repoIP = local_ip
        self.pkgList = set(config.get (C.SYSTEMSECTION, C.PKGLIST).split(','))
        self.calVms = config.get (C.SYSTEMSECTION, C.CALVMS).split(',')
        self.xrVms = config.get (C.SYSTEMSECTION, C.XRVMS).split(',')
        self.xrlcpVms = config.get (C.SYSTEMSECTION, C.LCXRVMS).split(',')
        self.xrrpvms =  config.get (C.SYSTEMSECTION, C.XRVMSRP).split(',')
        self.calrpvms =  config.get (C.SYSTEMSECTION, C.CALVMSRP).split(',')
        
        return

    def update_obj_for_cfg (self, cfg):
        self.agentcfg = cfg

    def update_obj_for_iso (self, host_iso, cal_iso, xr_iso, iso_version):
        self.hostiso = host_iso
        self.caliso = cal_iso
        self.xriso = xr_iso
        self.iso_version = iso_version

    def update_obj_for_nbi (self, nbi_img, nbi_initrd, nbi_initrd_host):
        self.nbiimage = nbi_img
        self.nbiinitrd = nbi_initrd
        self.nbiinitrd_host = nbi_initrd_host

    def update_obj_for_pkgs (self, host_pkg, cal_pkg, xr_pkg):
        self.hostpkgs = [x for x in host_pkg.split(',') if x not in self.hostiso]
        self.calpkgs = [x for x in cal_pkg.split(',') if x not in self.caliso]
        self.xrpkgs = [x for x in xr_pkg.split(',') if x not in self.xriso]

class Taskfeeder (abstractFeeder):
    def __init__ (self):
        abstractFeeder.__init__(self)
        self.localqKeys = ['chkpt', 'swp']
        self.fn_pointer = {'chkpt' : self.create_gl_chkpt, 'swp' : self.create_gl_swp}
        
        return

    def progress_update (self, node_done = None,  
                         node_ready = None, node_abort = None, 
                         progress_str = None):
        file2update = self.orchobj.file2update
            
        if node_done:
            self.orchobj.calVmsDone.append (node_done)
            self.orchobj.calVmsReady.remove (node_done)
        if node_ready:
            self.orchobj.calVmsReady.append (node_ready)
        if node_abort:
            self.orchobj.calVmsAbort.append (node_abort)
            self.orchobj.calVmsReady.remove (node_abort)
        if progress_str:
            self.orchobj.upd_progress.append (progress_str)

        total_nodes = len (self.orchobj.calVms)
        done_nodes = len (self.orchobj.calVmsDone)
        mdata_dict = {}
        mdata_dict['OID'] = str(self.orchobj.oper_id)
        mdata_dict['Completed'] = self.orchobj.calVmsDone
        mdata_dict['Progress'] = self.orchobj.calVmsReady
        mdata_dict['Abort'] = self.orchobj.calVmsAbort
        mdata_dict['Updates'] = self.orchobj.upd_progress
        try:
            mdata_dict["Percentage"] = (done_nodes * 100)/total_nodes
        except:
            mdata_dict["Percentage"] = 0
        
        with open(file2update, 'w') as fd:
            fd.write (json.dumps (mdata_dict))

        copy_status_update_rp_nodes (self.orchobj.xrrpvms)

        return

    def parsecfgfile (self, cfgfile, mode, oper_id):
        logger.info("SYSTEM") 
        self.orchobj = OrchObject(oper_id)
        self.orchobj.create_system_orch (cfgfile)

        return

    '''
    Feed tasks to orchestrator machine.
    Update localq with all system level work items. 
    '''
    def feedtasks (self, tasksq, localq):
        task = {}
        
        config_file, host_pkgs, cal_pkgs, xr_pkgs, host_iso, cal_iso, xr_iso, nbi_img, nbi_initrd, nbi_initrd_host, iso_version, giso_config_file, sync_repo_dict, giso_autorun_file = parse_create_iso_cfg (self.orchobj.iso2upg, self.orchobj.repoIP, self.orchobj.pkgList, self.orchobj.calVms, self.orchobj.xrVms, self.orchobj.xrlcpVms)
        self.orchobj.update_obj_for_cfg (config_file)
        self.orchobj.update_obj_for_iso (host_iso, cal_iso, xr_iso, iso_version)
        if nbi_img and nbi_initrd and nbi_initrd_host:
            self.orchobj.update_obj_for_nbi (nbi_img, nbi_initrd, nbi_initrd_host)
        self.orchobj.update_obj_for_pkgs (host_pkgs, cal_pkgs, xr_pkgs)

        if config_file:
            task ["type"] = "function"
            task ["name"] = copy_config_to_cal_nodes
            task ["arguments"] = (config_file, C.NODE_CFG, self.orchobj.calVms)
            tasksq.put (pickle.dumps(task))
        if giso_config_file:
            task ["type"] = "function"
            task ["name"] = copy_gisoconfig_xr_rp_nodes
            task ["arguments"] = (giso_config_file, C.GISO_CFG, self.orchobj.xrrpvms)
            tasksq.put (pickle.dumps(task))
        if giso_autorun_file:
            task ["type"] = "function"
            task ["name"] = copy_gisoconfig_xr_rp_nodes
            task ["arguments"] = (giso_autorun_file, C.GISO_AUTORUN, self.orchobj.xrrpvms)
            tasksq.put (pickle.dumps(task))
        if sync_repo_dict:
            task ["type"] = "function"
            task ["name"] = sync_repo_rps 
            task ["arguments"] = (sync_repo_dict, self.orchobj.calrpvms)
            tasksq.put (pickle.dumps(task))


        for vm in self.orchobj.calVms:
            localq.append (vm)
        ''' 
        Add any other work to be tracked.
        '''
        for key in self.localqKeys:
            task = {}
            task ["type"] = "function"
            task ["name"] = prep_misc_work_items
            task ["arguments"] = (key, do_misc_work_items)
            tasksq.put (pickle.dumps(task))
            localq.append (key)
        
        return

    '''
        Instantiate work for workers. 
        Input:
        item: {k : v} 
            k = IP of an agent
            v = IP of an agent.
        cfgfile: Config file for any added configurations to be read per worker.
        Output:
        task: {type: <>, host: <>, name: <>, arguments: <>}
            type: script or function to be run
            host: if script, host on which it is to be run
            name: name of script or function
            arguments: input arguments to script/function.
    '''
    def _feed_actual_workers (self, item, cfgfile):
        task = {}
        task_key = None
        pkglist = []
        for key, value in item.iteritems():
            if key in self.localqKeys:
                task ["type"] = "function"
                task ["name"] = value
                task ["arguments"] = (self, key)
            else:
                agent_ip = key
                logger.info("Monitor orchestrator execution in %s"%(agent_ip))
                task ["type"] = "script"
                task ["host"] = agent_ip
                task ["name"] = "python /opt/cisco/calvados/bin/orchestrator.py"
                task ["arguments"] = "%s %d"%("node", int(self.orchobj.oper_id))
                task_key = agent_ip
        
        return task, task_key

    def _helper_fn_worker (self, work_item):
        input_cmd = ''
        dict_custom = {}
        try:
            if work_item['type'] == 'function':
                dict_custom = work_item['name'](*work_item['arguments'])
            if work_item['type'] == 'script':
                input_cmd = "%s %s %s %s %s"%(utils.vrf_str, utils.ssh_str, work_item["host"], work_item["name"], work_item["arguments"])
                try:
                    run_script (input_cmd)
                except:
                    '''Try again'''
                    logger.debug ("Retrying command %s"%(input_cmd))
                    run_script (input_cmd)
                dict_custom["check"] = input_cmd
        except:
            raise
        return input_cmd

    # Prepare the inst_mgr checkpoint files.
    def create_gl_chkpt (self):
        try:
            import utils.chkpt as chkpt
            chkpt.XrRpms = []
            chkpt.CalRpms = []
            chkpt.HostRpms = []
            chkpt.instmgr_chkpt_file = MGRCHKPTFILE
            chkpt.instmgr_prep_chkpt_file = MGRPREPCHKPTFILE
            chkpt.OPID = self.orchobj.oper_id
            chkpt.MiniBundleISO = self.orchobj.iso2upg
            chkpt.XrBundleISO = self.orchobj.xriso
            chkpt.CalBundleISO = self.orchobj.caliso
            chkpt.HostBundleISO = self.orchobj.hostiso
            chkpt.Cal_nbi_path = self.orchobj.nbiimage
            chkpt.Cal_nbi_initrd_path = self.orchobj.nbiinitrd
            for pkg in self.orchobj.xrpkgs:
                if not os.path.isfile (pkg):
                    pkg = '%s.x86_64'%(pkg)
                    if not os.path.isfile (pkg):
                        msg = 'Package %s not available in repository during checkpoint creation'%(pkg)
                        utils.send_err_msg_to_sys_orch(msg)
                        raise errors.PrepareChkptCreateFailed ('Pkg %s not available in repo during chkpt creation' %(pkg))
                chkpt.XrRpms.append (os.path.basename(pkg))
            '''
                TBD: Add supported cal architectures per platform. Read from calvados_bootstrap.cfg
                Also note that there could be packages specific to an architecture in calvados.
            '''
            cal_arch = [ 'x86_64' ]
            if 'arm' in utils.read_bootstrap_supported_arch ():
                cal_arch.append ('arm')
            for pkg in self.orchobj.calpkgs:
                for arch in cal_arch:    
                    pkg2consider = '%s.%s'%(pkg, arch)
                    if os.path.isfile (pkg2consider):
                        chkpt.CalRpms.append (os.path.basename(pkg2consider))
                
            for pkg in self.orchobj.hostpkgs:
                for arch in cal_arch:    
                    pkg2consider = '%s.%s'%(pkg, arch)
                    if os.path.isfile (pkg2consider):
                        chkpt.HostRpms.append (os.path.basename(pkg2consider))
                
            chkpt.CalIP  = self.orchobj.calVms
            chkpt.XrIP  = self.orchobj.xrVms
            chkpt.create_instmgr_prep_chkpt (True)
            chkpt.create_instmgr_chkpt(True)
        except:
            import sys
            import traceback
            exc_info = sys.exc_info()
            TB = traceback.format_exc()
            logger.error(TB)
            sys.exit (-1)
        return

    def create_gl_swp (self):
        iso = ''
        rpmlist = []
        iso_mnt = ''
        try:
            for vmtype in C.SUPPORTED_VMTYPE:
                if vmtype == C.HOST:
                    continue
                elif vmtype == C.CALVADOS:
                    iso = self.orchobj.caliso
                    rpmlist = self.orchobj.calpkgs
                elif vmtype == C.XR:
                    iso = self.orchobj.xriso
                    rpmlist = self.orchobj.xrpkgs
                elif vmtype == C.XR_LCP:
                    if not len (self.orchobj.xrlcpVms):
                        continue
                    iso = self.orchobj.xriso
                    rpmlist = self.orchobj.xrpkgs
                try:
                    iso_mnt = utils.mount_iso (iso)
                    iso_info_obj = iso_info.IsoInfo (iso_mnt, C.rpm_path[vmtype], rpmlist)
                    iso_info_obj.create_prepare_swp (iso, 0, vmtype, C.MASTERSWP)
                finally:
                    utils.umount_iso (iso_mnt)
        except:
            import sys
            import traceback
            exc_info = sys.exc_info()
            TB = traceback.format_exc()
            logger.error(TB)
            sys.exit (-1)
        return

    def _post_orch_work (self):
        logger.debug("_post_orch_work")

        sync_files = [ self.orchobj.nbiimage, self.orchobj.nbiinitrd, self.orchobj.nbiinitrd_host ] 
        
        sync_repo_files = {}
        for f in sync_files:
            if not os.path.isfile (f):
                logger.info ("Unable to find file %s in sync repo. Proceeding anyway" %(f))
                continue
            repo = os.path.dirname (f)
            repo_file = os.path.basename (f)
            if not sync_repo_files.has_key(repo):
                sync_repo_files[repo] = []
            sync_repo_files[repo].append (repo_file)
             
        if sync_repo_files:
            for key, item in sync_repo_files.iteritems():
                copy_pkgs_to_repo (key, item, self.orchobj.calrpvms)
        return

