#! python

from multiprocessing import Process
import utils
import sys
from utils import get_logger

class Worker (Process):
    def __init__(self, feedback_queue, name):
        Process.__init__(self, name=name)
        self.logger = get_logger()
        self.feedback_queue = feedback_queue

    def log_info (self, message):
        self.logger.info (message)

    def log_error (self, message):
        self.logger.error (message)

    def saferun (self):
        if self.__target:
            self.__target(*self._args, **self._kwargs)

    def run(self):
        try:
            self.saferun()
            self.runqueue.put ("Successful run for %s"%(self.name))
        except Exception as e:
            self.runqueue.put ("Failed run for %s"%(self.name))
            sys.exit(-1)
        return

class PrepareWorker (Worker):
    def __init__ (self, feedback_queue, input_params, name, modify_fn):
        Worker.__init__ (self, feedback_queue, name)
        self.runqueue = feedback_queue
        self.input_params = input_params
        self.modify_fn = modify_fn
 
    def saferun (self):
        output = self.modify_fn (self.input_params)
        self.log_info (output)

 


