#!/usr/bin/python

import subprocess
import re
import sys
import os
import time
import argparse
from logger_init import get_logger
from threading import Thread

"""
All Global Variables
"""
platform_prefix = "/opt/cisco/calvados/bin/vrfch.sh CTRL_VRF"
platform = None

"""
All Helper Functions
"""

def check_for_var_log_space():
    """ this will check for the /var/log/ availability """
    cmd = get_commands_output('df -Ph /var/log | tail -1 | awk \'{print $5}\'')
    cmd = cmd.split("%")[0]
    if cmd:
        if int(cmd) > 95:
            print "/var/log usage is more than 95%. Pls free the space at /var/log"
            exit()

def exit():
    '''this is used to just exit off the script'''
    print("Exiting")
    os._exit(0)


def get_commands_output(cmd):
    '''this is used to execute any command at with retry logic'''
    attempts = 1
    while attempts <= 3:
        try:
            res = subprocess.Popen(
                [cmd],
                shell=True,
                stdout=subprocess.PIPE,
                stderr=subprocess.PIPE)
            output, error = res.communicate()
            if output:
                return output
            if error:
                print(error.strip())
        except OSError as e:
            print(e.strerror)
        except BaseException:
            print(sys.exc_info()[0])
        print(
            "Attempt: %s, Failed to get the output of cmd :%s" %
            (attempts, cmd))
        time.sleep(0.005)
        attempts += 1
    return  # Return an empty string if failed to get command o/p after 3 retry

def get_rp_cal_output(vm, vm_count, test_cases_list, isMaster, queue_obj):
    """This function will be used to get the output on a RP cal vm. """
    global platform_prefix

    for test_case in test_cases_list:
        cmd = ("%s ssh -q -T -o LogLevel=quiet %s" % (platform_prefix, vm))
        retry_count = 0
        while 1:
            sshProcess = subprocess.Popen([cmd],
                                          stdin=subprocess.PIPE,
                                          stdout=subprocess.PIPE,
                                          stderr=subprocess.PIPE,
                                          shell=True)
            run_cmd_on_rp = test_case
            logger.debug("Executing on %s cmd: %s \n",vm,run_cmd_on_rp)
            sshProcess.stdin.write("%s\n" % (run_cmd_on_rp))
            out, error = sshProcess.communicate()
            if sshProcess.returncode:
                if 'CTRL_VRF scp' in run_cmd_on_rp and retry_count < 10:
                    retry_count += 1
                    logger.debug("CMD Failed, Retrying...")
                    import time
                    time.sleep(1)
                    continue
                else:
                    if retry_count == 10:
                       logger.debug("CMD Failed after multiple retries\n")
                       logger.debug("CMD: Output =%s\n Error= %s\n VM: %s\n",out,error,vm)
                    out = error
                queue_obj.put ("ERROR")
                print "ERROR %s\n" % (out)
                raise RuntimeError("Error CMD=%s returned --->%s" % (run_cmd_on_rp, out))
            else:
                logger.debug("SUCCESS running command %s\n" % (run_cmd_on_rp))
                break

import Queue
def run_on_all_rps_cal(cmds,rps_cal_vms, queue_obj):
    """This function will be used to run all the commands on the RPs cal."""
    threads = [None] * len(rps_cal_vms)
    i = 0
    for vm in rps_cal_vms:
        threads[i] = Thread(
            target=get_rp_cal_output, args=(
                vm, i, cmds, False, queue_obj))
        threads[i].start()
        i = i + 1
    for t in threads:
        t.join()

def prepare_add_clean_cmds(pargs):
    sdr_repo = '/install_repo/gl/instdb/sdr/%s/pkg' (pargs.sdr)
    cal_repo = '/install_repo/gl/calvados'
    xr_repo = '/install_repo/gl/xr'
    cmd_list = []
    cmd = ''
    if pargs.cmd == "rm" or pargs.cmd == 'remove':
        for pkg in pargs.packages :
            cmd = "rm -f %s/%s" %(pargs.destination,pkg)
            cmd_list.append(cmd)
        for pkg in pargs.packages :
            if pargs.destination == "/install_repo/gl/xr":
                cmd = "rm -f %s/%s" %(sdr_repo,pkg)
                cmd_list.append(cmd)
        for pkg in pargs.packages :
            if pargs.destination == "/misc/disk1/tftpboot":
                cmd = "rm -f %s/%s" %(cal_repo,pkg)
                cmd_list.append(cmd)
                cmd = "rm -f %s/%s" %(sdr_repo,pkg)
                cmd_list.append(cmd)
                cmd = "rm -f %s/%s" %(xr_repo,pkg)
                cmd_list.append(cmd)
    return cmd_list


def prepare_cmds(pargs):
    sdr_repo = '/install_repo/gl/instdb/sdr/%s/pkg' % (pargs.sdr)
    cal_repo = '/install_repo/gl/calvados'
    xr_repo = '/install_repo/gl/xr'
    cmd_list = []
    cmd = ''
    if pargs.cmd == "cp" or pargs.cmd == 'copy':
        # scp given packages to give repo
        for pkg in pargs.packages :
            cmd = "%s scp -o LogLevel=quiet %s://%s/%s %s" %(platform_prefix,pargs.lead_xrvm, pargs.source,pkg,pargs.destination)
            cmd_list.append(cmd)
        for pkg in pargs.packages :
            if pargs.destination == "/install_repo/gl/xr":
                cmd = "ln -sf %s/%s %s/%s" %(pargs.destination,pkg, sdr_repo,pkg)
                cmd_list.append(cmd)
        for pkg in pargs.packages :
            if pargs.destination == "/misc/disk1/tftpboot":
                cmd = "ln -sf %s/%s %s/%s" %(pargs.destination,pkg,cal_repo,pkg)
                cmd_list.append(cmd)
                cmd = "ln -sf %s/%s %s/%s" %(xr_repo,pkg,sdr_repo,pkg)
                cmd_list.append(cmd)
                cmd = "ln -sf %s/%s %s/%s" %(pargs.destination,pkg,xr_repo,pkg)
                cmd_list.append(cmd)
    else:
        cmd_list = prepare_add_clean_cmds(pargs)
    return cmd_list

def parsecli():
    # Commands will be commands to be executed on all cal VMs of RP
    
    parser = argparse.ArgumentParser(description="quick install add utility")

    mandatory_args = parser.add_argument_group('required arguments')
    mandatory_args.add_argument('-s', '--source', dest='source', type=str,
                                 action='store',
                                help='Path to find files')
    mandatory_args.add_argument('-d', '--destination', dest='destination', type=str,
                                 action='store',
                                help='where to copy files')
    parser.add_argument('-p', '--packages', nargs='*', help='list of packages')
    parser.add_argument('-c', '--cmd', help='command')
    parser.add_argument('-x', '--lead_xrvm', help='IP of lead XR vm')
    parser.add_argument('-a', '--agents', nargs='*', help='RP agents to add pks')
    parser.add_argument('-sdr','--sdr',help='SDR where packages need to be added')
    pargs = parser.parse_args()

    return pargs




if __name__ == "__main__":
    logfile = os.path.join ('/var/log/install/add_replicate.log')
    logger = get_logger(logfile)
    logger.debug("\n\n ====================================\n")
    start = time.time()
    pargs = parsecli()
    if os.path.exists(logfile) and (pargs.cmd == "cp" or pargs.cmd == 'copy'):
        os.remove(logfile)
    queue_obj = Queue.Queue()
    # Get packages from disk to  repo
    cmd_list = prepare_cmds(pargs)
    # Run command all CAL RP ro fetch the package and move to its repo
    run_on_all_rps_cal(cmd_list,pargs.agents, queue_obj)

    try:
	out = queue_obj.get_nowait()
    except Queue.Empty:
	pass
    else:
	sys.exit (-1)
    end_start = time.time()
    sys.exit(0)
