#! python
import os
import re
import utils.inst_utils as utils
import utils.errors as error
import constants as C

sdr_key_dict = {
        2 : None,
        3 : "default-sdr"
    }

class IsoInfo (object):
    def __init__ (self, isomnt, rpm_path, pkglist=[], buildtimelist=[]):
        self.iso = ''
        self.pkgs = []
        self.isorpms = []
        self.vm_type = ''
        if not buildtimelist:
            buildtimelist = [0] * len(pkglist)
        self.buildtimelist = buildtimelist
        self.optpkgmeta = {}

        if os.path.ismount (isomnt):
            self.isoinfo = os.path.join(isomnt, C.ISOINFO)
        
            rpm_dir = os.path.join(isomnt, rpm_path)
            self.isorpms = [ re.sub ("\.\w+.rpm$", '', f) for f in os.listdir(rpm_dir) \
                        if os.path.isfile(os.path.join(rpm_dir,f)) and ".rpm" in f ]
            
            with open (self.isoinfo, 'r') as info_fd: 
                iso_info_raw = info_fd.read()
                self.vm_type = iso_info_raw[iso_info_raw.find("Type:"):].split(' ')[1].strip()

            self.pkgs = [ os.path.basename(x) for x in pkglist ]
            self.optpkgmeta = dict(zip(self.pkgs, buildtimelist))
        else:
            raise error.PrepareSwpCreateFailed ("Isoinfo %s non-existent"%(iso))

    def create_prepare_swp (self, iso, lvindex, vm, scope):
        import sw_profile as SWP
        import calv_instmgr_pb2 as swp

        img = os.path.basename(iso)
        img_md5 = utils.run_cmd ('md5sum %s'%(iso)).split()[0]
        rpms_in_img = self.isorpms
        opt_pkgs = self.pkgs
        vm_type = int(self.vm_type)
        sdr_key = sdr_key_dict[vm_type]
        swp_scope = scope
        swp_type = C.PREPARESWP
        lv_name = "%s%d"%(C.lvname[vm] , int(lvindex))
        swp_creater = SWP.Create_Swp(swp_scope,swp_type)
        swp_creater.image = img
        swp_creater.md5 = img_md5
        swp_creater.irpms = rpms_in_img
        swp_creater.orpms = opt_pkgs
        swp_creater.orpmsmeta = self.optpkgmeta
        swp_creater.vmtype = vm_type
        swp_creater.vm = vm
        swp_creater.sdr_key = sdr_key
        swp_creater.lv_name = lv_name
        swp_creater.create()
