import os
import sys
import logging
try:
    from logger_mp import MultiProcessHandler
except:
    pass
from logging.handlers import RotatingFileHandler

def get_logger(logger=None, logfile=None):
    if logger:
        if isinstance(logger, logging.Logger):
            logger_i = logger
            if not logfile:
                return logger
        elif isinstance(logger, basestring):
            if not logfile:
                logfile=logger
                logger=None
    logger_dict = {}
    if logfile:
        logger_dict["logfile"] = logfile

    filename=logger_dict.get("logfile", "/var/log/install/install.log")

    if not logfile and len(sys.argv) > 1:
        if sys.argv[1].upper() == "SYSTEM":
            filename = logger_dict.get("logfile", "/var/log/install/install_system.log")
        elif sys.argv[1].upper() == "NODE":
            filename=logger_dict.get("logfile", "/var/log/install/install_node.log")
    mphandler = RotatingFileHandler(filename=filename, mode='a', maxBytes=102400, backupCount=3)
    logger_i = logging.getLogger(filename)
    logger_i.setLevel(logging.DEBUG)
    handlers = logger_i.handlers
    if not os.path.isdir(os.path.dirname(filename)):
        try:
            if os.path.dirname(filename):
                os.makedirs(os.path.dirname(filename))
        except Exception as e:
            raise OSError("Failed to create logging directory for: "+filename)
    for handler in handlers:
        if handler.__class__ == mphandler.__class__ :
            return logger_i
    formatter = logging.Formatter('%(asctime)s %(levelname)s %(module)s %(process)d %(thread)d %(message)s')
    mphandler.setFormatter(formatter)
    mphandler.setLevel(logging.DEBUG)
    logger_i.addHandler(mphandler)

    console = logging.StreamHandler()
    formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
    console.setFormatter(formatter)
    console.setLevel(logging.ERROR)
    logger_i.addHandler(console)

    return logger_i
