#!/usr/bin/python

import subprocess
import re
import sys
import os
import time
import argparse
import commands
from threading import Thread

"""
All Global Variables
"""

platform_prefix = "/opt/cisco/calvados/bin/vrfch.sh CTRL_VRF"

"""
All Helper Functions
"""

def parse_rp_cal_output(output, vm, vm_count, test_cases_list, isMaster):
    '''this parses the multi command output and call the function to
    store the output for each individual plugin'''
    config_found = False
    textfile = []
    test_case_count = 0
    for line in output.readlines():
        print "ERROR %s " %(line)
        sys.exit(-1)

def get_rp_cal_output(vm, vm_count, test_cases_list, isMaster):
    """This function will be used to get the output on a RP cal vm. """
    global platform_prefix
    cmd = ("%s ssh -q -T -o LogLevel=quiet %s" % (platform_prefix,vm))
    print cmd
    sshProcess = subprocess.Popen([cmd],
                                  stdin=subprocess.PIPE,
                                  stdout=subprocess.PIPE,
                                  stderr=subprocess.PIPE,
                                  shell=True)

    for test_case in test_cases_list:
        cmd = test_case
        sshProcess.stdin.write("%s\n" % (cmd))
    sshProcess.stdin.close()
    parse_rp_cal_output(
        sshProcess.stderr,
        vm,
        vm_count,
        test_cases_list,
        isMaster)


def run_on_all_rps_cal(cmds,rps_cal_vms):
    """This function will be used to run all the commands on the RPs cal."""
    threads = [None] * len(rps_cal_vms)
    i = 0
    for vm in rps_cal_vms:
        threads[i] = Thread(
            target=get_rp_cal_output, args=(
                vm, i, cmds, False))
        threads[i].start()
        i = i + 1
    for t in threads:
        t.join()


def prepare_cmd(pargs):
    cmd_list = []
    cmd = ''
    global platform_prefix
    # scp given packages to give repo
    cmd = "%s scp -rp -o LogLevel=quiet %s://%s/* %s" %(platform_prefix,pargs.lead_calvm, pargs.repo,pargs.repo)
    print cmd
    cmd_list.append(cmd)
    return cmd_list

def parsecli():
    # Commands will be commands to be executed on all cal VMs of RP
    
    parser = argparse.ArgumentParser(description="quick install add utility")

    mandatory_args = parser.add_argument_group('required arguments')
    mandatory_args.add_argument('-r', '--repo', dest='repo', type=str,
                                 action='store',
                                help='Repo to sync')
    parser.add_argument('-l', '--lead_calvm', help='IP of lead XR vm')
    parser.add_argument('-o', '--agents', nargs='*', help='RP agents to be synced')
    pargs = parser.parse_args()

    return pargs

if __name__ == "__main__":
    start = time.time()
    pargs = parsecli()
    cmd_list = prepare_cmd(pargs)
    run_on_all_rps_cal(cmd_list,pargs.agents)
         
    end_start = time.time()
    sys.exit(0)
