#! /usr/bin/env python

from google.protobuf import message
import sys
import time
import calv_instmgr_pb2 as swp
import os 
import re
from constants import *
import shutil
from logger_init import get_logger
logger = get_logger()

inst_swp_package = swp.inst_swp_package()
        
swp_pkg_type = ["BASE_PKG",
                "SMU_PKG",
                "ISO_PKG",
                "OPT_PKG", 
                "KER_PKG", 
                "HOST_PKG",
                "RPM_PKG", 
                "SP_PKG"]


class Inst_Swp_Package:
    def __init__(self):
       self.name = None
       self.rpms = []
       self.buildtime = None
       self.pkgtype = None

class Inst_Swp_Image:
    def __init__(self):
       self.name = None
       self.rpms = []
       self.md5 = None 
       self.pkgtype = []

class Inst_Sw_Profile_Sdr_Ext:
    def __init__(self,vmType,sdrKey):
        self.image = Inst_Swp_Image()
        self.vm_type = vmType
        self.sdr_key = sdrKey
        self.checksum = None
        self.len = None
        self.lv_name = None 
        self.pkgs_count = None
        self.version = None
        self.pkgs = []
        self.message = None
   

    def add_image(self,name,md5,rpms):
        self.image.name = name 
        self.image.pkg_type = "BASE_PKG"
        self.image.md5 = md5
        self.image.rpms = rpms

    def get_pkg_type (self, pkgin):
        pkg = str(pkgin)
        pkg_type = "SMU_PKG"
        pkg = pkg.replace ('.x86_64', '') 
        pkg = pkg.replace ('.arm', '') 
        pkg_version = re.split(r'(.*)-(.*)-(.*)', pkg)[3] 
        if pkg_version.endswith ('.host'):
            pkg_type = "HOST_PKG"
        return pkg_type

    def add_pkgs(self,pkg,rpms,build_time=None):
        pkg_obj = Inst_Swp_Package()
        pkg = pkg.replace ('.x86_64', '')
        pkg = pkg.replace ('.arm', '')
        pkg_obj.pkg = pkg
        pkg_obj.buildtime = build_time
        pkg_obj.rpms = rpms
        pkg_obj.pkg_type = self.get_pkg_type (pkg)
        self.pkgs.append(pkg_obj)

    def get_image(self):
        proto_img = self.message.sdr_sw_profile.sw_profile.image
        proto_img.name = self.image.name
        proto_img.md5 = self.image.md5
        proto_img.pkg_type = swp_pkg_type.index(self.image.pkg_type)
        if self.image.rpms :
            for rpm in self.image.rpms :
                proto_img.rpms.extend([rpm])

    def get_pkgs(self):
        proto_pkg = self.message.sdr_sw_profile.sw_profile.pkgs
        package = []
        for pkg in self.pkgs :
            inst_swp_package = swp.inst_swp_package()
            inst_swp_package.name = pkg.pkg
            inst_swp_package.pkg_type = swp_pkg_type.index(pkg.pkg_type)
            inst_swp_package.buildtime = int(pkg.buildtime)
            inst_swp_package.rpms.extend([pkg.pkg])
            package.append(inst_swp_package)
        proto_pkg.extend(package)

    def get_swprofile(self):
        self.message.sdr_sw_profile.sw_profile.version = self.version
        if self.lv_name :
            self.message.sdr_sw_profile.sw_profile.lv_name = self.lv_name
        self.get_image()
        self.get_pkgs()

    def get_sdrswprofile(self):
        if self.sdr_key :
            self.message.sdr_sw_profile.sdr_key = self.sdr_key
        self.message.sdr_sw_profile.vm_type = self.vm_type
        self.get_swprofile()

    def prepare_message(self):
        self.message = swp.inst_sw_profile_sdr_ext()
        self.get_sdrswprofile()
        self.message.len = self.message.ByteSize()
        return self.message

class Create_Swp:
    def __init__(self,swp_scope,swp_type):
        self.swp_scope = swp_scope
        self.swp_type = swp_type
        self.image = None
        self.md5 = None
        self.irpms = None
        self.vmtype = None
        self.orpms = None
        self.sdr_key = None
        self.mymessage = None
        self.lv_name = None
        self.vm = None

    def __validate(self):

        assert(self.image)
        assert(self.md5)
        assert(self.vmtype)
        if self.swp_scope == LOCALSWP:
            assert(self.lv_name)
        if self.vmtype == 3 :
            assert(self.sdr_key)
            assert(self.irpms)

    def create_text_version_swp(self,profile_file_name):
        pkglst = ''
        iso_rpms = ''
        header = "# Software Profile\n# Updated on %s\n# Updated by tool"%(time.asctime())
        if self.sdr_key :
            header1 = "\nLength: %d\nVM Type: %d\nSDR Key: %s\nlv_name: %s"%\
                (self.mymessage.len,self.mymessage.sdr_sw_profile.vm_type,
                 self.mymessage.sdr_sw_profile.sdr_key, 
                 self.mymessage.sdr_sw_profile.sw_profile.lv_name)
        else :
            header1 = "\nLength: %d\nVM Type: %d\nlv_name: %s"%\
                (self.mymessage.len,self.mymessage.sdr_sw_profile.vm_type,
                 self.mymessage.sdr_sw_profile.sw_profile.lv_name)

        header2 = "\nImage: %s\nImage md5: %s\nVersion: %s\n"%\
                (self.mymessage.sdr_sw_profile.sw_profile.image.name,
                 self.mymessage.sdr_sw_profile.sw_profile.image.md5,
                 self.mymessage.sdr_sw_profile.sw_profile.version)
        i = 0 
        for rpm in self.mymessage.sdr_sw_profile.sw_profile.image.rpms :
            i = i + 1
            iso_rpms = iso_rpms + ' -------- iso rpm %d: %s\n'%(i,rpm)
        num_of_pkgs = len(self.mymessage.sdr_sw_profile.sw_profile.pkgs) 

        packages = "Packages (%d) :\n"%(num_of_pkgs)

        i = 0
        for rpm in self.mymessage.sdr_sw_profile.sw_profile.pkgs :
            pkglst = pkglst + ' ---- %d: %s\n'%(i,rpm.name)
            btime = '[Build time: %s]'%(rpm.buildtime)
            pkglst = pkglst+' -------- pkg %d rpm 0: %s %s\n'%(i,rpm.name,btime)
            i = i + 1


        f = open(profile_file_name+'.txt', "w")
        f.write(header+"\n")
        f.write(header1)
        f.write(header2)
        f.write(iso_rpms)
        f.write(packages)
        f.write(pkglst)
        f.close()

    def create_profile_files(self):
        swp_repo_dup = None
        if self.swp_scope == LOCALSWP:
            swp_repo = LOCALREPO
        elif self.swp_scope == MASTERSWP:
            swp_repo = GLREPO
        if self.vm == XR:
            if self.swp_scope == LOCALSWP:
                swp_repo_dup = swp_repo
            prefix = 'xr'
            swp_repo = os.path.join(swp_repo, DEFAULTSDRLOC)
        elif self.vm == XR_LCP:
            if self.swp_scope == LOCALSWP:
                swp_repo_dup = swp_repo
            prefix = 'xr-lcp'
            swp_repo = os.path.join(swp_repo, DEFAULTSDRLOC)
        elif self.vm == CALVADOS:
            prefix = 'clos'
        profile_file_name = os.path.join(swp_repo, "%s-swprofile-%s"%(prefix,self.swp_type))
            
        file_name = profile_file_name + '.bin'
        if os.path.exists(file_name):
            os.unlink (file_name)
        f = open(file_name, "wb") 
        f.write(self.mymessage.SerializeToString())
        f.close()
        self.create_text_version_swp(profile_file_name)
        if swp_repo_dup:
            profile_file_name_dup = os.path.join(swp_repo_dup, "%s-swprofile-%s"%(prefix,self.swp_type))
            file_name_dup = profile_file_name_dup + '.bin'
            shutil.copy (file_name, file_name_dup)
            self.create_text_version_swp(profile_file_name_dup)
        logger.debug("Created  ... %s" % (file_name))
        return 0 

    def create(self):
        self.__validate()
        rpms_in_image = self.irpms
        optional_rpms = self.orpms
        version = self.image.split('-')[-1]
        platform = self.image.split('-')[0]
        hostos_smu = False
        # Collect Data
        profile = Inst_Sw_Profile_Sdr_Ext(self.vmtype,self.sdr_key)
        my_profile = swp.inst_sw_profile_sdr_ext()
        profile.version = version
        profile.lv_name = self.lv_name
        if self.orpms:
            for pkg, buildtime in self.orpmsmeta.iteritems():
                if 'sysadmin-hostos' in pkg:
                    hostos_smu = True
                    break
        if hostos_smu:
            for rpm in self.irpms:
                if 'sysadmin-hostos' in rpm:
                    self.irpms.remove (rpm)
        profile.add_image(self.image,self.md5,self.irpms)
        if self.orpms :
            for pkg, buildtime in self.orpmsmeta.iteritems():
                profile.add_pkgs(pkg,[pkg], buildtime)
                if 'sysadmin-hostos' in pkg or platform not in pkg:
                    ''' 
                    Add hostos package for vmtype host as well.
                    Use identical parameters.
                    Since hostos is an in-place installed package,
                    Buildtime is anyway not significant. 
                    '''
                    host_pkg = pkg.replace ('.admin', '.host')
                    profile.add_pkgs(host_pkg,[host_pkg], buildtime)
    
        # Prepare protobuff message 
        self.mymessage = profile.prepare_message()

        # Create software profile .txt and .bin files
        self.create_profile_files()
        return 0
