#!/usr/bin/python
#------------------------------------------------------------------
# const.py
#
# Copyright (c) 2015-2019 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------
#
from install_health_tool import *
#####################################
# This file contains constants      #
# used by Install Health Tool       #
#####################################


CONST_LEAD_RP_CAL_VM = None

# File paths
LOGFILE = '/var/log/install/inst_health_tool.log'

# Commands Strings
CAL_SHOW_CMD = " /opt/cisco/calvados/bin/show_cmd show"
XR_SHOW_CMD = "/pkg/bin/sdr_instcmd show"
SSH = "ssh"
CAL_INSTMGR_GREP = "ps -ef | grep inst_mgr"

PREPARE_CMD = " install prepare"

# CARD_TYPE
CARDTYPE_LC = "LC"
CARDTYPE_RP = "RP"
CARDTYPE_SC = "SC"
CARDTYPE_FABRIC = "FC"

# VM TYPE
XR = "XR"
CAL = "CAL"

# CARD_STATE_ALLOWED
OPERATIONAL = "OPERATIONAL"
NA = "N/A"

# Platform Type
ncs6k = "ncs6k"
ncs5k = "ncs5k"
ncs5500 = "ncs5500"
ncs560 = "ncs560"
xrv9k = "xrv9k"
zermatt = "zermatt"
ncs1k = "ncs1k"
ncs1004 = "ncs1004"
asr9k = "asr9k"
unknown = "Unknown"

# Platform Prefix dictionary
platform_prefixes = {ncs6k: "chvrf 0",
                     ncs5k: " ",
                     ncs5500: " ",
                     ncs560: " ",
                     xrv9k: " ",
                     zermatt: " ",
                     ncs1k: " ",
                     ncs1004: " ",
                     asr9k: ""
                     }

# host_ip dictionary per platform
hostip = {ncs6k: "10.0.2.2",
          ncs5k: "10.0.2.16",
          ncs5500: "10.0.2.16",
          ncs560: "10.0.2.2",
          xrv9k: "10.0.2.16",
          zermatt: "10.0.2.16",
          ncs1k: "10.0.2.16",
          ncs1004: "10.0.2.16",
          asr9k: "10.0.2.2"
          }

# Install Dir usage limit
DISK_USAGE_LIMIT = 80

###### All data related to plugins ######
CAL_INSTALL_DIR_FOR_SPACE_CHECK = {'/': DISK_USAGE_LIMIT,
                                   '/install_repo': DISK_USAGE_LIMIT,
                                   '/misc/disk1': DISK_USAGE_LIMIT,
                                   '/var/log': DISK_USAGE_LIMIT,
                                   '/misc/config' :DISK_USAGE_LIMIT,
                                   '/misc/scratch' : DISK_USAGE_LIMIT
                                   }

XR_INSTALL_DIR_FOR_SPACE_CHECK = {'/': DISK_USAGE_LIMIT,
                                  '/misc/disk1': DISK_USAGE_LIMIT,
                                  '/var/log': DISK_USAGE_LIMIT,
                                  '/misc/config' :DISK_USAGE_LIMIT,
                                  '/misc/scratch' : DISK_USAGE_LIMIT
                                  }

CAL_INSTALL_MARKER_FILES_CHECK = ['/install/inst_ut_skip_self_test']

XR_INSTALL_MARKER_FILES_CHECK = ['/install/inst_ut_skip_self_test']

CAL_INSTALL_MOUNT_POINTS_CHECK = [
    '/misc/disk1',
    '/install_repo',
    '/var/log',
    '/misc/config',
    '/misc/scratch',
]

XR_INSTALL_MOUNT_POINTS_CHECK = [
    '/misc/disk1',
    '/var/log',
    '/misc/config',
    '/misc/scratch']

SYSTEM_IMAGE_FILE_CHECK = ['/misc/disk1/tftpboot/system_image.iso']
SYSTEM_GRUB_FILE_CHECK = ['/misc/disk1/tftpboot/grub.cfg']
SYSTEM_GRUB_EFI_FILE_CHECK = ['/misc/disk1/tftpboot/grub.efi']
CAL_INSTALL_TMP_STAGING_DIR_CHECK = '"/install/tmp"'

CAL_INSTALL_SYMLINKS_CHECK = [
    '/install_repo/gl/calvados/']

XR_INSTALL_SYMLINKS_CHECK = ['/misc/disk1/tftpboot/system_image.iso']

# Dictionary for the testcases <--> error string <--> error_handler_function
"""
Error Handler Functions
"""


def handle_host_version_error(vm, other_info):
    logger.error("Version of %s host is not same as rest of nodes" %\
                                                        (vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error(" hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
                                                        %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error(" /opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_cal_host_version_error(vm, other_info):
    logger.error("Sysadmin and host versions are not same at node: %s" %\
                                                        (vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error(" hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
                                                        %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_cal_version_error(vm, other_info):
    logger.error("Version of %s sysadmin is not same as rest of nodes" %\
                                                        (vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_cal_smus_error(vm, other_info):
    logger.error("Sysdamin SMUs at node %s are not same as other nodes" %\
                                                        (vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_host_smus_error(vm, other_info):
    logger.error("Host SMUs at node %s are not same as other nodes" %\
                                                        (vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_xr_version_error(vm, other_info):
    logger.error(
        "Version of xr vm %s at node %s is not same as other nodes" %\
                                            (vm.vm_name,vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  sdr %s location all reload" % (vm.vm_name))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_xr_smus_error(vm, other_info):
    logger.error(
        "XR SMUs at node %s for sdr %s are not same as other nodes" %\
                                            (vm.vm_card_location, vm.vm_name))
    logger.error("Please use the below command to fix the issue:")
    logger.error(" sdr %s location all reload" % (vm.vm_name))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_cal_disk_space_error(vm, other_info):
    logger.warning(
        "Sysadmin disk space usage is high at node %s" % (vm.vm_card_location))
    logger.warning("Please check for following usages")
    for x in other_info:
        logger.warning("Directory name: %s and usage is: %s" %\
                                                (x.dir_name, x.dir_usage))
    logger.warning("Clean up the space from above directories")

def handle_xr_disk_space_error(vm, other_info):
    logger.warning(
        "XR disk space usage is high at node %s for %s" %\
                                            (vm.vm_card_location, vm.vm_name))
    logger.warning("Please check for following usages")
    for x in other_info:
        logger.warning("Directory name:%s and usage is: %s" %\
                                                    (x.dir_name, x.dir_usage))
    logger.error("Clean up the space for above directories")

def handle_cal_marker_files_error(vm, other_info):
    logger.error(
        "Marker Files are present at %s for %s" %
        (vm.vm_card_location, vm.vm_name))
    logger.error(" Below are the files present:")
    for x in other_info:
        logger.error(x)

def handle_xr_marker_files_error(vm, other_info):
    logger.error(
        "Marker files are present at %s for %s" %
        (vm.vm_card_location, vm.vm_name))
    logger.error(" Below are the files present:")
    for x in other_info:
        logger.error(x)

def handle_cal_mount_points_error(vm, other_info):
    logger.error("Some mandatory mount points are missing at node %s for %s" %\
                                            (vm.vm_card_location, vm.vm_name))
    logger.error("Below are missing mount points:")
    for x in other_info:
        logger.error(x)
    logger.error("Reimage the node %s to fix the issue"%(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_xr_mount_points_error(vm, other_info):
    logger.error("Some mandatory mount points are missing at node %s for %s" %\
                                            (vm.vm_card_location, vm.vm_name))
    logger.error("Below are missing mount points:")
    for x in other_info:
        logger.error(x)
    logger.error("Reimage the node %s to fix the issue" %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_cal_symlinks_error(vm, other_info):
    logger.error("Following symlinks are missing at node %s" %(vm.vm_card_location))
    for x in other_info:
        logger.error(x)

def handle_system_image_file_error(vm, other_info):
    logger.error("Following image file missing at node %s" %(vm.vm_card_location))
    for x in other_info:
        logger.error(x)

def handle_system_grub_efi_file_error(vm, other_info):
    logger.error("Following grub efi image file missing at node %s" %(vm.vm_card_location))
    for x in other_info:
        logger.error(x)

def handle_cal_tmp_staging_error(vm, other_info):
    logger.error("Following file(s) are present in cal tmp_staging dir at node %s" %(vm.vm_card_location))
    for x in other_info:
        logger.error(x)
    logger.error("Please clean up the reported file(s).")

def handle_cal_install_tmp_staging_error(vm, other_info):
    logger.error("Calvados tmp_staging dir %s  at node %s is not present" %(CAL_INSTALL_TMP_STAGING_DIR_CHECK, vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")
   

def handle_xr_tmp_staging_error(vm, other_info):
    logger.error("Following file(s) are present in xr tmp_staging dir at node %s" %(vm.vm_card_location))
    for x in other_info:
        logger.error(x)
    logger.error("Please clean up the reported file(s).")


def handle_grub_file_error(vm, other_info):
    logger.error("Please use below CLI to recover the grub.cfg file on missing node(s)")
    logger.error('"show install health recover"')   
    logger.error("Following grub file missing at node %s" %(vm.vm_card_location))
    for x in other_info:
        logger.error(x)


def handle_xr_symlinks_error(vm, other_info):
    logger.error("Following symlinks are missing at node %s" %(vm.vm_card_location))
    for x in other_info:
        logger.error(x)

def handle_cal_prepared_packages_error(vm, other_info):
    logger.info("Prepared packages are present at node %s for %s" %\
                                        (vm.vm_card_location, vm.vm_name))
    for x in other_info:
        logger.info(x)

def handle_xr_prepared_packages_error(vm, other_info):
    logger.info("Prepared Packages are present at node %s for %s" %\
                                        (vm.vm_card_location, vm.vm_name))
    for x in other_info:
        logger.info(x)

def handle_cal_master_active_swp_error(vm, other_info):
    logger.error("Master active software profile version at node: %s for :%s"\
                 "is not same as other nodes"%(vm.vm_card_location,vm.vm_name))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_cal_master_committed_swp_error(vm, other_info):
    logger.error(
        "Master committed software profile version at node: %s for :%s"\
        "is not same as other nodes" % (vm.vm_card_location, vm.vm_name))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_cal_local_active_swp_error(vm, other_info):
    logger.error(
        "Local active software profile version at node: %s for: %s"\
        "is not same as other nodes" %(vm.vm_card_location, vm.vm_name))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_cal_local_committed_swp_error(vm, other_info):
    logger.error(
        "Local committed software profile version at node: %s for: %s"\
        "is not same as other nodes"% (vm.vm_card_location, vm.vm_name))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_xr_master_active_swp_error(vm, other_info):
    logger.error(
        "XR master active software profile version at node: %s is not same as"\
        " other nodes"%(vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_xr_master_committed_swp_error(vm, other_info):
    logger.error(
        "XR master committed software profile version at node: %s is not same"\
        " as other nodes"%(vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_xr_local_active_swp_error(vm, other_info):
    logger.error(
        "XR local active software profile version at node: %s is not same as"\
        " other nodes"%(vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_xr_local_committed_swp_error(vm, other_info):
    logger.error(
        "XR local committed software profile version at node: %s is not same"\
        " as other nodes"%(vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_cal_master_active_local_active(vm, other_info):
    logger.error(
        "Sysadmin master active software version is not same as local active"\
        " software version")
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_cal_master_committed_local_committed(vm, other_info):
    logger.error(
        "Sysadmin master committed software version is not same as local"\
        " committed software version")
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_xr_master_active_local_active(vm, other_info):
    logger.error(
        "XR master active software version is not same as local active"\
        " software version")
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_xr_master_committed_local_committed(vm, other_info):
    logger.error(
        "XR master committed software version is not same as local committed"\
        " software version")
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_cal_tftp_boot_image_version(vm, other_info):
    logger.error(
        "mini image of version %s is missing at node: %s" %
        (other_info,vm.vm_card_location))
    logger.error("Use following command to add : install add source <path>"\
            " <mini image of version %s>" % (other_info))

def handle_cal_image(vm, other_info):
    logger.error(
        "Sysadmin iso is missing at node: %s" %
        (vm.vm_card_location))
    logger.error("install extract mini of version: %s" %(other_info))

def handle_system_image_symlink_version(vm, other_info):
    logger.error("system_image.iso symlink is not pointing to current running"\
                 " version: %s %s" %(vm.vm_card_location,other_info))
    if CONST_LEAD_RP_CAL_VM.vm_card_location == vm.vm_card_location:
        logger.error("Use external boot to recover")
    else:
        logger.error("Reimage the node %s to fix the issue"%(vm.vm_card_location))
        logger.error("Run this command for information on how to reimage the node")
        logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def set_const_lead_rp(vm):
    global CONST_LEAD_RP_CAL_VM
    CONST_LEAD_RP_CAL_VM = vm

def handle_system_image_stale_symlink(vm, other_info):
    logger.error(
        "system_image.iso is pointing to non existant file at node %s for %s"%\
                                            (vm.vm_card_location, vm.vm_name))
    if CONST_LEAD_RP_CAL_VM.vm_card_location == vm.vm_card_location:
        logger.error("Use external boot to recover")
    else:
        logger.error("Reimage the node %s to fix the issue"%(vm.vm_card_location))
        logger.error("Run this command for information on how to reimage the node")
        logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")


def handle_lv_state_verification(vm, other_info):
    logger.warning("Below Active and Committed LVs are different at: %s" %\
            (vm.vm_card_location))  
    for k,v in other_info.items():
        logger.warning("%s %s "%(k,v))
    logger.warning("Please run 'install commit' to commit the active software")

def handle_boot_lvs(vm, other_info):
    logger.error("Boot Logical Volume is not proper at node %s" %\
                                                        (vm.vm_card_location))
    for k in other_info:
        logger.error("Expected LV for %s is %s and booted with is: %s"
                %(k[0],k[1],k[2]))

def handle_rpmdb(vm, other_info):
    logger.error("rpmdb is either empty or not present")
    logger.error("Reimage the node %s to recover the system"%\
                                                        (vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error(" /opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_grub_cfg(vm,other_info):
    logger.error("grub config is having incorrect host committed partition at %s"%\
                                                        (vm.vm_card_location))
    logger.error("Reimage the node %s to recover the system" %\
                                                        (vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error(" /opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_cal_active_swp_pkg(vm, other_info):
    logger.error("Software packages for %s VM at node %s are not same as"\
                 " other nodes"% (vm.vm_name,vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  hw-module location %s reload" % (vm.vm_card_location))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_xr_active_swp_pkg(vm, other_info):
    logger.error("Software packages for %s at node %s are not same as other"\
                 " nodes" % (vm.vm_name,vm.vm_card_location))
    logger.error("Please use the below command to fix the issue:")
    logger.error("  sdr %s location all reload" % (vm.vm_name))
    logger.error("If reload does not work, reimage the node %s"
            %(vm.vm_card_location))
    logger.error("Run this command for information on how to reimage the node")
    logger.error("/opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_xr_ld_path_verification(vm, other_info):
    if len(other_info) == 1 and other_info[0] == 'False':
        logger.error("XR load path verification failed for %s at node: %s"\
                                        % (vm.vm_name,vm.vm_card_location))
        logger.error("Reimage the node %s to fix the issue"
                %(vm.vm_card_location))
        logger.error("Run this command for information on how to reimage the node")
        logger.error(" /opt/cisco/calvados/sbin/reimage_chassis -h")
    else:
        if other_info[0] == 'False':
            logger.error("XR load Path Verification failed for %s at node: %s"\
                                        % (vm.vm_name,vm.vm_card_location))
        else:
            logger.error("Following files are not having proper symlinks")
            for x in other_info:
                logger.error(x)
            logger.error("Reimage the node %s to fix the issue"\
                    %(vm.vm_card_location))
            logger.error("Run this command for information on how to reimage the node")
            logger.error(" /opt/cisco/calvados/sbin/reimage_chassis -h")

def handle_cal_ld_path_verification(vm, other_info):
    if len(other_info) == 1 and other_info[0] == 'False':
        logger.error("Sysadmin load path verification failed at node:%s"\
                                %(vm.vm_card_location))
        logger.error("Reimage the node %s to fix the issue"
                %(vm.vm_card_location))
        logger.error("Run this command for information on how to reimage the node")
        logger.error(" /opt/cisco/calvados/sbin/reimage_chassis -h")
    else:
        if other_info[0] == 'False':
            logger.error("Sysadmin load path verification failed at"\
                         " node %s" % (vm.vm_card_location))
        else:
            logger.error("Following files are not having proper symlinks")
            for x in other_info:
                logger.error(x)
            logger.error("Reimage the node %s to fix the issue"
                    %(vm.vm_card_location))
            logger.error("Run this command for information on how to reimage the node")
            logger.error(" /opt/cisco/calvados/sbin/reimage_chassis -h")

error_handlers = {
    'cal_host_same_version': handle_cal_host_version_error,
    'host_version': handle_host_version_error,
    'cal_version': handle_cal_version_error,
    'cal_smus': handle_cal_smus_error,
    'host_smus': handle_host_smus_error,
    'xr_version': handle_xr_version_error,
    'xr_smus': handle_xr_smus_error,
    'cal_disk_space': handle_cal_disk_space_error,
    'xr_disk_space': handle_xr_disk_space_error,
    'cal_marker_files': handle_cal_marker_files_error,
    'xr_marker_files': handle_xr_marker_files_error,
    'cal_mount_points': handle_cal_mount_points_error,
    'xr_mount_points': handle_xr_mount_points_error,
    'cal_stale_symlinks': handle_cal_symlinks_error,
    'xr_stale_symlinks': handle_xr_symlinks_error,
    'cal_prepared_packages': handle_cal_prepared_packages_error,
    'xr_prepared_packages': handle_xr_prepared_packages_error,
    'cal_master_active_swp': handle_cal_master_active_swp_error,
    'cal_master_committed_swp': handle_cal_master_committed_swp_error,
    'cal_local_active_swp': handle_cal_local_active_swp_error,
    'cal_local_committed_swp': handle_cal_local_committed_swp_error,
    'xr_master_active_swp': handle_xr_master_active_swp_error,
    'xr_master_committed_swp': handle_xr_master_committed_swp_error,
    'xr_local_active_swp': handle_xr_master_active_swp_error,
    'xr_local_committed_swp': handle_xr_master_committed_swp_error,
    'cal_master_active_local_active': handle_cal_master_active_local_active,
    'cal_master_committed_local_committed': handle_cal_master_committed_local_committed,
    'xr_master_active_local_active': handle_xr_master_active_local_active,
    'xr_master_committed_local_committed': handle_xr_master_committed_local_committed,
    'cal_tftp_boot_image_version': handle_cal_tftp_boot_image_version,
    'cal_image': handle_cal_image,
    'system_image_version': handle_system_image_symlink_version,
    'system_image_stale_symlink': handle_system_image_stale_symlink,
    'lv_state_verification' : handle_lv_state_verification,
    'boot_lvs' : handle_boot_lvs,
    'rpmdb' : handle_rpmdb,
    'grub_cfg' : handle_grub_cfg,
    'cal_active_swp_pkg' : handle_cal_active_swp_pkg,
    'xr_active_swp_pkg' : handle_xr_active_swp_pkg,
    'xr_ld_path_verification' : handle_xr_ld_path_verification,
    'cal_ld_path_verification' : handle_cal_ld_path_verification,
    'system_image_file' : handle_system_image_file_error,
    'system_grub_file' : handle_grub_file_error,
    'cal_tmp_staging_dir' : handle_cal_tmp_staging_error,
    'xr_tmp_staging_dir' : handle_xr_tmp_staging_error,
    'system_grub_efi_file' : handle_system_grub_efi_file_error,
    'cal_install_tmp_staging_dir' : handle_cal_install_tmp_staging_error    
}
