#!/bin/bash
# Copyright (c) 2013-2014 by Cisco Systems, Inc.
# All Rights Reserved.
#------------------------------------------------------------------

# Argument expected from the program
#<user_name> <password> <sftp_server>  <files to be downloaded> \ 
# <destination_directory> <SFTP/FTP> <CAL/XR>

exec &>/dev/null # this line is added to supress output of this script
cd_cmd="cd"
mk_cmd="mkdir"
if [ "$7" = "cal" ] ;then
chv="/opt/cisco/calvados/bin/vrfch.sh MGMT_VRF "
else
chv="/opt/cisco/calvados/bin/vrfch.sh CTRL_VRF "
fi

username=$1
password=$2
server=$3
files_to_download=$4
dest_dir=$5

dir=`echo ${files_to_download} | sed 's:\(.*/\).*:\1:'`
file=`echo ${files_to_download} | sed 's:\(.*/\)::'`

# Change the directory to install destination directory
if [ ! -d "${dest_dir}" ]; then
    ${mk_cmd} ${dest_dir}
fi

ret=$? 
if [ $ret -ne 0 ]; then
    exit 1
fi

${cd_cmd} ${dest_dir}

if [ "$6" = "sftp" ] ;then
proto_cmd="sftp"
${chv} sshpass -p ${password} ${proto_cmd} ${username}@${server} <<EOF
get ${files_to_download}
EOF
else
proto_cmd="ftp"
${chv} sshpass -p ${password} ${proto_cmd} ${username}@${server} <<EOF
cd ${dir}
get ${file}
EOF
if [ -f ${file} ]
then
    exit 0
else
    exit 2
fi
fi

