#!/bin/bash
#
# Copyright (c) 2013-2014 by Cisco Systems, Inc.
# All Rights Reserved.
#------------------------------------------------------------------

# Argument expected from the program 
#  <tftp_server>  <files to be downloaded> <destination_directory> 

cd_cmd="cd"
mk_cmd="mkdir"
dest_dir=$3
chv="/opt/cisco/calvados/bin/vrfch.sh MGMT_VRF "

proto_cmd="tftp"
server=$1
tftp_sub_cmd="-c get"
files_to_download=$2

err_log_file="err_logs"
err_log="$3/$err_log_file"

# Change the directory to install destination directory
if [ ! -d "${dest_dir}" ]; then
    ${mk_cmd} ${dest_dir}
fi

${cd_cmd} ${dest_dir}

# Download each file
${chv} ${proto_cmd} ${server} ${tftp_sub_cmd} ${files_to_download}  2>&1 | tee -a ${err_log}

