#!/bin/bash
#
# Copyright (c) 2012-2018 by Cisco Systems, Inc. 
# All Rights Reserved.
#------------------------------------------------------------------
action_cmd=$1
cmd_list=$2
cmd_end=""
cmd_middle=""

if [ $# = 0 ]; then 
    cmd_begin="install activate-internal-nopackages"
   /opt/cisco/calvados/bin/vrfch.sh CTRL_VRF /opt/cisco/calvados/confd/bin/maapi --clicmd --unhide internal-command "${cmd_begin}"

else
    case ${action_cmd} in
    --activate_location)
        cmd_begin="install activate-internal-packages location ["
                for ((i=2; i<=$#; i++)); do
            if [[ ${!i} =~ .*,.* ]]
            then
               echo -e "\ninstall command cannot contain ',' characters\n"
               exit
            else
               cmd_middle="${cmd_middle} ${!i}"
            fi
        done

        cmd_end=" ]"
        ;;

    --activate_pkgs) 
        end=$# 
        if [[ ${!end} && ${!end} == "--noprompt" ]]; then
            cmd_begin="install activate-internal-packages noprompt packages ["
            (( end-- ))
        else 
    cmd_begin="install activate-internal-packages packages ["
        fi

        for ((i=2; i<=$end; i++)); do
#            echo "Parameter $i is ${!i}"
            if [[ ${!i} =~ .*,.* ]]
            then
               echo -e "\ninstall command cannot contain ',' characters\n"
               exit
            else
               cmd_middle="${cmd_middle} ${!i}"
            fi
        done

        cmd_end=" ]"
        ;;

    --activate_ids)
    end=$# 
    if [[ ${!end} && ${!end} == "--noprompt" ]]; then
        cmd_begin="install activate-internal-packages noprompt id ["
        (( end-- ))
    else 
        cmd_begin="install activate-internal-packages id ["
    fi
        for ((i=2; i<=$end; i++)); do
#            echo "Parameter $i is ${!i}"
            if [[ ${!i} =~ .*,.* ]]
            then
               echo -e "\ninstall command cannot contain ',' characters\n"
               exit
            else
               cmd_middle="${cmd_middle} ${!i}"
            fi
        done

        cmd_end=" ]"
        ;;

      --noprompt)
        cmd_begin="install activate-internal-nopackages noprompt"
        ;;

   --issu)
       # ISSU Activate - call ISSU Yang schema.
       pkgs=""
       ids=""

       shift
       while getopts ":p:i:" opt; do
           case $opt in
               p)
                   pkgs="packages [ $OPTARG"

                   # May have more than one argument
                   idx=$OPTIND
                   while ! [[ "${!idx}" =~ ^-.* ]] && ! (( idx > $# )) ; do
                       pkgs="${pkgs} ${!idx}"
                       ((idx++))
                   done
                   OPTIND=idx

                   pkgs="${pkgs} ]" ;;

               i)
                   ids="ids [ $OPTARG"

                   # May have more than one argument
                   idx=$OPTIND
                   while ! [[ "${!idx}" =~ ^-.* ]] && ! (( idx > $# )) ; do
                       ids="${ids} ${!idx}"
                       ((idx++))
                   done
                   OPTIND=idx

                   ids="${ids} ]" ;;
           esac
       done

       if [[ -z $pkgs && -z $ids ]]; then
           # No packages, so purely 'activate'
           # Command begins issu_action because the container for action 
           # commands within the ISSU component has that name.
           cmd_begin="issu_action activate"
           cmd_middle=""
           cmd_end=""
       else
           # Some package input, so 'prepare plus activate'
           cmd_begin="issu_action prepare"
           cmd_middle=""
           cmd_end="${pkgs} ${ids} activate true"
       fi
       ;;

        *)
            echo "Invalid command"
    esac

#    echo "cmd_middle is $cmd_middle"

    echo "cmd is = ${cmd_begin} ${cmd_middle} ${cmd_end}" >> /tmp/inst_act_cmd.cmd

    /opt/cisco/calvados/bin/vrfch.sh CTRL_VRF /opt/cisco/calvados/confd/bin/maapi --clicmd --unhide internal-command "${cmd_begin} ${cmd_middle} ${cmd_end}"

fi
